/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.egads.models.tsmm;

import com.yahoo.egads.data.JsonEncoder;
import com.yahoo.egads.data.TimeSeries;
import com.yahoo.egads.models.tsmm.TimeSeriesModel;
import java.util.ArrayList;
import java.util.Properties;
import net.sourceforge.openforecast.ForecastingModel;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.json.JSONObject;
import org.json.JSONStringer;

public abstract class TimeSeriesAbstractModel
implements TimeSeriesModel {
    private static final double TOLERANCE = 1.0E-8;
    protected double bias;
    protected double mad;
    protected double mape;
    protected double mse;
    protected double sae;
    protected String modelName;
    static Logger logger = LogManager.getLogger((String)TimeSeriesModel.class.getName());
    protected boolean errorsInit = false;
    protected int dynamicParameters = 0;

    @Override
    public String getModelName() {
        return this.modelName;
    }

    @Override
    public String getModelType() {
        return "Forecast";
    }

    @Override
    public void toJson(JSONStringer json_out) throws Exception {
        JsonEncoder.toJson(this, json_out);
    }

    @Override
    public void fromJson(JSONObject json_obj) throws Exception {
        JsonEncoder.fromJson((Object)this, json_obj);
    }

    public TimeSeriesAbstractModel(Properties config) {
        if (config.getProperty("DYNAMIC_PARAMETERS") != null) {
            this.dynamicParameters = new Integer(config.getProperty("DYNAMIC_PARAMETERS"));
        }
    }

    private static int compareError(double error1, double error2) {
        if (Double.isNaN(error1) || Double.isNaN(error2)) {
            return 0;
        }
        double diffAbs = Math.abs(error2) - Math.abs(error1);
        if (Math.abs(diffAbs) <= 1.0E-8) {
            return 0;
        }
        return diffAbs > 0.0 ? 1 : -1;
    }

    public static boolean betterThan(TimeSeriesAbstractModel model1, TimeSeriesAbstractModel model2) {
        if (model2 == null) {
            return true;
        }
        int score = 0;
        score += TimeSeriesAbstractModel.compareError(model1.getBias(), model2.getBias());
        score += TimeSeriesAbstractModel.compareError(model1.getMAD(), model2.getMAD());
        score += TimeSeriesAbstractModel.compareError(model1.getMAPE(), model2.getMAPE());
        score += TimeSeriesAbstractModel.compareError(model1.getMSE(), model2.getMSE());
        if ((score += TimeSeriesAbstractModel.compareError(model1.getSAE(), model2.getSAE())) == 0) {
            double mapeDiff = model1.getMAPE() - model2.getMAPE();
            double diff = model1.getBias() - model2.getBias() + model1.getMAD() - model2.getMAD() + (Double.isNaN(mapeDiff) ? 0.0 : mapeDiff) + model1.getMSE() - model2.getMSE() + model1.getSAE() - model2.getSAE();
            return diff < 0.0;
        }
        return score > 0;
    }

    protected void initForecastErrors(TimeSeriesAbstractModel forecaster, TimeSeries.DataSequence data) {
        this.bias = forecaster.getBias();
        this.mad = forecaster.getMAD();
        this.mape = forecaster.getMAPE();
        this.mse = forecaster.getMSE();
        this.sae = forecaster.getSAE();
        this.errorsInit = true;
    }

    protected void initForecastErrors(ForecastingModel forecaster, TimeSeries.DataSequence data) {
        this.bias = forecaster.getBias();
        this.mad = forecaster.getMAD();
        this.mape = forecaster.getMAPE();
        this.mse = forecaster.getMSE();
        this.sae = forecaster.getSAE();
        this.errorsInit = true;
    }

    protected void initForecastErrors(ArrayList<Float> model, TimeSeries.DataSequence data) {
        double sumErr = 0.0;
        double sumAbsErr = 0.0;
        double sumAbsPercentErr = 0.0;
        double sumErrSquared = 0.0;
        int processedPoints = 0;
        int n = data.size();
        for (int i = 0; i < n; ++i) {
            double error = model.get(i).floatValue() - ((TimeSeries.Entry)data.get((int)i)).value;
            sumErr += error;
            sumAbsErr += Math.abs(error);
            sumAbsPercentErr += Math.abs(error / (double)((TimeSeries.Entry)data.get((int)i)).value);
            sumErrSquared += error * error;
            ++processedPoints;
        }
        this.bias = sumErr / (double)processedPoints;
        this.mad = sumAbsErr / (double)processedPoints;
        this.mape = sumAbsPercentErr / (double)processedPoints;
        this.mse = sumErrSquared / (double)processedPoints;
        this.sae = sumAbsErr;
        this.errorsInit = true;
    }

    public double getBias() {
        if (!this.errorsInit) {
            return -1.0;
        }
        return this.bias;
    }

    public double getMAD() {
        if (!this.errorsInit) {
            return -1.0;
        }
        return this.mad;
    }

    public double getMAPE() {
        if (!this.errorsInit) {
            return -1.0;
        }
        return this.mape;
    }

    public double getMSE() {
        if (!this.errorsInit) {
            return -1.0;
        }
        return this.mse;
    }

    public double getSAE() {
        if (!this.errorsInit) {
            return -1.0;
        }
        return this.sae;
    }
}

