/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.egads.models.tsmm;

import com.yahoo.egads.data.TimeSeries;
import com.yahoo.egads.models.tsmm.TimeSeriesAbstractModel;
import com.yahoo.egads.utilities.FileUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Properties;

public class OlympicModel
extends TimeSeriesAbstractModel {
    private static final long serialVersionUID = 1L;
    protected int numWeeks;
    protected int numToDrop;
    protected TimeSeries.DataSequence data;
    protected int[] timeShifts;
    protected int[] baseWindows;
    protected ArrayList<Float> model;

    public int getNumWeeks() {
        return this.numWeeks;
    }

    public int getNumToDrop() {
        return this.numToDrop;
    }

    public int[] getTimeShifts() {
        return this.timeShifts;
    }

    public int[] getBaseWindows() {
        return this.baseWindows;
    }

    public ArrayList<Float> getModel() {
        return this.model;
    }

    public OlympicModel(Properties config) {
        super(config);
        if (config.getProperty("NUM_WEEKS") == null) {
            throw new IllegalArgumentException("NUM_WEEKS is NULL");
        }
        if (config.getProperty("NUM_TO_DROP") == null) {
            throw new IllegalArgumentException("NUM_TO_DROP is NULL");
        }
        if (config.getProperty("TIME_SHIFTS") == null) {
            throw new IllegalArgumentException("TIME_SHIFTS is NULL");
        }
        if (config.getProperty("BASE_WINDOWS") == null) {
            throw new IllegalArgumentException("BASE_WINDOWS is NULL");
        }
        this.numWeeks = new Integer(config.getProperty("NUM_WEEKS"));
        this.numToDrop = new Integer(config.getProperty("NUM_TO_DROP"));
        this.timeShifts = FileUtils.splitInts(config.getProperty("TIME_SHIFTS"));
        this.baseWindows = FileUtils.splitInts(config.getProperty("BASE_WINDOWS"));
        this.model = new ArrayList();
    }

    @Override
    public void reset() {
    }

    @Override
    public void train(TimeSeries.DataSequence data) {
        this.data = data;
        int n = data.size();
        Arrays.sort(this.baseWindows);
        Arrays.sort(this.timeShifts);
        float precision = 1.0E-6f;
        for (int i = 0; i < n; ++i) {
            float baseVal = Float.POSITIVE_INFINITY;
            float tmpbase = 0.0f;
            if (i - this.baseWindows[0] < 0) {
                this.model.add(Float.valueOf(((TimeSeries.Entry)data.get((int)i)).value));
                continue;
            }
            for (int w = 0; w < this.baseWindows.length; ++w) {
                for (int j = 0; j < this.timeShifts.length; ++j) {
                    if (this.timeShifts[j] == 0) {
                        tmpbase = this.computeExpected(i, this.baseWindows[w]);
                        if (!(Math.abs(tmpbase - ((TimeSeries.Entry)data.get((int)i)).value) - Math.abs(baseVal - ((TimeSeries.Entry)data.get((int)i)).value) < precision)) continue;
                        baseVal = tmpbase;
                        continue;
                    }
                    if (i + this.timeShifts[j] < n && Math.abs((tmpbase = this.computeExpected(i + this.timeShifts[j], this.baseWindows[w])) - ((TimeSeries.Entry)data.get((int)i)).value) - Math.abs(baseVal - ((TimeSeries.Entry)data.get((int)i)).value) < precision) {
                        baseVal = tmpbase;
                    }
                    if (i - this.timeShifts[j] < 0 || !(Math.abs((tmpbase = this.computeExpected(i - this.timeShifts[j], this.baseWindows[w])) - ((TimeSeries.Entry)data.get((int)i)).value) - Math.abs(baseVal - ((TimeSeries.Entry)data.get((int)i)).value) < precision)) continue;
                    baseVal = tmpbase;
                }
            }
            this.model.add(Float.valueOf(baseVal));
        }
        this.initForecastErrors(this.model, data);
        logger.debug(this.getBias() + "\t" + this.getMAD() + "\t" + this.getMAPE() + "\t" + this.getMSE() + "\t" + this.getSAE() + "\t" + 0 + "\t" + 0);
    }

    @Override
    public void update(TimeSeries.DataSequence data) {
    }

    @Override
    public String getModelName() {
        return "OlympicModel";
    }

    private Float sum(ArrayList<Float> list) {
        float sum = 0.0f;
        for (float i : list) {
            sum += i;
        }
        return Float.valueOf(sum);
    }

    private float computeExpected(int i, int pl) {
        ArrayList<Float> vals = new ArrayList<Float>();
        float precision = 1.0E-6f;
        int j = 1;
        if (i - pl * j < 0) {
            return Float.POSITIVE_INFINITY;
        }
        while (j <= this.numWeeks && i - pl * j >= 0) {
            float lastWeeksVal = ((TimeSeries.Entry)this.data.get((int)(i - pl * j))).value;
            if (this.dynamicParameters == 1 && vals.size() > 0) {
                float withNewVal = (this.sum(vals).floatValue() + lastWeeksVal) / (float)(vals.size() + 1);
                float withoutNewVal = this.sum(vals).floatValue() / (float)vals.size();
                if (Math.abs(withNewVal - ((TimeSeries.Entry)this.data.get((int)i)).value) - Math.abs(withoutNewVal - ((TimeSeries.Entry)this.data.get((int)i)).value) > precision) break;
            }
            vals.add(Float.valueOf(lastWeeksVal));
            ++j;
        }
        Collections.sort(vals);
        if (vals.size() > 2 * this.numToDrop) {
            for (j = 0; j < this.numToDrop; ++j) {
                vals.remove(vals.size() - 1);
                vals.remove(0);
            }
        }
        float baseVal = this.sum(vals).floatValue() / (float)vals.size();
        return baseVal;
    }

    @Override
    public void predict(TimeSeries.DataSequence sequence) throws Exception {
        int n = this.data.size();
        for (int i = 0; i < n; ++i) {
            sequence.set(i, new TimeSeries.Entry(((TimeSeries.Entry)this.data.get((int)i)).time, this.model.get(i).floatValue()));
            logger.info(((TimeSeries.Entry)this.data.get((int)i)).time + "," + ((TimeSeries.Entry)this.data.get((int)i)).value + "," + this.model.get(i));
        }
    }
}

