/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.egads.models.tsmm;

import com.yahoo.egads.data.TimeSeries;
import com.yahoo.egads.models.tsmm.DoubleExponentialSmoothingModel;
import com.yahoo.egads.models.tsmm.MovingAverageModel;
import com.yahoo.egads.models.tsmm.MultipleLinearRegressionModel;
import com.yahoo.egads.models.tsmm.NaiveForecastingModel;
import com.yahoo.egads.models.tsmm.OlympicModel;
import com.yahoo.egads.models.tsmm.PolynomialRegressionModel;
import com.yahoo.egads.models.tsmm.RegressionModel;
import com.yahoo.egads.models.tsmm.SimpleExponentialSmoothingModel;
import com.yahoo.egads.models.tsmm.TimeSeriesAbstractModel;
import com.yahoo.egads.models.tsmm.TripleExponentialSmoothingModel;
import com.yahoo.egads.models.tsmm.WeightedMovingAverageModel;
import java.util.Properties;
import org.json.JSONObject;
import org.json.JSONStringer;

public class AutoForecastModel
extends TimeSeriesAbstractModel {
    private Properties p;
    private TimeSeriesAbstractModel myModel = null;

    public AutoForecastModel(Properties config) {
        super(config);
        this.modelName = "AutoForecastModel";
        this.p = config;
    }

    @Override
    public void reset() {
    }

    @Override
    public void train(TimeSeries.DataSequence data) {
        OlympicModel olympModel = new OlympicModel(this.p);
        MovingAverageModel movingAvg = new MovingAverageModel(this.p);
        MultipleLinearRegressionModel mlReg = new MultipleLinearRegressionModel(this.p);
        NaiveForecastingModel naive = new NaiveForecastingModel(this.p);
        PolynomialRegressionModel poly = new PolynomialRegressionModel(this.p);
        RegressionModel regr = new RegressionModel(this.p);
        SimpleExponentialSmoothingModel simpleExp = new SimpleExponentialSmoothingModel(this.p);
        TripleExponentialSmoothingModel tripleExp = new TripleExponentialSmoothingModel(this.p);
        WeightedMovingAverageModel weightAvg = new WeightedMovingAverageModel(this.p);
        DoubleExponentialSmoothingModel doubleExp = new DoubleExponentialSmoothingModel(this.p);
        olympModel.train(data);
        movingAvg.train(data);
        mlReg.train(data);
        naive.train(data);
        poly.train(data);
        regr.train(data);
        simpleExp.train(data);
        tripleExp.train(data);
        weightAvg.train(data);
        doubleExp.train(data);
        if (AutoForecastModel.betterThan(olympModel, this.myModel)) {
            this.myModel = olympModel;
        }
        if (AutoForecastModel.betterThan(movingAvg, this.myModel)) {
            this.myModel = movingAvg;
        }
        if (AutoForecastModel.betterThan(mlReg, this.myModel)) {
            this.myModel = mlReg;
        }
        if (AutoForecastModel.betterThan(naive, this.myModel)) {
            this.myModel = naive;
        }
        if (AutoForecastModel.betterThan(poly, this.myModel)) {
            this.myModel = poly;
        }
        if (AutoForecastModel.betterThan(regr, this.myModel)) {
            this.myModel = regr;
        }
        if (AutoForecastModel.betterThan(simpleExp, this.myModel)) {
            this.myModel = simpleExp;
        }
        if (AutoForecastModel.betterThan(tripleExp, this.myModel)) {
            this.myModel = tripleExp;
        }
        if (AutoForecastModel.betterThan(weightAvg, this.myModel)) {
            this.myModel = weightAvg;
        }
        if (AutoForecastModel.betterThan(doubleExp, this.myModel)) {
            this.myModel = doubleExp;
        }
        this.initForecastErrors(this.myModel, data);
        logger.debug(this.getBias() + "\t" + this.getMAD() + "\t" + this.getMAPE() + "\t" + this.getMSE() + "\t" + this.getSAE() + "\t" + 0 + "\t" + 0);
    }

    @Override
    public void update(TimeSeries.DataSequence data) {
    }

    @Override
    public String getModelName() {
        return this.modelName;
    }

    @Override
    public void predict(TimeSeries.DataSequence sequence) throws Exception {
        this.myModel.predict(sequence);
    }

    @Override
    public void toJson(JSONStringer json_out) {
    }

    @Override
    public void fromJson(JSONObject json_obj) {
    }
}

