/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.egads.models.adm;

import com.yahoo.egads.data.Anomaly;
import com.yahoo.egads.data.AnomalyErrorStorage;
import com.yahoo.egads.data.TimeSeries;
import com.yahoo.egads.models.adm.AnomalyDetectionAbstractModel;
import java.util.Map;
import java.util.Properties;
import org.json.JSONObject;
import org.json.JSONStringer;

public class NaiveModel
extends AnomalyDetectionAbstractModel {
    private Map<String, Float> threshold;
    private int maxHrsAgo;
    private long windowStart;
    private Float window_size;
    public static String modelName = "NaiveModel";
    public AnomalyErrorStorage aes = new AnomalyErrorStorage();

    public NaiveModel(Properties config) {
        super(config);
        if (config.getProperty("MAX_ANOMALY_TIME_AGO") == null) {
            throw new IllegalArgumentException("MAX_ANOMALY_TIME_AGO is NULL");
        }
        this.maxHrsAgo = new Integer(config.getProperty("MAX_ANOMALY_TIME_AGO"));
        this.windowStart = new Long(config.getProperty("DETECTION_WINDOW_START_TIME"));
        if (config.getProperty("WINDOW_SIZE") == null) {
            throw new IllegalArgumentException("WINDOW_SIZE is NULL");
        }
        this.window_size = new Float(config.getProperty("WINDOW_SIZE"));
        if (config.getProperty("THRESHOLD") == null) {
            throw new IllegalArgumentException("THRESHOLD is NULL");
        }
        this.threshold = this.parseMap(config.getProperty("THRESHOLD"));
        if (config.getProperty("THRESHOLD") != null && this.threshold.isEmpty()) {
            throw new IllegalArgumentException("THRESHOLD PARSE ERROR");
        }
    }

    @Override
    public void toJson(JSONStringer json_out) {
    }

    @Override
    public void fromJson(JSONObject json_obj) {
    }

    @Override
    public String getModelName() {
        return modelName;
    }

    @Override
    public String getType() {
        return "point_outlier";
    }

    @Override
    public void reset() {
    }

    @Override
    public void tune(TimeSeries.DataSequence observedSeries, TimeSeries.DataSequence expectedSeries, Anomaly.IntervalSequence anomalySequence) throws Exception {
    }

    public boolean isAnomaly(Float[] errors, Map<String, Float> threshold) {
        for (Map.Entry<String, Float> entry : threshold.entrySet()) {
            if (!this.aes.getErrorToIndex().containsKey(entry.getKey()) || !(Math.abs(errors[this.aes.getErrorToIndex().get(entry.getKey())].floatValue()) >= Math.abs(entry.getValue().floatValue()))) continue;
            return true;
        }
        return false;
    }

    @Override
    public Anomaly.IntervalSequence detect(TimeSeries.DataSequence observedSeries, TimeSeries.DataSequence expectedSeries) throws Exception {
        Float[] thresholdErrors = new Float[this.aes.getErrorToIndex().size()];
        for (Map.Entry<String, Float> entry : this.threshold.entrySet()) {
            thresholdErrors[this.aes.getErrorToIndex().get((Object)entry.getKey()).intValue()] = Float.valueOf(Math.abs(entry.getValue().floatValue()));
        }
        Anomaly.IntervalSequence output = new Anomaly.IntervalSequence();
        int n = observedSeries.size();
        Integer cutIndex = null;
        cutIndex = (double)this.window_size.floatValue() < 1.0 ? Integer.valueOf(Math.round(this.window_size.floatValue() * (float)n)) : Integer.valueOf(Math.round(this.window_size.floatValue()));
        if (cutIndex + 1 > n) {
            return output;
        }
        Float[] observed = new Float[]{Float.valueOf(((TimeSeries.Entry)observedSeries.get((int)0)).value), Float.valueOf(((TimeSeries.Entry)observedSeries.get((int)0)).value)};
        Float[] expected = new Float[]{Float.valueOf(((TimeSeries.Entry)expectedSeries.get((int)0)).value), Float.valueOf(((TimeSeries.Entry)expectedSeries.get((int)0)).value)};
        int maxIndex = 0;
        int minIndex = 0;
        boolean anomaly = false;
        for (int k = 0; k < n; ++k) {
            if (observed[0].floatValue() < ((TimeSeries.Entry)observedSeries.get((int)k)).value) {
                observed[0] = Float.valueOf(((TimeSeries.Entry)observedSeries.get((int)k)).value);
                maxIndex = k;
                anomaly = true;
            }
            if (observed[1].floatValue() > ((TimeSeries.Entry)observedSeries.get((int)k)).value) {
                observed[1] = Float.valueOf(((TimeSeries.Entry)observedSeries.get((int)k)).value);
                minIndex = k;
                anomaly = true;
            }
            if (k < cutIndex) continue;
            expected[0] = Float.valueOf(Math.max(expected[0].floatValue(), ((TimeSeries.Entry)observedSeries.get((int)(k - cutIndex.intValue()))).value));
            expected[1] = Float.valueOf(Math.min(expected[1].floatValue(), ((TimeSeries.Entry)observedSeries.get((int)(k - cutIndex.intValue()))).value));
            int anomalyIndex = 0;
            for (int i = 0; i < 2; ++i) {
                Float[] errors = this.aes.computeErrorMetrics(expected[i].floatValue(), observed[i].floatValue());
                boolean actualAnomaly = false;
                if (i == 0 && observed[i].floatValue() > expected[i].floatValue()) {
                    actualAnomaly = true;
                    anomalyIndex = maxIndex;
                }
                if (i == 1 && observed[i].floatValue() < expected[i].floatValue()) {
                    actualAnomaly = true;
                    anomalyIndex = minIndex;
                }
                if (!this.isAnomaly(errors, this.threshold) || !actualAnomaly || !anomaly || !this.isDetectionWindowPoint(this.maxHrsAgo, this.windowStart, ((TimeSeries.Entry)observedSeries.get((int)anomalyIndex)).time, ((TimeSeries.Entry)observedSeries.get((int)0)).time) && (this.maxHrsAgo != 0 || i != n - 1)) continue;
                anomaly = false;
                this.logger.debug("TS:" + ((TimeSeries.Entry)observedSeries.get((int)anomalyIndex)).time + ",E:" + this.arrayF2S(errors) + ",TH:" + this.arrayF2S(thresholdErrors) + ",OV:" + ((TimeSeries.Entry)observedSeries.get((int)anomalyIndex)).value + ",EV:" + expected[i]);
                output.add(new Anomaly.Interval(((TimeSeries.Entry)observedSeries.get((int)anomalyIndex)).time, anomalyIndex, errors, thresholdErrors, observed[i].floatValue(), expected[i].floatValue(), this.isAnomaly(errors, this.threshold)));
            }
        }
        return output;
    }
}

