/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.egads.models.adm;

import com.yahoo.egads.data.Anomaly;
import com.yahoo.egads.data.AnomalyErrorStorage;
import com.yahoo.egads.data.TimeSeries;
import com.yahoo.egads.models.adm.AnomalyDetectionAbstractModel;
import com.yahoo.egads.utilities.AutoSensitivity;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.json.JSONObject;
import org.json.JSONStringer;

public class KSigmaModel
extends AnomalyDetectionAbstractModel {
    private Map<String, Float> threshold;
    private int maxHrsAgo;
    private long windowStart;
    public String modelName = "KSigmaModel";
    public AnomalyErrorStorage aes = new AnomalyErrorStorage();

    public KSigmaModel(Properties config) {
        super(config);
        if (config.getProperty("MAX_ANOMALY_TIME_AGO") == null) {
            throw new IllegalArgumentException("MAX_ANOMALY_TIME_AGO is NULL");
        }
        this.maxHrsAgo = new Integer(config.getProperty("MAX_ANOMALY_TIME_AGO"));
        this.windowStart = new Long(config.getProperty("DETECTION_WINDOW_START_TIME"));
        this.threshold = this.parseMap(config.getProperty("THRESHOLD"));
        if (config.getProperty("THRESHOLD") != null && this.threshold.isEmpty()) {
            throw new IllegalArgumentException("THRESHOLD PARSE ERROR");
        }
    }

    @Override
    public void toJson(JSONStringer json_out) {
    }

    @Override
    public void fromJson(JSONObject json_obj) {
    }

    @Override
    public String getModelName() {
        return this.modelName;
    }

    @Override
    public String getType() {
        return "point_outlier";
    }

    @Override
    public void reset() {
    }

    @Override
    public void tune(TimeSeries.DataSequence observedSeries, TimeSeries.DataSequence expectedSeries, Anomaly.IntervalSequence anomalySequence) throws Exception {
        HashMap<String, ArrayList<Float>> allErrors = this.aes.initAnomalyErrors(observedSeries, expectedSeries);
        for (int i = 0; i < this.aes.getIndexToError().keySet().size(); ++i) {
            if (this.threshold.containsKey(this.aes.getIndexToError().get(i))) continue;
            Float[] fArray = allErrors.get(this.aes.getIndexToError().get(i)).toArray(new Float[allErrors.get(this.aes.getIndexToError().get(i)).size()]);
            this.threshold.put(this.aes.getIndexToError().get(i), AutoSensitivity.getKSigmaSensitivity(fArray, this.sDAutoSensitivity));
        }
    }

    public boolean isAnomaly(Float[] errors, Map<String, Float> threshold) {
        for (Map.Entry<String, Float> entry : threshold.entrySet()) {
            if (!this.aes.getErrorToIndex().containsKey(entry.getKey()) || !(Math.abs(errors[this.aes.getErrorToIndex().get(entry.getKey())].floatValue()) >= Math.abs(entry.getValue().floatValue()))) continue;
            return true;
        }
        return false;
    }

    @Override
    public Anomaly.IntervalSequence detect(TimeSeries.DataSequence observedSeries, TimeSeries.DataSequence expectedSeries) throws Exception {
        Float threshSum = Float.valueOf(0.0f);
        for (Map.Entry<String, Float> entry : this.threshold.entrySet()) {
            threshSum = Float.valueOf(threshSum.floatValue() + Math.abs(entry.getValue().floatValue()));
        }
        Float[] thresholdErrors = new Float[this.aes.getErrorToIndex().size()];
        for (Map.Entry<String, Float> entry : this.threshold.entrySet()) {
            thresholdErrors[this.aes.getErrorToIndex().get((Object)entry.getKey()).intValue()] = Float.valueOf(Math.abs(entry.getValue().floatValue()));
        }
        Anomaly.IntervalSequence intervalSequence = new Anomaly.IntervalSequence();
        int n = observedSeries.size();
        for (int i = 0; i < n; ++i) {
            Float[] errors = this.aes.computeErrorMetrics(((TimeSeries.Entry)expectedSeries.get((int)i)).value, ((TimeSeries.Entry)observedSeries.get((int)i)).value);
            this.logger.debug("TS:" + ((TimeSeries.Entry)observedSeries.get((int)i)).time + ",E:" + this.arrayF2S(errors) + ",TE:" + this.arrayF2S(thresholdErrors) + ",OV:" + ((TimeSeries.Entry)observedSeries.get((int)i)).value + ",EV:" + ((TimeSeries.Entry)expectedSeries.get((int)i)).value);
            if (((TimeSeries.Entry)observedSeries.get((int)i)).value == ((TimeSeries.Entry)expectedSeries.get((int)i)).value || !(threshSum.floatValue() > 0.0f) || !this.isAnomaly(errors, this.threshold) || !this.isDetectionWindowPoint(this.maxHrsAgo, this.windowStart, ((TimeSeries.Entry)observedSeries.get((int)i)).time, ((TimeSeries.Entry)observedSeries.get((int)0)).time) && (this.maxHrsAgo != 0 || i != n - 1)) continue;
            intervalSequence.add(new Anomaly.Interval(((TimeSeries.Entry)observedSeries.get((int)i)).time, i, errors, thresholdErrors, ((TimeSeries.Entry)observedSeries.get((int)i)).value, ((TimeSeries.Entry)expectedSeries.get((int)i)).value));
        }
        return intervalSequence;
    }
}

