/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.egads.data;

import com.yahoo.egads.data.JsonAble;
import com.yahoo.egads.data.JsonEncoder;
import com.yahoo.egads.data.MetricMeta;
import java.io.Serializable;
import java.util.ArrayList;
import org.json.JSONObject;
import org.json.JSONStringer;

public class TimeSeries
implements JsonAble,
Serializable {
    public DataSequence data = new DataSequence();
    public MetricMeta meta = new MetricMeta();

    public TimeSeries() {
    }

    public TimeSeries(float[] values) {
        for (int i = 0; i < values.length; ++i) {
            this.data.add(new Entry(i, values[i]));
        }
    }

    public TimeSeries(float value) {
        this.data.add(new Entry(0L, value));
    }

    public TimeSeries(long[] times, float[] values) throws Exception {
        if (times.length != values.length) {
            throw new Exception("Length mismatch!");
        }
        for (int i = 0; i < values.length; ++i) {
            if (i > 0 && times[i] < times[i - 1]) {
                throw new Exception("time=" + times[i] + " at index=" + i + " out of order");
            }
            this.data.add(new Entry(times[i], values[i]));
        }
    }

    public DataSequence aggregate(int frequency) {
        DataSequence ldata = new DataSequence();
        for (int i = 0; i < this.data.size(); i += frequency) {
            Float aggr = Float.valueOf(0.0f);
            Long time = ((Entry)this.data.get((int)i)).time;
            int count = 0;
            for (int j = i; j < Math.min(this.data.size(), i + frequency); ++j) {
                aggr = Float.valueOf(aggr.floatValue() + ((Entry)this.data.get((int)j)).value);
                ++count;
            }
            aggr = Float.valueOf(aggr.floatValue() / (float)count);
            ldata.add(new Entry(time, aggr.floatValue()));
        }
        return ldata;
    }

    public TimeSeries(long time, float value) {
        this.data.add(new Entry(time, value));
    }

    public void append(long time, float value) throws Exception {
        if (this.size() > 0 && time < this.lastTime()) {
            throw new Exception("time=" + time + " at index=" + this.size() + " out of order");
        }
        this.data.add(new Entry(time, value));
    }

    public int size() {
        return this.data.size();
    }

    public long startTime() {
        return ((Entry)this.data.get((int)0)).time;
    }

    public long lastTime() {
        return ((Entry)this.data.get((int)(this.data.size() - 1))).time;
    }

    public long time(int index) {
        return ((Entry)this.data.get((int)index)).time;
    }

    public float value(int index) {
        return ((Entry)this.data.get((int)index)).value;
    }

    public long minimumPeriod() {
        if (this.size() < 2) {
            return 0L;
        }
        long minPeriod = -1L;
        for (int i = 1; i < this.size(); ++i) {
            long period = this.time(i) - this.time(i - 1);
            if (minPeriod != -1L && period >= minPeriod) continue;
            minPeriod = period;
        }
        return minPeriod;
    }

    public long mostFrequentPeriod() {
        if (this.size() < 2) {
            return 0L;
        }
        ArrayList<PeriodAndCount> periods = new ArrayList<PeriodAndCount>();
        for (int i = 1; i < this.size(); ++i) {
            long period = this.time(i) - this.time(i - 1);
            boolean found = false;
            for (int p = 0; p < periods.size(); ++p) {
                PeriodAndCount pc = (PeriodAndCount)periods.get(p);
                if (pc.period != period) continue;
                found = true;
                ++pc.count;
            }
            if (found) continue;
            periods.add(new PeriodAndCount(period, 1));
        }
        int maxCount = 0;
        long maxPeriod = 0L;
        for (int p = 0; p < periods.size(); ++p) {
            PeriodAndCount pc = (PeriodAndCount)periods.get(p);
            if (pc.count <= maxCount) continue;
            maxCount = pc.count;
            maxPeriod = pc.period;
        }
        return maxPeriod;
    }

    public String toString() {
        StringBuffer str = new StringBuffer();
        for (int i = 0; i < this.data.size(); ++i) {
            if (i > 0) {
                str.append(",");
            }
            str.append("[" + this.time(i) + ":" + this.value(i) + "]");
        }
        return str.toString();
    }

    @Override
    public void toJson(JSONStringer json_out) throws Exception {
        JsonEncoder.toJson(this, json_out);
    }

    @Override
    public void fromJson(JSONObject json_obj) throws Exception {
        JsonEncoder.fromJson((Object)this, json_obj);
    }

    public boolean equals(Object other_obj) {
        if (!(other_obj instanceof TimeSeries)) {
            return false;
        }
        TimeSeries other = (TimeSeries)other_obj;
        if (!MetricMeta.equals(this.data, other.data)) {
            return false;
        }
        return MetricMeta.equals(this.meta, other.meta);
    }

    protected class PeriodAndCount
    implements Serializable {
        public long period = 0L;
        public int count = 0;

        public PeriodAndCount(long period_arg, int count_arg) {
            this.period = period_arg;
            this.count = count_arg;
        }
    }

    public static class DataSequence
    extends ArrayList<Entry>
    implements Serializable {
        private static final long serialVersionUID = 1L;

        public DataSequence() {
        }

        public DataSequence(long from, long to, long period) throws Exception {
            if (to < from) {
                throw new Exception("The start time should be before the end time.");
            }
            for (long i = from; i <= to; i += period) {
                this.add(new Entry(i, 0.0f));
            }
        }

        public DataSequence(int initialCapacity) {
            super(initialCapacity);
        }

        public DataSequence(float[] values) {
            for (int i = 0; i < values.length; ++i) {
                this.add(new Entry(i, values[i]));
            }
        }

        public DataSequence(float value) {
            this.add(new Entry(0L, value));
        }

        public DataSequence(Long[] times, Float[] values) throws Exception {
            if (times.length != values.length) {
                throw new Exception("Length mismatch!");
            }
            for (int i = 0; i < values.length; ++i) {
                if (i > 0 && times[i] < times[i - 1]) {
                    throw new Exception("time=" + times[i] + " at index=" + i + " out of order");
                }
                this.add(new Entry(times[i], values[i].floatValue()));
            }
        }

        public DataSequence(long time, float value) {
            this.add(new Entry(time, value));
        }

        public void setLogicalIndices(long firstTimeStamp, long period) {
            for (Entry entry : this) {
                entry.logicalIndex = (entry.time - firstTimeStamp) / period;
            }
        }

        public Float[] getValues() {
            Float[] fArray = new Float[this.size()];
            for (int i = 0; i < this.size(); ++i) {
                fArray[i] = Float.valueOf(((Entry)this.get((int)i)).value);
            }
            return fArray;
        }

        public Long[] getTimes() {
            Long[] lArray = new Long[this.size()];
            for (int i = 0; i < this.size(); ++i) {
                lArray[i] = ((Entry)this.get((int)i)).time;
            }
            return lArray;
        }

        public void setTimeStamps(long firstTimeStamp, long period) {
            for (Entry entry : this) {
                entry.time = entry.logicalIndex * period + firstTimeStamp;
            }
        }

        @Override
        public boolean equals(Object other_obj) {
            if (!(other_obj instanceof DataSequence)) {
                return false;
            }
            DataSequence other = (DataSequence)other_obj;
            return super.equals(other);
        }
    }

    public static class Entry
    implements JsonAble,
    Serializable {
        public long time = 0L;
        public float value = 0.0f;
        public long logicalIndex = 0L;

        public Entry() {
        }

        public Entry(long time_arg, float value_arg) {
            this.time = time_arg;
            this.value = value_arg;
        }

        public Entry(Entry e) {
            this.time = e.time;
            this.logicalIndex = e.logicalIndex;
            this.value = e.value;
        }

        @Override
        public void toJson(JSONStringer json_out) throws Exception {
            JsonEncoder.toJson(this, json_out);
        }

        @Override
        public void fromJson(JSONObject json_obj) throws Exception {
            JsonEncoder.fromJson((Object)this, json_obj);
        }

        public boolean equals(Object other_obj) {
            if (!(other_obj instanceof Entry)) {
                return false;
            }
            Entry other = (Entry)other_obj;
            if (this.time != other.time) {
                return false;
            }
            if (this.value != other.value) {
                return false;
            }
            return this.logicalIndex == other.logicalIndex;
        }
    }
}

