/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.egads.data;

import com.yahoo.egads.data.JsonAble;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.Iterator;
import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONStringer;

public class JsonEncoder {
    public static String toJson(Object object) throws Exception {
        JSONStringer jsonOut = new JSONStringer();
        JsonEncoder.toJson(object, jsonOut);
        return jsonOut.toString();
    }

    public static void toJson(Object object, JSONStringer json_out) throws Exception {
        json_out.object();
        for (Class<?> c = object.getClass(); c != Object.class; c = c.getSuperclass()) {
            Field[] fields;
            for (Field f : fields = c.getDeclaredFields()) {
                if (Modifier.isStatic(f.getModifiers()) || Modifier.isPrivate(f.getModifiers())) continue;
                Object value = f.get(object);
                if (value instanceof JsonAble) {
                    json_out.key(f.getName());
                    ((JsonAble)value).toJson(json_out);
                    continue;
                }
                if (value instanceof ArrayList) {
                    json_out.key(f.getName());
                    json_out.array();
                    for (Object e : (ArrayList)value) {
                        JsonEncoder.toJson(e, json_out);
                    }
                    json_out.endArray();
                    continue;
                }
                json_out.key(f.getName()).value(value);
            }
        }
        json_out.endObject();
    }

    public static void fromJson(Object object, String json_str) throws Exception {
        JSONObject jsonObj = new JSONObject(json_str);
        JsonEncoder.fromJson(object, jsonObj);
    }

    public static void fromJson(Object object, JSONObject json_obj) throws Exception {
        Iterator<String> k = json_obj.keys();
        while (k.hasNext()) {
            String key = k.next();
            Object value = json_obj.get(key);
            Field field = null;
            try {
                field = object.getClass().getField(key);
            }
            catch (Exception e) {
                continue;
            }
            if (Modifier.isStatic(field.getModifiers()) || Modifier.isPrivate(field.getModifiers())) continue;
            Object member = field.get(object);
            if (json_obj.isNull(key)) {
                field.set(object, null);
                continue;
            }
            if (member instanceof JsonAble) {
                ((JsonAble)member).fromJson((JSONObject)value);
                continue;
            }
            if (member instanceof ArrayList) {
                ArrayList memberArray = (ArrayList)member;
                JSONArray jsonArray = (JSONArray)value;
                ParameterizedType arrayType = null;
                if (field.getGenericType() instanceof ParameterizedType) {
                    arrayType = (ParameterizedType)field.getGenericType();
                }
                for (Class<?> c = member.getClass(); arrayType == null && c != null; c = c.getSuperclass()) {
                    if (!(c.getGenericSuperclass() instanceof ParameterizedType)) continue;
                    arrayType = (ParameterizedType)c.getGenericSuperclass();
                }
                if (arrayType == null) {
                    throw new Exception("could not find ArrayList element type for field 'key'");
                }
                Class elementClass = (Class)arrayType.getActualTypeArguments()[0];
                Constructor elementConstructor = elementClass.getConstructor(new Class[0]);
                for (int i = 0; i < jsonArray.length(); ++i) {
                    Object element = elementConstructor.newInstance(new Object[0]);
                    JsonEncoder.fromJson(element, jsonArray.getJSONObject(i));
                    memberArray.add(element);
                }
                continue;
            }
            if (field.getType() == Float.TYPE) {
                field.set(object, Float.valueOf((float)json_obj.getDouble(key)));
                continue;
            }
            field.set(object, value);
        }
    }
}

