/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.egads.control;

import com.yahoo.egads.control.AnomalyDetector;
import com.yahoo.egads.control.DetectAnomalyProcessable;
import com.yahoo.egads.control.ModelAdapter;
import com.yahoo.egads.control.ProcessableObject;
import com.yahoo.egads.control.TransformInputProcessable;
import com.yahoo.egads.control.UpdateModelProcessable;
import com.yahoo.egads.data.TimeSeries;
import com.yahoo.egads.models.adm.AnomalyDetectionAbstractModel;
import com.yahoo.egads.models.tsmm.TimeSeriesAbstractModel;
import java.lang.reflect.Constructor;
import java.util.Properties;

public class ProcessableObjectFactory {
    public static ProcessableObject create(TimeSeries ts, Properties config) {
        if (config.getProperty("OP_TYPE") == null) {
            throw new IllegalArgumentException("OP_TYPE is NULL");
        }
        if (config.getProperty("OP_TYPE").equals("DETECT_ANOMALY")) {
            ModelAdapter ma = ProcessableObjectFactory.buildTSModel(ts, config);
            AnomalyDetector ad = ProcessableObjectFactory.buildAnomalyModel(ts, config);
            return new DetectAnomalyProcessable(ma, ad, config);
        }
        if (config.getProperty("OP_TYPE").equals("UPDATE_MODEL")) {
            ModelAdapter ma = ProcessableObjectFactory.buildTSModel(ts, config);
            return new UpdateModelProcessable(ma, ts.data, config);
        }
        if (config.getProperty("OP_TYPE").equals("TRANSFORM_INPUT")) {
            ModelAdapter ma = ProcessableObjectFactory.buildTSModel(ts, config);
            return new TransformInputProcessable(ma, config);
        }
        System.err.println("Unknown OP_TYPE, returning UPDATE_MODEL ProcessableObject");
        ModelAdapter ma = ProcessableObjectFactory.buildTSModel(ts, config);
        return new UpdateModelProcessable(ma, ts.data, config);
    }

    private static ModelAdapter buildTSModel(TimeSeries ts, Properties config) {
        ModelAdapter ma = null;
        try {
            Long period = -1L;
            if (config.getProperty("PERIOD") != null) {
                period = new Long(config.getProperty("PERIOD"));
            }
            if (period == 0L) {
                period = ts.size() > 1 ? Long.valueOf(((TimeSeries.Entry)ts.data.get((int)1)).time - ((TimeSeries.Entry)ts.data.get((int)0)).time) : Long.valueOf(1L);
            }
            ma = new ModelAdapter(ts, (long)period);
            String modelType = config.getProperty("TS_MODEL");
            Class<?> tsModelClass = Class.forName("com.yahoo.egads.models.tsmm." + modelType);
            Constructor<?> constructor = tsModelClass.getConstructor(Properties.class);
            TimeSeriesAbstractModel m = (TimeSeriesAbstractModel)constructor.newInstance(config);
            ma.addModel(m);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ma;
    }

    private static AnomalyDetector buildAnomalyModel(TimeSeries ts, Properties config) {
        AnomalyDetector ad = null;
        try {
            Long period = -1L;
            if (config.getProperty("PERIOD") != null) {
                period = new Long(config.getProperty("PERIOD"));
            }
            if (period == 0L) {
                period = ts.size() > 1 ? Long.valueOf(((TimeSeries.Entry)ts.data.get((int)1)).time - ((TimeSeries.Entry)ts.data.get((int)0)).time) : Long.valueOf(1L);
            }
            ad = new AnomalyDetector(ts, (long)period);
            String modelType = config.getProperty("AD_MODEL");
            Class<?> tsModelClass = Class.forName("com.yahoo.egads.models.adm." + modelType);
            Constructor<?> constructor = tsModelClass.getConstructor(Properties.class);
            ad.addModel((AnomalyDetectionAbstractModel)constructor.newInstance(config));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ad;
    }
}

