/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.egads.control;

import com.yahoo.egads.data.TimeSeries;
import com.yahoo.egads.models.tsmm.TimeSeriesModel;
import java.util.ArrayList;

public class ModelAdapter {
    protected TimeSeries metric = null;
    protected ArrayList<TimeSeriesModel> models = new ArrayList();
    protected ArrayList<Boolean> isTrained = new ArrayList();
    protected long firstTimeStamp = 0L;
    protected long period;

    public ModelAdapter(TimeSeries theMetric, long period, long firstTimeStamp) throws Exception {
        if (theMetric == null) {
            throw new Exception("The input metric is null.");
        }
        this.metric = theMetric;
        this.period = period;
        this.firstTimeStamp = firstTimeStamp;
    }

    public ModelAdapter(TimeSeries theMetric, long period) throws Exception {
        if (theMetric == null) {
            throw new Exception("The input metric is null.");
        }
        this.metric = theMetric;
        this.period = period;
        if (this.metric.data.size() > 0) {
            this.firstTimeStamp = this.metric.time(0);
        }
    }

    public ModelAdapter(String theMetric, long period) throws Exception {
        this.period = period;
        int modelNum = this.models.size();
        for (int i = 0; i < modelNum; ++i) {
            this.isTrained.set(i, true);
        }
    }

    public void setMetric(TimeSeries theMetric, long period) {
        this.metric = theMetric;
        this.period = period;
        if (this.metric.data.size() > 0) {
            this.firstTimeStamp = this.metric.time(0);
        }
        this.reset();
    }

    public void setMetric(TimeSeries theMetric, long period, long firstTimeStamp) {
        this.metric = theMetric;
        this.period = period;
        this.firstTimeStamp = firstTimeStamp;
        this.reset();
    }

    public void setMetric(String theMetric, long period) {
        this.period = period;
        this.firstTimeStamp = 0L;
        this.models.clear();
        this.isTrained.clear();
        int modelNum = this.models.size();
        for (int i = 0; i < modelNum; ++i) {
            this.isTrained.set(i, true);
        }
    }

    public void addModel(TimeSeriesModel model) {
        model.reset();
        this.models.add(model);
        this.isTrained.add(false);
    }

    public String[] getModelNames() {
        String[] names = new String[this.models.size()];
        for (int i = 0; i < this.models.size(); ++i) {
            names[i] = this.models.get(i).getModelName();
        }
        return names;
    }

    public void reset() {
        int i = 0;
        for (TimeSeriesModel model : this.models) {
            model.reset();
            this.isTrained.set(i, false);
            ++i;
        }
    }

    public void train() throws Exception {
        int i = 0;
        this.metric.data.setLogicalIndices(this.firstTimeStamp, this.period);
        for (TimeSeriesModel model : this.models) {
            if (!this.isTrained.get(i).booleanValue()) {
                model.train(this.metric.data);
                this.isTrained.set(i, true);
            }
            ++i;
        }
    }

    public void update(TimeSeries.DataSequence newData) throws Exception {
        if (newData == null) {
            throw new Exception("The input data sequence is null.");
        }
        for (Boolean b : this.isTrained) {
            if (b.booleanValue()) continue;
            throw new Exception("All the models need to be trained before updating.");
        }
        if (newData.size() > 0) {
            newData.setLogicalIndices(this.firstTimeStamp, this.period);
            for (TimeSeriesModel model : this.models) {
                model.update(newData);
            }
        }
    }

    public ArrayList<TimeSeries.DataSequence> forecast(long from, long to) throws Exception {
        for (Boolean b : this.isTrained) {
            if (b.booleanValue()) continue;
            throw new Exception("All the models need to be trained before forecasting.");
        }
        ArrayList<TimeSeries.DataSequence> result = new ArrayList<TimeSeries.DataSequence>();
        for (TimeSeriesModel model : this.models) {
            TimeSeries.DataSequence sequence = null;
            if (this.period != -1L) {
                sequence = new TimeSeries.DataSequence(from, to, this.period);
                sequence.setLogicalIndices(this.firstTimeStamp, this.period);
            } else {
                sequence = new TimeSeries.DataSequence(this.metric.data.getTimes(), this.metric.data.getValues());
            }
            model.predict(sequence);
            result.add(sequence);
        }
        return result;
    }
}

