/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.egads.control;

import com.yahoo.egads.control.AnomalyDetector;
import com.yahoo.egads.control.ModelAdapter;
import com.yahoo.egads.control.ProcessableObject;
import com.yahoo.egads.data.Anomaly;
import com.yahoo.egads.data.TimeSeries;
import com.yahoo.egads.utilities.GUIUtils;
import java.util.ArrayList;
import java.util.Properties;

public class DetectAnomalyProcessable
implements ProcessableObject {
    private ModelAdapter ma;
    private AnomalyDetector ad;
    private Properties config;
    private ArrayList<Anomaly> anomalyList;

    public ArrayList<Anomaly> getAnomalyList() {
        return this.anomalyList;
    }

    DetectAnomalyProcessable(ModelAdapter ma, AnomalyDetector ad, Properties config) {
        this.ma = ma;
        this.ad = ad;
        this.config = config;
        this.anomalyList = new ArrayList();
    }

    @Override
    public void process() throws Exception {
        this.ma.reset();
        this.ma.train();
        ArrayList<TimeSeries.DataSequence> list = this.ma.forecast(this.ma.metric.startTime(), this.ma.metric.lastTime());
        for (TimeSeries.DataSequence ds : list) {
            this.ad.reset();
            this.ad.tune(ds, null);
            this.anomalyList = this.ad.detect(this.ad.metric, ds);
            if (this.config.getProperty("OUTPUT") != null && this.config.getProperty("OUTPUT").equals("ANOMALY_DB")) {
                for (Anomaly anomaly : this.anomalyList) {
                }
                continue;
            }
            if (this.config.getProperty("OUTPUT") != null && this.config.getProperty("OUTPUT").equals("GUI")) {
                GUIUtils.plotResults(this.ma.metric.data, ds, this.anomalyList, this.config);
                continue;
            }
            if (this.config.getProperty("OUTPUT") != null && this.config.getProperty("OUTPUT").equals("PLOT")) {
                for (Anomaly anomaly : this.anomalyList) {
                    System.out.print(anomaly.toPlotString());
                }
                continue;
            }
            for (Anomaly anomaly : this.anomalyList) {
                System.out.print(anomaly.toPerlString());
            }
        }
    }

    @Override
    public ArrayList<Anomaly> result() throws Exception {
        return this.getAnomalyList();
    }
}

