/*
 * Decompiled with CFR 0.152.
 */
package com.github.servicenow.ds.stats.stl;

import com.github.servicenow.ds.stats.TimeSeriesUtilities;
import com.github.servicenow.ds.stats.stl.CyclicSubSeriesSmoother;
import com.github.servicenow.ds.stats.stl.LoessSettings;
import com.github.servicenow.ds.stats.stl.LoessSmoother;
import java.util.Arrays;

public class SeasonalTrendLoess {
    private final double[] fData;
    private Decomposition fDecomposition;
    private final int fPeriodLength;
    private final LoessSettings fSeasonalSettings;
    private final LoessSettings fTrendSettings;
    private final LoessSettings fLowpassSettings;
    private final int fInnerIterations;
    private final int fRobustIterations;
    private final double[] fDetrend;
    private final double[] fExtendedSeasonal;
    private double[] fDeSeasonalized;
    private final CyclicSubSeriesSmoother fCyclicSubSeriesSmoother;
    private final LoessSmoother.Builder fLoessSmootherFactory;
    private final LoessSmoother.Builder fLowpassLoessFactory;

    SeasonalTrendLoess(double[] data, int periodicity, int ni, int no, LoessSettings seasonalSettings, LoessSettings trendSettings, LoessSettings lowpassSettings) {
        this.fData = data;
        int size = data.length;
        this.fPeriodLength = periodicity;
        this.fSeasonalSettings = seasonalSettings;
        this.fTrendSettings = trendSettings;
        this.fLowpassSettings = lowpassSettings;
        this.fInnerIterations = ni;
        this.fRobustIterations = no;
        this.fLoessSmootherFactory = new LoessSmoother.Builder().setWidth(this.fTrendSettings.getWidth()).setDegree(this.fTrendSettings.getDegree()).setJump(this.fTrendSettings.getJump());
        this.fLowpassLoessFactory = new LoessSmoother.Builder().setWidth(this.fLowpassSettings.getWidth()).setDegree(this.fLowpassSettings.getDegree()).setJump(this.fLowpassSettings.getJump());
        this.fCyclicSubSeriesSmoother = new CyclicSubSeriesSmoother.Builder().setWidth(seasonalSettings.getWidth()).setDegree(seasonalSettings.getDegree()).setJump(seasonalSettings.getJump()).setDataLength(size).extrapolateForwardAndBack(1).setPeriodicity(periodicity).build();
        this.fDetrend = new double[size];
        this.fExtendedSeasonal = new double[size + 2 * this.fPeriodLength];
    }

    public static Decomposition performPeriodicDecomposition(double[] data, int periodicity) {
        SeasonalTrendLoess stl = new Builder().setPeriodLength(periodicity).setSeasonalWidth(100 * data.length).setSeasonalDegree(0).setInnerIterations(1).setRobustnessIterations(0).buildSmoother(data);
        return stl.decompose();
    }

    public static Decomposition performRobustPeriodicDecomposition(double[] data, int periodicity) {
        SeasonalTrendLoess stl = new Builder().setPeriodLength(periodicity).setSeasonalWidth(100 * data.length).setSeasonalDegree(0).setInnerIterations(1).setRobustnessIterations(1).buildSmoother(data);
        return stl.decompose();
    }

    public Decomposition decompose() {
        this.fDecomposition = new Decomposition(this.fData);
        int outerIteration = 0;
        while (true) {
            boolean useResidualWeights = outerIteration > 0;
            for (int iteration = 0; iteration < this.fInnerIterations; ++iteration) {
                this.smoothSeasonalSubCycles(useResidualWeights);
                this.removeSeasonality();
                this.updateSeasonalAndTrend(useResidualWeights);
            }
            if (++outerIteration > this.fRobustIterations) break;
            this.fDecomposition.computeResidualWeights();
        }
        this.fDecomposition.updateResiduals();
        Decomposition result = this.fDecomposition;
        this.fDecomposition = null;
        return result;
    }

    private void smoothSeasonalSubCycles(boolean useResidualWeights) {
        double[] data = this.fDecomposition.fData;
        double[] trend = this.fDecomposition.fTrend;
        double[] weights = this.fDecomposition.fWeights;
        for (int i = 0; i < data.length; ++i) {
            this.fDetrend[i] = data[i] - trend[i];
        }
        double[] residualWeights = (double[])(useResidualWeights ? weights : null);
        this.fCyclicSubSeriesSmoother.smoothSeasonal(this.fDetrend, this.fExtendedSeasonal, residualWeights);
    }

    private void removeSeasonality() {
        double[] pass1 = TimeSeriesUtilities.simpleMovingAverage(this.fExtendedSeasonal, this.fPeriodLength);
        double[] pass2 = TimeSeriesUtilities.simpleMovingAverage(pass1, this.fPeriodLength);
        double[] pass3 = TimeSeriesUtilities.simpleMovingAverage(pass2, 3);
        LoessSmoother lowPassLoess = this.fLowpassLoessFactory.setData(pass3).build();
        this.fDeSeasonalized = lowPassLoess.smooth();
    }

    private void updateSeasonalAndTrend(boolean useResidualWeights) {
        double[] data = this.fDecomposition.fData;
        double[] trend = this.fDecomposition.fTrend;
        double[] weights = this.fDecomposition.fWeights;
        double[] seasonal = this.fDecomposition.fSeasonal;
        for (int i = 0; i < data.length; ++i) {
            seasonal[i] = this.fExtendedSeasonal[this.fPeriodLength + i] - this.fDeSeasonalized[i];
            trend[i] = data[i] - seasonal[i];
        }
        double[] residualWeights = (double[])(useResidualWeights ? weights : null);
        LoessSmoother trendSmoother = this.fLoessSmootherFactory.setData(trend).setExternalWeights(residualWeights).build();
        System.arraycopy(trendSmoother.smooth(), 0, trend, 0, trend.length);
    }

    public String toString() {
        return String.format("SeasonalTrendLoess: [\ninner iterations     = %d\nouter iterations     = %d\nperiodicity          = %d\nseasonality settings = %s\ntrend settings       = %s\nlowpass settings     = %s\n]", this.fInnerIterations, this.fRobustIterations, this.fPeriodLength, this.fSeasonalSettings, this.fTrendSettings, this.fLowpassSettings);
    }

    public static class Decomposition {
        private final double[] fData;
        private final double[] fTrend;
        private final double[] fSeasonal;
        private final double[] fResiduals;
        private final double[] fWeights;

        Decomposition(double[] data) {
            this.fData = data;
            int size = this.fData.length;
            this.fTrend = new double[size];
            this.fSeasonal = new double[size];
            this.fResiduals = new double[size];
            this.fWeights = new double[size];
            Arrays.fill(this.fWeights, 1.0);
        }

        public double[] getData() {
            return this.fData;
        }

        public double[] getTrend() {
            return this.fTrend;
        }

        public double[] getSeasonal() {
            return this.fSeasonal;
        }

        public double[] getResidual() {
            return this.fResiduals;
        }

        public double[] getWeights() {
            return this.fWeights;
        }

        private void updateResiduals() {
            for (int i = 0; i < this.fData.length; ++i) {
                this.fResiduals[i] = this.fData[i] - this.fSeasonal[i] - this.fTrend[i];
            }
        }

        private void computeResidualWeights() {
            for (int i = 0; i < this.fData.length; ++i) {
                this.fWeights[i] = Math.abs(this.fData[i] - this.fSeasonal[i] - this.fTrend[i]);
            }
            Arrays.sort(this.fWeights);
            int mi0 = (this.fData.length + 1) / 2 - 1;
            int mi1 = this.fData.length - mi0 - 1;
            double sixMad = 3.0 * (this.fWeights[mi0] + this.fWeights[mi1]);
            double c999 = 0.999 * sixMad;
            double c001 = 0.001 * sixMad;
            for (int i = 0; i < this.fData.length; ++i) {
                double r = Math.abs(this.fData[i] - this.fSeasonal[i] - this.fTrend[i]);
                if (r <= c001) {
                    this.fWeights[i] = 1.0;
                    continue;
                }
                if (r <= c999) {
                    double h = r / sixMad;
                    double w = 1.0 - h * h;
                    this.fWeights[i] = w * w;
                    continue;
                }
                this.fWeights[i] = 0.0;
            }
        }

        public void smoothSeasonal(int width) {
            LoessSmoother.Builder builder = new LoessSmoother.Builder().setWidth(width);
            builder.setDegree(2);
            builder.setJump(1);
            LoessSmoother seasonalSmoother = builder.setData(this.fSeasonal).build();
            double[] smoothedSeasonal = seasonalSmoother.smooth();
            double s0 = this.fSeasonal[0];
            double sN = this.fSeasonal[this.fSeasonal.length - 1];
            System.arraycopy(smoothedSeasonal, 0, this.fSeasonal, 0, smoothedSeasonal.length);
            this.fSeasonal[0] = s0;
            this.fSeasonal[this.fSeasonal.length - 1] = sN;
            for (int i = 0; i < smoothedSeasonal.length; ++i) {
                this.fResiduals[i] = this.fData[i] - this.fTrend[i] - this.fSeasonal[i];
            }
        }
    }

    public static class Builder {
        private Integer fPeriodLength = null;
        private Integer fSeasonalWidth = null;
        private Integer fSeasonalJump = null;
        private Integer fSeasonalDegree = null;
        private Integer fTrendWidth = null;
        private Integer fTrendJump = null;
        private Integer fTrendDegree = null;
        private Integer fLowpassWidth = null;
        private Integer fLowpassJump = null;
        private int fLowpassDegree = 1;
        private int fInnerIterations = 2;
        private int fRobustIterations = 0;
        private boolean fPeriodic = false;
        private boolean fFlatTrend = false;
        private boolean fLinearTrend = false;

        private LoessSettings buildSettings(int width, int degree, Integer jump) {
            if (jump == null) {
                return new LoessSettings(width, degree);
            }
            return new LoessSettings(width, degree, jump);
        }

        public Builder setPeriodLength(int period) {
            if (period < 2) {
                throw new IllegalArgumentException("periodicity must be at least 2");
            }
            this.fPeriodLength = period;
            return this;
        }

        public Builder setSeasonalWidth(int width) {
            this.fSeasonalWidth = width;
            return this;
        }

        public Builder setSeasonalDegree(int degree) {
            this.fSeasonalDegree = degree;
            return this;
        }

        public Builder setSeasonalJump(int jump) {
            this.fSeasonalJump = jump;
            return this;
        }

        public Builder setTrendWidth(int width) {
            this.fTrendWidth = width;
            return this;
        }

        public Builder setTrendDegree(int degree) {
            this.fTrendDegree = degree;
            return this;
        }

        public Builder setTrendJump(int jump) {
            this.fTrendJump = jump;
            return this;
        }

        public Builder setLowpassWidth(int width) {
            this.fLowpassWidth = width;
            return this;
        }

        public Builder setLowpassDegree(int degree) {
            this.fLowpassDegree = degree;
            return this;
        }

        public Builder setLowpassJump(int jump) {
            this.fLowpassJump = jump;
            return this;
        }

        public Builder setInnerIterations(int ni) {
            this.fInnerIterations = ni;
            return this;
        }

        public Builder setRobustnessIterations(int no) {
            this.fRobustIterations = no;
            return this;
        }

        public Builder setRobust() {
            this.fInnerIterations = 1;
            this.fRobustIterations = 15;
            return this;
        }

        public Builder setNonRobust() {
            this.fInnerIterations = 2;
            this.fRobustIterations = 0;
            return this;
        }

        public Builder setRobustFlag(boolean robust) {
            return robust ? this.setRobust() : this.setNonRobust();
        }

        public Builder setPeriodic() {
            this.fPeriodic = true;
            return this;
        }

        public Builder setFlatTrend() {
            this.fLinearTrend = false;
            this.fFlatTrend = true;
            return this;
        }

        public Builder setLinearTrend() {
            this.fFlatTrend = false;
            this.fLinearTrend = true;
            return this;
        }

        public SeasonalTrendLoess buildSmoother(double[] data) {
            this.sanityCheck(data);
            if (this.fPeriodic) {
                this.fSeasonalWidth = 100 * data.length;
                this.fSeasonalDegree = 0;
            } else if (this.fSeasonalDegree == null) {
                this.fSeasonalDegree = 1;
            }
            LoessSettings seasonalSettings = this.buildSettings(this.fSeasonalWidth, this.fSeasonalDegree, this.fSeasonalJump);
            if (this.fFlatTrend) {
                this.fTrendWidth = 100 * this.fPeriodLength * data.length;
                this.fTrendDegree = 0;
            } else if (this.fLinearTrend) {
                this.fTrendWidth = 100 * this.fPeriodLength * data.length;
                this.fTrendDegree = 1;
            } else if (this.fTrendDegree == null) {
                this.fTrendDegree = 1;
            }
            if (this.fTrendWidth == null) {
                this.fTrendWidth = Builder.calcDefaultTrendWidth(this.fPeriodLength, this.fSeasonalWidth);
            }
            LoessSettings trendSettings = this.buildSettings(this.fTrendWidth, this.fTrendDegree, this.fTrendJump);
            if (this.fLowpassWidth == null) {
                this.fLowpassWidth = this.fPeriodLength;
            }
            LoessSettings lowpassSettings = this.buildSettings(this.fLowpassWidth, this.fLowpassDegree, this.fLowpassJump);
            return new SeasonalTrendLoess(data, this.fPeriodLength, this.fInnerIterations, this.fRobustIterations, seasonalSettings, trendSettings, lowpassSettings);
        }

        private static int calcDefaultTrendWidth(int periodicity, int seasonalWidth) {
            return (int)(1.5 * (double)periodicity / (1.0 - 1.5 / (double)seasonalWidth) + 0.5);
        }

        private void sanityCheck(double[] data) {
            if (data == null) {
                throw new IllegalArgumentException("SeasonalTrendLoess.Builder: Data array must be non-null");
            }
            if (this.fPeriodLength == null) {
                throw new IllegalArgumentException("SeasonalTrendLoess.Builder: Period Length must be specified");
            }
            if (data.length < 2 * this.fPeriodLength) {
                throw new IllegalArgumentException("SeasonalTrendLoess.Builder: Data series must be at least 2 * periodicity in length");
            }
            if (this.fPeriodic) {
                if (this.fSeasonalWidth != null) {
                    throw new IllegalArgumentException("SeasonalTrendLoess.Builder: setSeasonalWidth and setPeriodic cannot both be called.");
                }
                if (this.fSeasonalDegree != null) {
                    throw new IllegalArgumentException("SeasonalTrendLoess.Builder: setSeasonalDegree and setPeriodic cannot both be called.");
                }
                if (this.fSeasonalJump != null) {
                    throw new IllegalArgumentException("SeasonalTrendLoess.Builder: setSeasonalJump and setPeriodic cannot both be called.");
                }
            } else if (this.fSeasonalWidth == null) {
                throw new IllegalArgumentException("SeasonalTrendLoess.Builder: setSeasonalWidth or setPeriodic must be called.");
            }
            if (this.fFlatTrend || this.fLinearTrend) {
                if (this.fTrendWidth != null) {
                    throw new IllegalArgumentException("SeasonalTrendLoess.Builder: setTrendWidth incompatible with flat/linear trend.");
                }
                if (this.fTrendDegree != null) {
                    throw new IllegalArgumentException("SeasonalTrendLoess.Builder: setTrendDegree incompatible with flat/linear trend.");
                }
                if (this.fTrendJump != null) {
                    throw new IllegalArgumentException("SeasonalTrendLoess.Builder: setTrendJump incompatible with flat/linear trend.");
                }
            }
        }
    }
}

