/*
 * Decompiled with CFR 0.152.
 */
package com.github.servicenow.ds.stats.stl;

import com.github.servicenow.ds.stats.stl.LoessInterpolator;

class LinearLoessInterpolator
extends LoessInterpolator {
    LinearLoessInterpolator(int width, double[] data, double[] externalWeights) {
        super(width, data, externalWeights);
    }

    @Override
    protected final void updateWeights(double x, int left, int right) {
        double xMean = 0.0;
        for (int i = left; i <= right; ++i) {
            xMean += (double)i * this.fWeights[i];
        }
        double x2Mean = 0.0;
        for (int i = left; i <= right; ++i) {
            double delta = (double)i - xMean;
            x2Mean += this.fWeights[i] * delta * delta;
        }
        double range = this.fData.length - 1;
        if (x2Mean > 1.0E-6 * range * range) {
            double beta = (x - xMean) / x2Mean;
            for (int i = left; i <= right; ++i) {
                int n = i;
                this.fWeights[n] = this.fWeights[n] * (1.0 + beta * ((double)i - xMean));
            }
        }
    }
}

