/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.samples.svg.io;

import java.awt.BasicStroke;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Path2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.URI;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.filechooser.FileFilter;
import net.n3.nanoxml.IXMLElement;
import net.n3.nanoxml.XMLElement;
import net.n3.nanoxml.XMLWriter;
import org.jhotdraw.draw.Drawing;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.io.OutputFormat;
import org.jhotdraw.geom.GrowStroke;
import org.jhotdraw.gui.datatransfer.InputStreamTransferable;
import org.jhotdraw.gui.filechooser.ExtensionFileFilter;
import org.jhotdraw.samples.svg.SVGAttributeKeys;
import org.jhotdraw.samples.svg.figures.SVGBezierFigure;
import org.jhotdraw.samples.svg.figures.SVGEllipseFigure;
import org.jhotdraw.samples.svg.figures.SVGFigure;
import org.jhotdraw.samples.svg.figures.SVGGroupFigure;
import org.jhotdraw.samples.svg.figures.SVGImageFigure;
import org.jhotdraw.samples.svg.figures.SVGPathFigure;
import org.jhotdraw.samples.svg.figures.SVGRectFigure;
import org.jhotdraw.samples.svg.figures.SVGTextAreaFigure;
import org.jhotdraw.samples.svg.figures.SVGTextFigure;
import org.jhotdraw.util.ReversedList;

public class ImageMapOutputFormat
implements OutputFormat {
    private AffineTransform drawingTransform = new AffineTransform();
    private static boolean DEBUG = true;
    private boolean isIncludeNohref = false;
    private Rectangle bounds = new Rectangle(0, 0, Integer.MAX_VALUE, Integer.MAX_VALUE);

    @Override
    public FileFilter getFileFilter() {
        return new ExtensionFileFilter("HTML Image Map", "html");
    }

    @Override
    public String getFileExtension() {
        return "html";
    }

    @Override
    public JComponent getOutputFormatAccessory() {
        return null;
    }

    @Override
    public void write(URI uri, Drawing drawing) throws IOException {
        this.write(new File(uri), drawing);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(File file, Drawing drawing) throws IOException {
        try (BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(file));){
            this.write((OutputStream)out, drawing);
        }
    }

    @Override
    public void write(OutputStream out, Drawing drawing) throws IOException {
        this.write(out, drawing.getChildren());
    }

    public void write(OutputStream out, Drawing drawing, AffineTransform drawingTransform, Dimension imageSize) throws IOException {
        this.write(out, drawing.getChildren(), drawingTransform, imageSize);
    }

    public void write(OutputStream out, List<Figure> figures, AffineTransform drawingTransform, Dimension imageSize) throws IOException {
        this.drawingTransform = drawingTransform == null ? new AffineTransform() : drawingTransform;
        this.bounds = imageSize == null ? new Rectangle(0, 0, Integer.MAX_VALUE, Integer.MAX_VALUE) : new Rectangle(0, 0, imageSize.width, imageSize.height);
        XMLElement document = new XMLElement("map");
        for (Figure f : new ReversedList<Figure>(figures)) {
            this.writeElement(document, f);
        }
        if (!this.isIncludeNohref) {
            for (int i = document.getChildrenCount() - 1; i >= 0; --i) {
                XMLElement child = (XMLElement)document.getChildAtIndex(i);
                if (!child.hasAttribute("nohref")) continue;
                document.removeChildAtIndex(i);
            }
        }
        PrintWriter writer = new PrintWriter(new OutputStreamWriter(out, "UTF-8"));
        for (Object o : document.getChildren()) {
            XMLElement child = (XMLElement)o;
            new XMLWriter(writer).write(child);
        }
        writer.flush();
    }

    public void write(OutputStream out, List<Figure> figures) throws IOException {
        Rectangle2D.Double drawingRect = null;
        for (Figure f : figures) {
            if (drawingRect == null) {
                drawingRect = f.getBounds();
                continue;
            }
            drawingRect.add(f.getBounds());
        }
        AffineTransform tx = new AffineTransform();
        tx.translate(-Math.min(0.0, drawingRect.x), -Math.min(0.0, drawingRect.y));
        this.write(out, figures, tx, new Dimension((int)(Math.abs(drawingRect.x) + drawingRect.width), (int)(Math.abs(drawingRect.y) + drawingRect.height)));
    }

    @Override
    public Transferable createTransferable(Drawing drawing, List<Figure> figures, double scaleFactor) throws IOException {
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        this.write((OutputStream)buf, figures);
        return new InputStreamTransferable(new DataFlavor("text/html", "HTML Image Map"), buf.toByteArray());
    }

    protected void writeElement(IXMLElement parent, Figure f) throws IOException {
        if (f instanceof SVGEllipseFigure) {
            this.writeEllipseElement(parent, (SVGEllipseFigure)f);
        } else if (f instanceof SVGGroupFigure) {
            this.writeGElement(parent, (SVGGroupFigure)f);
        } else if (f instanceof SVGImageFigure) {
            this.writeImageElement(parent, (SVGImageFigure)f);
        } else if (f instanceof SVGPathFigure) {
            SVGPathFigure path = (SVGPathFigure)f;
            if (path.getChildCount() == 1) {
                SVGBezierFigure bezier = path.getChild(0);
                boolean isLinear = true;
                int n = bezier.getNodeCount();
                for (int i = 0; i < n; ++i) {
                    if (bezier.getNode(i).getMask() == 0) continue;
                    isLinear = false;
                    break;
                }
                if (isLinear) {
                    if (bezier.isClosed()) {
                        this.writePolygonElement(parent, path);
                    } else if (bezier.getNodeCount() == 2) {
                        this.writeLineElement(parent, path);
                    } else {
                        this.writePolylineElement(parent, path);
                    }
                } else {
                    this.writePathElement(parent, path);
                }
            } else {
                this.writePathElement(parent, path);
            }
        } else if (f instanceof SVGRectFigure) {
            this.writeRectElement(parent, (SVGRectFigure)f);
        } else if (f instanceof SVGTextFigure) {
            this.writeTextElement(parent, (SVGTextFigure)f);
        } else if (f instanceof SVGTextAreaFigure) {
            this.writeTextAreaElement(parent, (SVGTextAreaFigure)f);
        } else {
            System.out.println("Unable to write: " + f);
        }
    }

    private boolean writeCircleAttributes(IXMLElement elem, SVGFigure f, Ellipse2D.Double ellipse) {
        AffineTransform t = (AffineTransform)SVGAttributeKeys.TRANSFORM.getClone(f);
        if (t == null) {
            t = this.drawingTransform;
        } else {
            t.preConcatenate(this.drawingTransform);
        }
        if ((t.getType() & 3) == t.getType() && ellipse.width == ellipse.height) {
            Point2D.Double start = new Point2D.Double(ellipse.x, ellipse.y);
            Point2D.Double end = new Point2D.Double(ellipse.x + ellipse.width, ellipse.y + ellipse.height);
            t.transform(start, start);
            t.transform(end, end);
            ellipse.x = Math.min(start.x, end.x);
            ellipse.y = Math.min(start.y, end.y);
            ellipse.width = Math.abs(start.x - end.x);
            ellipse.height = Math.abs(start.y - end.y);
            elem.setAttribute("shape", "circle");
            elem.setAttribute("coords", (int)(ellipse.x + ellipse.width / 2.0) + "," + (int)(ellipse.y + ellipse.height / 2.0) + "," + (int)(ellipse.width / 2.0));
            this.writeHrefAttribute(elem, f);
            return this.bounds.intersects(ellipse.getBounds());
        }
        return this.writePolyAttributes(elem, f, ellipse);
    }

    private boolean writeRectAttributes(IXMLElement elem, SVGFigure f, Rectangle2D.Double rect) {
        AffineTransform t = (AffineTransform)SVGAttributeKeys.TRANSFORM.getClone(f);
        if (t == null) {
            t = this.drawingTransform;
        } else {
            t.preConcatenate(this.drawingTransform);
        }
        if ((t.getType() & 3) == t.getType()) {
            Point2D.Double start = new Point2D.Double(rect.x, rect.y);
            Point2D.Double end = new Point2D.Double(rect.x + rect.width, rect.y + rect.height);
            t.transform(start, start);
            t.transform(end, end);
            Rectangle r = new Rectangle((int)Math.min(start.x, end.x), (int)Math.min(start.y, end.y), (int)Math.abs(start.x - end.x), (int)Math.abs(start.y - end.y));
            elem.setAttribute("shape", "rect");
            elem.setAttribute("coords", r.x + "," + r.y + "," + (r.x + r.width) + "," + (r.y + r.height));
            this.writeHrefAttribute(elem, f);
            return this.bounds.intersects(r);
        }
        return this.writePolyAttributes(elem, f, rect);
    }

    private void writeHrefAttribute(IXMLElement elem, SVGFigure f) {
        String link = f.get(SVGAttributeKeys.LINK);
        if (link != null && link.trim().length() > 0) {
            elem.setAttribute("href", link);
            elem.setAttribute("title", link);
            elem.setAttribute("alt", link);
            String linkTarget = f.get(SVGAttributeKeys.LINK_TARGET);
            if (linkTarget != null && linkTarget.trim().length() > 0) {
                elem.setAttribute("target", linkTarget);
            }
        } else {
            elem.setAttribute("nohref", "true");
        }
    }

    private boolean writePolyAttributes(IXMLElement elem, SVGFigure f, Shape shape) {
        AffineTransform t = (AffineTransform)SVGAttributeKeys.TRANSFORM.getClone(f);
        if (t == null) {
            t = this.drawingTransform;
        } else {
            t.preConcatenate(this.drawingTransform);
        }
        StringBuilder buf = new StringBuilder();
        float[] coords = new float[6];
        Path2D.Double path = new Path2D.Double();
        PathIterator i = shape.getPathIterator(t, 1.5);
        while (!i.isDone()) {
            switch (i.currentSegment(coords)) {
                case 0: {
                    if (buf.length() != 0) {
                        throw new IllegalArgumentException("Illegal shape " + shape);
                    }
                    if (buf.length() != 0) {
                        buf.append(',');
                    }
                    buf.append((int)coords[0]);
                    buf.append(',');
                    buf.append((int)coords[1]);
                    path.moveTo(coords[0], coords[1]);
                    break;
                }
                case 1: {
                    if (buf.length() != 0) {
                        buf.append(',');
                    }
                    buf.append((int)coords[0]);
                    buf.append(',');
                    buf.append((int)coords[1]);
                    path.lineTo(coords[0], coords[1]);
                    break;
                }
                case 4: {
                    path.closePath();
                    break;
                }
                default: {
                    throw new InternalError("Illegal segment type " + i.currentSegment(coords));
                }
            }
            i.next();
        }
        elem.setAttribute("shape", "poly");
        elem.setAttribute("coords", buf.toString());
        this.writeHrefAttribute(elem, f);
        return path.intersects(new Rectangle2D.Float(this.bounds.x, this.bounds.y, this.bounds.width, this.bounds.height));
    }

    private void writePathElement(IXMLElement parent, SVGPathFigure f) throws IOException {
        GrowStroke growStroke = new GrowStroke(SVGAttributeKeys.getStrokeTotalWidth(f) / 2.0, SVGAttributeKeys.getStrokeTotalWidth(f));
        BasicStroke basicStroke = new BasicStroke((float)SVGAttributeKeys.getStrokeTotalWidth(f));
        for (Figure child : f.getChildren()) {
            SVGBezierFigure bezier = (SVGBezierFigure)child;
            IXMLElement elem = parent.createElement("area");
            if (bezier.isClosed()) {
                this.writePolyAttributes(elem, f, growStroke.createStrokedShape(bezier.getBezierPath()));
            } else {
                this.writePolyAttributes(elem, f, basicStroke.createStrokedShape(bezier.getBezierPath()));
            }
            parent.addChild(elem);
        }
    }

    private void writePolygonElement(IXMLElement parent, SVGPathFigure f) throws IOException {
        IXMLElement elem = parent.createElement("area");
        if (this.writePolyAttributes(elem, f, new GrowStroke(SVGAttributeKeys.getStrokeTotalWidth(f) / 2.0, SVGAttributeKeys.getStrokeTotalWidth(f)).createStrokedShape(f.getChild(0).getBezierPath()))) {
            parent.addChild(elem);
        }
    }

    private void writePolylineElement(IXMLElement parent, SVGPathFigure f) throws IOException {
        IXMLElement elem = parent.createElement("area");
        if (this.writePolyAttributes(elem, f, new BasicStroke((float)SVGAttributeKeys.getStrokeTotalWidth(f)).createStrokedShape(f.getChild(0).getBezierPath()))) {
            parent.addChild(elem);
        }
    }

    private void writeLineElement(IXMLElement parent, SVGPathFigure f) throws IOException {
        IXMLElement elem = parent.createElement("area");
        if (this.writePolyAttributes(elem, f, new GrowStroke(SVGAttributeKeys.getStrokeTotalWidth(f) / 2.0, SVGAttributeKeys.getStrokeTotalWidth(f)).createStrokedShape(new Line2D.Double(f.getStartPoint(), f.getEndPoint())))) {
            parent.addChild(elem);
        }
    }

    private void writeRectElement(IXMLElement parent, SVGRectFigure f) throws IOException {
        boolean isContained;
        IXMLElement elem = parent.createElement("AREA");
        if (f.getArcHeight() == 0.0 && f.getArcWidth() == 0.0) {
            Rectangle2D.Double rect = f.getBounds();
            double grow = SVGAttributeKeys.getPerpendicularHitGrowth(f);
            rect.x -= grow;
            rect.y -= grow;
            rect.width += grow;
            rect.height += grow;
            isContained = this.writeRectAttributes(elem, f, rect);
        } else {
            isContained = this.writePolyAttributes(elem, f, new GrowStroke(SVGAttributeKeys.getStrokeTotalWidth(f) / 2.0, SVGAttributeKeys.getStrokeTotalWidth(f)).createStrokedShape(new RoundRectangle2D.Double(f.getX(), f.getY(), f.getWidth(), f.getHeight(), f.getArcWidth(), f.getArcHeight())));
        }
        if (isContained) {
            parent.addChild(elem);
        }
    }

    private void writeTextElement(IXMLElement parent, SVGTextFigure f) throws IOException {
        IXMLElement elem = parent.createElement("AREA");
        Rectangle2D.Double rect = f.getBounds();
        double grow = SVGAttributeKeys.getPerpendicularHitGrowth(f);
        rect.x -= grow;
        rect.y -= grow;
        rect.width += grow;
        rect.height += grow;
        if (this.writeRectAttributes(elem, f, rect)) {
            parent.addChild(elem);
        }
    }

    private void writeTextAreaElement(IXMLElement parent, SVGTextAreaFigure f) throws IOException {
        IXMLElement elem = parent.createElement("AREA");
        Rectangle2D.Double rect = f.getBounds();
        double grow = SVGAttributeKeys.getPerpendicularHitGrowth(f);
        rect.x -= grow;
        rect.y -= grow;
        rect.width += grow;
        rect.height += grow;
        if (this.writeRectAttributes(elem, f, rect)) {
            parent.addChild(elem);
        }
    }

    private void writeEllipseElement(IXMLElement parent, SVGEllipseFigure f) throws IOException {
        IXMLElement elem = parent.createElement("area");
        Rectangle2D.Double r = f.getBounds();
        double grow = SVGAttributeKeys.getPerpendicularHitGrowth(f);
        Ellipse2D.Double ellipse = new Ellipse2D.Double(r.x - grow, r.y - grow, r.width + grow, r.height + grow);
        if (this.writeCircleAttributes(elem, f, ellipse)) {
            parent.addChild(elem);
        }
    }

    private void writeGElement(IXMLElement parent, SVGGroupFigure f) throws IOException {
        for (Figure child : new ReversedList<Figure>(f.getChildren())) {
            this.writeElement(parent, child);
        }
    }

    private void writeImageElement(IXMLElement parent, SVGImageFigure f) {
        IXMLElement elem = parent.createElement("area");
        Rectangle2D.Double rect = f.getBounds();
        this.writeRectAttributes(elem, f, rect);
        parent.addChild(elem);
    }
}

