/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.samples.odg.figures;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.handle.AbstractHandle;
import org.jhotdraw.geom.Dimension2DDouble;
import org.jhotdraw.samples.odg.ODGAttributeKeys;
import org.jhotdraw.samples.odg.figures.ODGRectFigure;
import org.jhotdraw.undo.CompositeEdit;
import org.jhotdraw.util.ResourceBundleUtil;

public class ODGRectRadiusHandle
extends AbstractHandle {
    private static final boolean DEBUG = false;
    private static final int OFFSET = 6;
    private Dimension2DDouble originalArc2D;
    CompositeEdit edit;

    public ODGRectRadiusHandle(Figure owner) {
        super(owner);
    }

    @Override
    public void draw(Graphics2D g) {
        this.drawDiamond(g, Color.yellow, Color.black);
    }

    @Override
    protected Rectangle basicGetBounds() {
        Rectangle r = new Rectangle(this.locate());
        r.grow(this.getHandlesize() / 2 + 1, this.getHandlesize() / 2 + 1);
        return r;
    }

    private Point locate() {
        ODGRectFigure owner = (ODGRectFigure)this.getOwner();
        Rectangle2D.Double r = owner.getBounds();
        Point2D.Double p = new Point2D.Double(r.x + owner.getArcWidth(), r.y + owner.getArcHeight());
        if (owner.get(ODGAttributeKeys.TRANSFORM) != null) {
            ((AffineTransform)owner.get(ODGAttributeKeys.TRANSFORM)).transform(p, p);
        }
        return this.view.drawingToView(p);
    }

    @Override
    public void trackStart(Point anchor, int modifiersEx) {
        ODGRectFigure odgRect = (ODGRectFigure)this.getOwner();
        this.originalArc2D = odgRect.getArc();
    }

    @Override
    public void trackStep(Point anchor, Point lead, int modifiersEx) {
        ODGRectFigure odgRect = (ODGRectFigure)this.getOwner();
        odgRect.willChange();
        Point2D.Double p = this.view.viewToDrawing(lead);
        if (odgRect.get(ODGAttributeKeys.TRANSFORM) != null) {
            try {
                ((AffineTransform)odgRect.get(ODGAttributeKeys.TRANSFORM)).inverseTransform(p, p);
            }
            catch (NoninvertibleTransformException noninvertibleTransformException) {
                // empty catch block
            }
        }
        Rectangle2D.Double r = odgRect.getBounds();
        odgRect.setArc(p.x - r.x, p.y - r.y);
        odgRect.changed();
    }

    @Override
    public void trackEnd(Point anchor, Point lead, int modifiersEx) {
        final ODGRectFigure odgRect = (ODGRectFigure)this.getOwner();
        final Dimension2DDouble oldValue = this.originalArc2D;
        final Dimension2DDouble newValue = odgRect.getArc();
        this.view.getDrawing().fireUndoableEditHappened(new AbstractUndoableEdit(){

            @Override
            public String getPresentationName() {
                ResourceBundleUtil labels = ResourceBundleUtil.getBundle("org.jhotdraw.samples.odg.Labels");
                return labels.getString("arc");
            }

            @Override
            public void undo() throws CannotUndoException {
                super.undo();
                odgRect.willChange();
                odgRect.setArc(oldValue);
                odgRect.changed();
            }

            @Override
            public void redo() throws CannotRedoException {
                super.redo();
                odgRect.willChange();
                odgRect.setArc(newValue);
                odgRect.changed();
            }
        });
    }

    @Override
    public String getToolTipText(Point p) {
        return ResourceBundleUtil.getBundle("org.jhotdraw.draw.Labels").getString("handle.roundRectangleRadius.toolTipText");
    }
}

