/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.samples.odg;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import org.jhotdraw.app.action.edit.CopyAction;
import org.jhotdraw.app.action.edit.CutAction;
import org.jhotdraw.app.action.edit.DuplicateAction;
import org.jhotdraw.app.action.edit.PasteAction;
import org.jhotdraw.app.action.edit.SelectAllAction;
import org.jhotdraw.draw.AttributeKey;
import org.jhotdraw.draw.AttributeKeys;
import org.jhotdraw.draw.DefaultDrawing;
import org.jhotdraw.draw.DefaultDrawingEditor;
import org.jhotdraw.draw.DefaultDrawingView;
import org.jhotdraw.draw.Drawing;
import org.jhotdraw.draw.DrawingEditor;
import org.jhotdraw.draw.DrawingView;
import org.jhotdraw.draw.action.BringToFrontAction;
import org.jhotdraw.draw.action.ButtonFactory;
import org.jhotdraw.draw.action.GroupAction;
import org.jhotdraw.draw.action.SelectSameAction;
import org.jhotdraw.draw.action.SendToBackAction;
import org.jhotdraw.draw.action.UngroupAction;
import org.jhotdraw.draw.action.ZoomAction;
import org.jhotdraw.draw.tool.CreationTool;
import org.jhotdraw.draw.tool.TextAreaCreationTool;
import org.jhotdraw.gui.JPopupButton;
import org.jhotdraw.samples.odg.PathTool;
import org.jhotdraw.samples.svg.action.CombineAction;
import org.jhotdraw.samples.svg.action.SplitAction;
import org.jhotdraw.samples.svg.figures.SVGBezierFigure;
import org.jhotdraw.samples.svg.figures.SVGEllipseFigure;
import org.jhotdraw.samples.svg.figures.SVGGroupFigure;
import org.jhotdraw.samples.svg.figures.SVGPathFigure;
import org.jhotdraw.samples.svg.figures.SVGRectFigure;
import org.jhotdraw.samples.svg.figures.SVGTextAreaFigure;
import org.jhotdraw.samples.svg.figures.SVGTextFigure;
import org.jhotdraw.undo.UndoRedoManager;
import org.jhotdraw.util.ResourceBundleUtil;

public class ODGDrawingPanel
extends JPanel {
    private UndoRedoManager undoManager;
    private Drawing drawing;
    private DrawingEditor editor;
    private JToolBar attributesToolbar;
    private JToolBar creationToolbar;
    private JPanel jPanel1;
    private JScrollPane scrollPane;
    private ButtonGroup toolButtonGroup;
    private DefaultDrawingView view;

    public ODGDrawingPanel() {
        ResourceBundleUtil labels = ResourceBundleUtil.getBundle("org.jhotdraw.draw.Labels");
        this.initComponents();
        this.undoManager = new UndoRedoManager();
        this.editor = new DefaultDrawingEditor();
        this.editor.add(this.view);
        this.addCreationButtonsTo(this.creationToolbar, this.editor);
        ButtonFactory.addAttributesButtonsTo(this.attributesToolbar, this.editor);
        JPopupButton pb = new JPopupButton();
        pb.setItemFont(UIManager.getFont("MenuItem.font"));
        labels.configureToolBarButton(pb, "actions");
        pb.add(new DuplicateAction());
        pb.addSeparator();
        pb.add(new GroupAction(this.editor));
        pb.add(new UngroupAction(this.editor));
        pb.addSeparator();
        pb.add(new BringToFrontAction(this.editor));
        pb.add(new SendToBackAction(this.editor));
        pb.addSeparator();
        pb.add(new CutAction());
        pb.add(new CopyAction());
        pb.add(new PasteAction());
        pb.add(new SelectAllAction());
        pb.add(new SelectSameAction(this.editor));
        pb.addSeparator();
        pb.add(this.undoManager.getUndoAction());
        pb.add(this.undoManager.getRedoAction());
        JMenu m = new JMenu(labels.getString("view.zoomFactor.text"));
        ButtonGroup group = new ButtonGroup();
        JRadioButtonMenuItem rbmi = new JRadioButtonMenuItem(new ZoomAction(this.editor, 0.1, null));
        m.add(rbmi);
        group.add(rbmi);
        rbmi = new JRadioButtonMenuItem(new ZoomAction(this.editor, 0.25, null));
        m.add(rbmi);
        group.add(rbmi);
        rbmi = new JRadioButtonMenuItem(new ZoomAction(this.editor, 0.5, null));
        m.add(rbmi);
        group.add(rbmi);
        rbmi = new JRadioButtonMenuItem(new ZoomAction(this.editor, 0.75, null));
        m.add(rbmi);
        group.add(rbmi);
        rbmi = new JRadioButtonMenuItem(new ZoomAction(this.editor, 1.0, null));
        m.add(rbmi);
        rbmi.setSelected(true);
        group.add(rbmi);
        rbmi = new JRadioButtonMenuItem(new ZoomAction(this.editor, 1.25, null));
        m.add(rbmi);
        group.add(rbmi);
        rbmi = new JRadioButtonMenuItem(new ZoomAction(this.editor, 1.5, null));
        m.add(rbmi);
        group.add(rbmi);
        rbmi = new JRadioButtonMenuItem(new ZoomAction(this.editor, 2.0, null));
        m.add(rbmi);
        group.add(rbmi);
        rbmi = new JRadioButtonMenuItem(new ZoomAction(this.editor, 3.0, null));
        m.add(rbmi);
        group.add(rbmi);
        rbmi = new JRadioButtonMenuItem(new ZoomAction(this.editor, 4.0, null));
        m.add(rbmi);
        group.add(rbmi);
        pb.add(m);
        pb.setFocusable(false);
        this.creationToolbar.addSeparator();
        this.creationToolbar.add(pb);
        DefaultDrawing drawing = new DefaultDrawing();
        this.view.setDrawing(drawing);
        drawing.addUndoableEditListener(this.undoManager);
    }

    public void setDrawing(Drawing d) {
        this.undoManager.discardAllEdits();
        this.view.getDrawing().removeUndoableEditListener(this.undoManager);
        this.view.setDrawing(d);
        d.addUndoableEditListener(this.undoManager);
    }

    public Drawing getDrawing() {
        return this.view.getDrawing();
    }

    public DrawingView getView() {
        return this.view;
    }

    public DrawingEditor getEditor() {
        return this.editor;
    }

    public static Collection<Action> createSelectionActions(DrawingEditor editor) {
        LinkedList<Action> a = new LinkedList<Action>();
        a.add(new DuplicateAction());
        a.add(null);
        a.add(new GroupAction(editor, new SVGGroupFigure()));
        a.add(new UngroupAction(editor, new SVGGroupFigure()));
        a.add(new CombineAction(editor));
        a.add(new SplitAction(editor));
        a.add(null);
        a.add(new BringToFrontAction(editor));
        a.add(new SendToBackAction(editor));
        return a;
    }

    private void addCreationButtonsTo(JToolBar tb, DrawingEditor editor) {
        ResourceBundleUtil drawLabels = ResourceBundleUtil.getBundle("org.jhotdraw.draw.Labels");
        ButtonFactory.addSelectionToolTo(tb, editor, ButtonFactory.createDrawingActions(editor), ODGDrawingPanel.createSelectionActions(editor));
        tb.addSeparator();
        HashMap<AttributeKey, Object> attributes = new HashMap<AttributeKey, Object>();
        attributes.put(AttributeKeys.FILL_COLOR, Color.white);
        attributes.put(AttributeKeys.STROKE_COLOR, Color.black);
        ButtonFactory.addToolTo(tb, editor, new CreationTool(new SVGRectFigure(), attributes), "edit.createRectangle", drawLabels);
        ButtonFactory.addToolTo(tb, editor, new CreationTool(new SVGEllipseFigure(), attributes), "edit.createEllipse", drawLabels);
        ButtonFactory.addToolTo(tb, editor, new PathTool(new SVGPathFigure(), new SVGBezierFigure(true), attributes), "edit.createPolygon", drawLabels);
        attributes = new HashMap();
        attributes.put(AttributeKeys.FILL_COLOR, null);
        attributes.put(AttributeKeys.STROKE_COLOR, Color.black);
        ButtonFactory.addToolTo(tb, editor, new CreationTool(new SVGPathFigure(), attributes), "edit.createLine", drawLabels);
        ButtonFactory.addToolTo(tb, editor, new PathTool(new SVGPathFigure(), new SVGBezierFigure(false), attributes), "edit.createScribble", drawLabels);
        attributes = new HashMap();
        attributes.put(AttributeKeys.FILL_COLOR, Color.black);
        attributes.put(AttributeKeys.STROKE_COLOR, null);
        ButtonFactory.addToolTo(tb, editor, new CreationTool(new SVGTextFigure(), attributes), "edit.createText", drawLabels);
        TextAreaCreationTool tat = new TextAreaCreationTool(new SVGTextAreaFigure(), attributes);
        tat.setRubberbandColor(Color.BLACK);
        ButtonFactory.addToolTo(tb, editor, tat, "edit.createTextArea", drawLabels);
    }

    private void initComponents() {
        this.toolButtonGroup = new ButtonGroup();
        this.scrollPane = new JScrollPane();
        this.view = new DefaultDrawingView();
        this.jPanel1 = new JPanel();
        this.creationToolbar = new JToolBar();
        this.attributesToolbar = new JToolBar();
        this.setLayout(new BorderLayout());
        this.scrollPane.setViewportView(this.view);
        this.add((Component)this.scrollPane, "Center");
        this.jPanel1.setLayout(new GridBagLayout());
        this.creationToolbar.setFloatable(false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.jPanel1.add((Component)this.creationToolbar, gridBagConstraints);
        this.attributesToolbar.setFloatable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        this.jPanel1.add((Component)this.attributesToolbar, gridBagConstraints);
        this.add((Component)this.jPanel1, "South");
    }
}

