/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.samples.odg;

import edu.umd.cs.findbugs.annotations.Nullable;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Stroke;
import org.jhotdraw.draw.AttributeKey;
import org.jhotdraw.draw.AttributeKeys;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.samples.odg.Gradient;
import org.jhotdraw.samples.odg.ODGConstants;
import org.jhotdraw.util.ResourceBundleUtil;

public class ODGAttributeKeys
extends AttributeKeys {
    private static final ResourceBundleUtil labels = ResourceBundleUtil.getBundle("org.jhotdraw.samples.svg.Labels");
    public static final AttributeKey<String> NAME = new AttributeKey<Object>("name", String.class, null, true, labels);
    public static final AttributeKey<Double> OPACITY = new AttributeKey<Double>("opacity", Double.class, 1.0, false, labels);
    public static final AttributeKey<ODGConstants.FillStyle> FILL_STYLE = new AttributeKey<ODGConstants.FillStyle>("fill", ODGConstants.FillStyle.class, ODGConstants.FillStyle.SOLID, false, labels);
    public static final AttributeKey<Gradient> FILL_GRADIENT = new AttributeKey<Object>("fillGradient", Gradient.class, null, true, labels);
    public static final AttributeKey<Double> FILL_OPACITY = new AttributeKey<Double>("fillOpacity", Double.class, 1.0, false, labels);
    public static final AttributeKey<ODGConstants.StrokeStyle> STROKE_STYLE = new AttributeKey<ODGConstants.StrokeStyle>("stroke", ODGConstants.StrokeStyle.class, ODGConstants.StrokeStyle.SOLID, false, labels);
    public static final AttributeKey<Gradient> STROKE_GRADIENT = new AttributeKey<Object>("strokeGradient", Gradient.class, null, true, labels);
    public static final AttributeKey<Double> STROKE_OPACITY = new AttributeKey<Double>("strokeOpacity", Double.class, 1.0, false, labels);

    private ODGAttributeKeys() {
    }

    @Nullable
    public static Paint getFillPaint(Figure f) {
        double opacity = f.get(FILL_OPACITY);
        if (f.get(FILL_GRADIENT) != null) {
            return f.get(FILL_GRADIENT).getPaint(f, opacity);
        }
        Color color = (Color)f.get(FILL_COLOR);
        if (color != null && opacity != 1.0) {
            color = new Color(color.getRGB() & 0xFFFFFF | (int)(opacity * 255.0) << 24, true);
        }
        return color;
    }

    @Nullable
    public static Paint getStrokePaint(Figure f) {
        double opacity = f.get(STROKE_OPACITY);
        if (f.get(STROKE_GRADIENT) != null) {
            return f.get(STROKE_GRADIENT).getPaint(f, opacity);
        }
        Color color = (Color)f.get(STROKE_COLOR);
        if (color != null && opacity != 1.0) {
            color = new Color(color.getRGB() & 0xFFFFFF | (int)(opacity * 255.0) << 24, true);
        }
        return color;
    }

    public static Stroke getStroke(Figure f) {
        double strokeWidth = (Double)f.get(STROKE_WIDTH);
        if (strokeWidth == 0.0) {
            strokeWidth = 1.0;
        }
        return new BasicStroke((float)strokeWidth);
    }

    public static void setDefaults(Figure f) {
        f.set(FILL_COLOR, Color.black);
        f.set(WINDING_RULE, AttributeKeys.WindingRule.NON_ZERO);
        f.set(STROKE_COLOR, null);
        f.set(STROKE_WIDTH, 1.0);
        f.set(STROKE_CAP, 0);
        f.set(STROKE_JOIN, 0);
        f.set(STROKE_MITER_LIMIT, 4.0);
        f.set(IS_STROKE_MITER_LIMIT_FACTOR, false);
        f.set(STROKE_DASHES, null);
        f.set(STROKE_DASH_PHASE, 0.0);
        f.set(IS_STROKE_DASH_FACTOR, false);
    }
}

