/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.samples.net;

import java.awt.BorderLayout;
import java.awt.Container;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.net.URL;
import java.util.Collections;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JApplet;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.PopupFactory;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.jhotdraw.draw.Drawing;
import org.jhotdraw.draw.ImageFigure;
import org.jhotdraw.draw.TextFigure;
import org.jhotdraw.draw.io.DOMStorableInputOutputFormat;
import org.jhotdraw.draw.io.ImageInputFormat;
import org.jhotdraw.draw.io.ImageOutputFormat;
import org.jhotdraw.draw.io.TextInputFormat;
import org.jhotdraw.gui.Worker;
import org.jhotdraw.samples.net.NetFactory;
import org.jhotdraw.samples.net.NetPanel;
import org.jhotdraw.xml.DOMFactory;
import org.jhotdraw.xml.NanoXMLDOMInput;
import org.jhotdraw.xml.NanoXMLDOMOutput;

public class NetApplet
extends JApplet {
    private static final String NAME = "JHotDraw Net";
    private NetPanel drawingPanel;
    private ButtonGroup toolButtonGroup;

    @Override
    public String getParameter(String name) {
        try {
            return super.getParameter(name);
        }
        catch (NullPointerException e) {
            return null;
        }
    }

    protected String getVersion() {
        return NetApplet.class.getPackage().getImplementationVersion();
    }

    @Override
    public void init() {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            PopupFactory.setSharedInstance(new PopupFactory());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        Container c = this.getContentPane();
        c.setLayout(new BoxLayout(c, 1));
        String[] labels = this.getAppletInfo().split("\n");
        for (int i = 0; i < labels.length; ++i) {
            c.add(new JLabel(labels[i].length() == 0 ? " " : labels[i]));
        }
        new Worker<Drawing>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected Drawing construct() throws IOException {
                Drawing result;
                System.out.println("getParameter.datafile:" + NetApplet.this.getParameter("datafile"));
                if (NetApplet.this.getParameter("data") != null) {
                    NanoXMLDOMInput domi = new NanoXMLDOMInput((DOMFactory)new NetFactory(), new StringReader(NetApplet.this.getParameter("data")));
                    result = (Drawing)domi.readObject(0);
                } else if (NetApplet.this.getParameter("datafile") != null) {
                    URL url = new URL(NetApplet.this.getDocumentBase(), NetApplet.this.getParameter("datafile"));
                    try (InputStream in = url.openConnection().getInputStream();){
                        NanoXMLDOMInput domi = new NanoXMLDOMInput((DOMFactory)new NetFactory(), in);
                        result = (Drawing)domi.readObject(0);
                    }
                } else {
                    result = null;
                }
                return result;
            }

            @Override
            protected void done(Drawing result) {
                Container c = NetApplet.this.getContentPane();
                c.setLayout(new BorderLayout());
                c.removeAll();
                c.add(NetApplet.this.drawingPanel = new NetPanel());
                if (result != null) {
                    Drawing drawing = result;
                    NetApplet.this.setDrawing(drawing);
                }
            }

            @Override
            protected void failed(Throwable value) {
                Container c = NetApplet.this.getContentPane();
                c.setLayout(new BorderLayout());
                c.removeAll();
                c.add(NetApplet.this.drawingPanel = new NetPanel());
                value.printStackTrace();
                NetApplet.this.getDrawing().add(new TextFigure(value.toString()));
                value.printStackTrace();
            }

            @Override
            protected void finished() {
                Container c = NetApplet.this.getContentPane();
                NetApplet.this.initDrawing(NetApplet.this.getDrawing());
                c.validate();
            }
        }.start();
    }

    private void setDrawing(Drawing d) {
        this.drawingPanel.setDrawing(d);
    }

    private Drawing getDrawing() {
        return this.drawingPanel.getDrawing();
    }

    private void initDrawing(Drawing d) {
        d.setInputFormats(Collections.EMPTY_LIST);
        d.setOutputFormats(Collections.EMPTY_LIST);
        DOMStorableInputOutputFormat ioFormat = new DOMStorableInputOutputFormat(new NetFactory());
        d.addInputFormat(ioFormat);
        d.addInputFormat(new ImageInputFormat(new ImageFigure()));
        d.addInputFormat(new TextInputFormat(new TextFigure()));
        d.addOutputFormat(ioFormat);
        d.addOutputFormat(new ImageOutputFormat());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setData(String text) {
        if (text != null && text.length() > 0) {
            try (StringReader in = new StringReader(text);){
                NanoXMLDOMInput domi = new NanoXMLDOMInput((DOMFactory)new NetFactory(), in);
                domi.openElement("Net");
                this.setDrawing((Drawing)domi.readObject(0));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getData() {
        try (CharArrayWriter out = new CharArrayWriter();){
            NanoXMLDOMOutput domo = new NanoXMLDOMOutput(new NetFactory());
            domo.openElement("Net");
            domo.writeObject(this.getDrawing());
            domo.closeElement();
            domo.save(out);
        }
        return out.toString();
    }

    @Override
    public String[][] getParameterInfo() {
        return new String[][]{{"data", "String", "the data to be displayed by this applet."}, {"datafile", "URL", "an URL to a file containing the data to be displayed by this applet."}};
    }

    @Override
    public String getAppletInfo() {
        return "JHotDraw Net\nVersion " + this.getVersion() + "\n\nCopyright 1996-2010 (c) by the original authors of JHotDraw and all its contributors\nThis software is licensed under LGPL or\nCreative Commons 3.0 BY";
    }

    private void initComponents() {
        this.toolButtonGroup = new ButtonGroup();
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JFrame f = new JFrame("JHotDraw Net Applet");
                f.setDefaultCloseOperation(3);
                NetApplet a = new NetApplet();
                f.getContentPane().add(a);
                a.init();
                f.setSize(500, 400);
                f.setVisible(true);
                a.start();
            }
        });
    }
}

