/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.geom;

import edu.umd.cs.findbugs.annotations.Nullable;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import sun.awt.geom.Crossings;

public abstract class Polygon2D
implements Shape,
Cloneable {
    public int npoints;
    private static final long serialVersionUID = -6460061437900069969L;
    private static final int MIN_LENGTH = 4;

    public void reset() {
        this.npoints = 0;
        this.invalidate();
    }

    public abstract void invalidate();

    public abstract void translate(double var1, double var3);

    public abstract void addPoint(double var1, double var3);

    public void add(Point2D p) {
        this.addPoint(p.getX(), p.getY());
    }

    @Override
    public Rectangle getBounds() {
        return this.getBounds2D().getBounds();
    }

    public boolean contains(Point p) {
        return this.contains(p.x, p.y);
    }

    public boolean contains(int x, int y) {
        return this.contains((double)x, (double)y);
    }

    @Override
    public abstract Rectangle2D getBounds2D();

    @Override
    public abstract boolean contains(double var1, double var3);

    @Override
    public boolean contains(Point2D p) {
        return this.contains(p.getX(), p.getY());
    }

    @Override
    public abstract boolean intersects(double var1, double var3, double var5, double var7);

    @Override
    public boolean intersects(Rectangle2D r) {
        return this.intersects(r.getX(), r.getY(), r.getWidth(), r.getHeight());
    }

    @Override
    public abstract boolean contains(double var1, double var3, double var5, double var7);

    @Override
    public boolean contains(Rectangle2D r) {
        return this.contains(r.getX(), r.getY(), r.getWidth(), r.getHeight());
    }

    @Override
    public abstract PathIterator getPathIterator(AffineTransform var1);

    @Override
    public PathIterator getPathIterator(AffineTransform at, double flatness) {
        return this.getPathIterator(at);
    }

    static class PolygonPathIteratorFloat
    implements PathIterator {
        Float poly;
        AffineTransform transform;
        int index;

        public PolygonPathIteratorFloat(Float pg, AffineTransform at) {
            this.poly = pg;
            this.transform = at;
            if (pg.npoints == 0) {
                this.index = 1;
            }
        }

        @Override
        public int getWindingRule() {
            return 0;
        }

        @Override
        public boolean isDone() {
            return this.index > this.poly.npoints;
        }

        @Override
        public void next() {
            ++this.index;
        }

        @Override
        public int currentSegment(float[] coords) {
            if (this.index >= this.poly.npoints) {
                return 4;
            }
            coords[0] = this.poly.xpoints[this.index];
            coords[1] = this.poly.ypoints[this.index];
            if (this.transform != null) {
                this.transform.transform(coords, 0, coords, 0, 1);
            }
            return this.index == 0 ? 0 : 1;
        }

        @Override
        public int currentSegment(double[] coords) {
            if (this.index >= this.poly.npoints) {
                return 4;
            }
            coords[0] = this.poly.xpoints[this.index];
            coords[1] = this.poly.ypoints[this.index];
            if (this.transform != null) {
                this.transform.transform(coords, 0, coords, 0, 1);
            }
            return this.index == 0 ? 0 : 1;
        }
    }

    static class PolygonPathIteratorDouble
    implements PathIterator {
        Double poly;
        AffineTransform transform;
        int index;

        public PolygonPathIteratorDouble(Double pg, AffineTransform at) {
            this.poly = pg;
            this.transform = at;
            if (pg.npoints == 0) {
                this.index = 1;
            }
        }

        @Override
        public int getWindingRule() {
            return 0;
        }

        @Override
        public boolean isDone() {
            return this.index > this.poly.npoints;
        }

        @Override
        public void next() {
            ++this.index;
        }

        @Override
        public int currentSegment(float[] coords) {
            if (this.index >= this.poly.npoints) {
                return 4;
            }
            coords[0] = (float)this.poly.xpoints[this.index];
            coords[1] = (float)this.poly.ypoints[this.index];
            if (this.transform != null) {
                this.transform.transform(coords, 0, coords, 0, 1);
            }
            return this.index == 0 ? 0 : 1;
        }

        @Override
        public int currentSegment(double[] coords) {
            if (this.index >= this.poly.npoints) {
                return 4;
            }
            coords[0] = this.poly.xpoints[this.index];
            coords[1] = this.poly.ypoints[this.index];
            if (this.transform != null) {
                this.transform.transform(coords, 0, coords, 0, 1);
            }
            return this.index == 0 ? 0 : 1;
        }
    }

    public static class Float
    extends Polygon2D
    implements Serializable {
        public float[] xpoints;
        public float[] ypoints;
        @Nullable
        protected Rectangle2D.Float bounds;

        public Float() {
            this.xpoints = new float[4];
            this.ypoints = new float[4];
        }

        public Float(float[] xpoints, float[] ypoints, int npoints) {
            if (npoints > xpoints.length || npoints > ypoints.length) {
                throw new IndexOutOfBoundsException("npoints > xpoints.length || npoints > ypoints.length");
            }
            if (npoints < 0) {
                throw new NegativeArraySizeException("npoints < 0");
            }
            this.npoints = npoints;
            this.xpoints = new float[npoints];
            System.arraycopy(xpoints, 0, this.xpoints, 0, npoints);
            this.ypoints = new float[npoints];
            System.arraycopy(ypoints, 0, this.ypoints, 0, npoints);
        }

        @Override
        public void translate(double deltaX, double deltaY) {
            this.translate((float)deltaX, (float)deltaY);
        }

        public void translate(float deltaX, float deltaY) {
            int i = 0;
            while (i < this.npoints) {
                int n = i;
                this.xpoints[n] = this.xpoints[n] + deltaX;
                int n2 = i++;
                this.ypoints[n2] = this.ypoints[n2] + deltaY;
            }
            if (this.bounds != null) {
                this.bounds.x += deltaX;
                this.bounds.y += deltaY;
            }
        }

        @Override
        public void invalidate() {
            this.bounds = null;
        }

        void calculateBounds(float[] xpoints, float[] ypoints, int npoints) {
            float boundsMinX = java.lang.Float.MAX_VALUE;
            float boundsMinY = java.lang.Float.MAX_VALUE;
            float boundsMaxX = -3.4028235E38f;
            float boundsMaxY = -3.4028235E38f;
            for (int i = 0; i < npoints; ++i) {
                float x = xpoints[i];
                boundsMinX = Math.min(boundsMinX, x);
                boundsMaxX = Math.max(boundsMaxX, x);
                float y = ypoints[i];
                boundsMinY = Math.min(boundsMinY, y);
                boundsMaxY = Math.max(boundsMaxY, y);
            }
            this.bounds = new Rectangle2D.Float(boundsMinX, boundsMinY, boundsMaxX - boundsMinX, boundsMaxY - boundsMinY);
        }

        void updateBounds(float x, float y) {
            if (x < this.bounds.x) {
                this.bounds.width += this.bounds.x - x;
                this.bounds.x = x;
            } else {
                this.bounds.width = Math.max(this.bounds.width, x - this.bounds.x);
            }
            if (y < this.bounds.y) {
                this.bounds.height += this.bounds.y - y;
                this.bounds.y = y;
            } else {
                this.bounds.height = Math.max(this.bounds.height, y - this.bounds.y);
            }
        }

        @Override
        public boolean contains(double x, double y) {
            return this.contains((float)x, (float)y);
        }

        /*
         * Unable to fully structure code
         */
        public boolean contains(float x, float y) {
            if (this.npoints <= 2 || !this.getBounds2D().contains(x, y)) {
                return false;
            }
            hits = 0;
            lastx = this.xpoints[this.npoints - 1];
            lasty = this.ypoints[this.npoints - 1];
            for (i = 0; i < this.npoints; ++i) {
                block8: {
                    block11: {
                        block12: {
                            block10: {
                                block9: {
                                    curx = this.xpoints[i];
                                    cury = this.ypoints[i];
                                    if (cury == lasty) break block8;
                                    if (!(curx < lastx)) break block9;
                                    if (x >= lastx) break block8;
                                    leftx = curx;
                                    break block10;
                                }
                                if (x >= curx) break block8;
                                leftx = lastx;
                            }
                            if (!(cury < lasty)) break block11;
                            if (y < cury || y >= lasty) break block8;
                            if (!(x < leftx)) break block12;
                            ++hits;
                            break block8;
                        }
                        test1 = x - curx;
                        test2 = y - cury;
                        ** GOTO lbl34
                    }
                    if (y < lasty || y >= cury) break block8;
                    if (x < leftx) {
                        ++hits;
                    } else {
                        test1 = x - lastx;
                        test2 = y - lasty;
lbl34:
                        // 2 sources

                        if (test1 < test2 / (lasty - cury) * (lastx - curx)) {
                            ++hits;
                        }
                    }
                }
                lastx = curx;
                lasty = cury;
            }
            return (hits & true) != false;
        }

        @Override
        public boolean intersects(double x, double y, double w, double h) {
            return this.intersects((float)x, (float)y, (float)w, (float)h);
        }

        public boolean intersects(float x, float y, float w, float h) {
            if (this.npoints <= 0 || !this.getBounds2D().intersects(x, y, w, h)) {
                return false;
            }
            Crossings cross = this.getCrossings(x, y, x + w, y + h);
            return cross == null || !cross.isEmpty();
        }

        @Nullable
        private Crossings getCrossings(float xlo, float ylo, float xhi, float yhi) {
            Crossings.EvenOdd cross = new Crossings.EvenOdd(xlo, ylo, xhi, yhi);
            float lastx = this.xpoints[this.npoints - 1];
            float lasty = this.ypoints[this.npoints - 1];
            for (int i = 0; i < this.npoints; ++i) {
                float curx = this.xpoints[i];
                float cury = this.ypoints[i];
                if (cross.accumulateLine(lastx, lasty, curx, cury)) {
                    return null;
                }
                lastx = curx;
                lasty = cury;
            }
            return cross;
        }

        @Override
        public void addPoint(double x, double y) {
            this.addPoint((float)x, (float)y);
        }

        public void addPoint(float x, float y) {
            if (this.npoints >= this.xpoints.length || this.npoints >= this.ypoints.length) {
                int newLength = this.npoints * 2;
                if (newLength < 4) {
                    newLength = 4;
                } else if ((newLength & newLength - 1) != 0) {
                    newLength = Integer.highestOneBit(newLength);
                }
                float[] helper = new float[newLength];
                System.arraycopy(this.xpoints, 0, helper, 0, this.npoints);
                this.xpoints = helper;
                helper = new float[newLength];
                System.arraycopy(this.ypoints, 0, helper, 0, this.npoints);
                this.ypoints = helper;
            }
            this.xpoints[this.npoints] = x;
            this.ypoints[this.npoints] = y;
            ++this.npoints;
            if (this.bounds != null) {
                this.updateBounds(x, y);
            }
        }

        @Override
        public Rectangle getBounds() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public Rectangle2D getBounds2D() {
            if (this.npoints == 0) {
                return new Rectangle2D.Float();
            }
            if (this.bounds == null) {
                this.calculateBounds(this.xpoints, this.ypoints, this.npoints);
            }
            return (Rectangle2D)this.bounds.clone();
        }

        @Override
        public boolean contains(double x, double y, double w, double h) {
            return this.contains((float)x, (float)y, (float)w, (float)h);
        }

        public boolean contains(float x, float y, float w, float h) {
            if (this.npoints <= 0 || !this.getBounds2D().intersects(x, y, w, h)) {
                return false;
            }
            Crossings cross = this.getCrossings(x, y, x + w, y + h);
            return cross != null && cross.covers(y, y + h);
        }

        @Override
        public PathIterator getPathIterator(AffineTransform at) {
            return new PolygonPathIteratorFloat(this, at);
        }
    }

    public static class Double
    extends Polygon2D
    implements Serializable {
        public double[] xpoints;
        public double[] ypoints;
        @Nullable
        protected Rectangle2D.Double bounds;

        public Double() {
            this.xpoints = new double[4];
            this.ypoints = new double[4];
        }

        public Double(double[] xpoints, double[] ypoints, int npoints) {
            if (npoints > xpoints.length || npoints > ypoints.length) {
                throw new IndexOutOfBoundsException("npoints > xpoints.length || npoints > ypoints.length");
            }
            if (npoints < 0) {
                throw new NegativeArraySizeException("npoints < 0");
            }
            this.npoints = npoints;
            this.xpoints = new double[npoints];
            System.arraycopy(xpoints, 0, this.xpoints, 0, npoints);
            this.ypoints = new double[npoints];
            System.arraycopy(ypoints, 0, this.ypoints, 0, npoints);
        }

        @Override
        public void translate(double deltaX, double deltaY) {
            int i = 0;
            while (i < this.npoints) {
                int n = i;
                this.xpoints[n] = this.xpoints[n] + deltaX;
                int n2 = i++;
                this.ypoints[n2] = this.ypoints[n2] + deltaY;
            }
            if (this.bounds != null) {
                this.bounds.x += deltaX;
                this.bounds.y += deltaY;
            }
        }

        @Override
        public void invalidate() {
            this.bounds = null;
        }

        void calculateBounds(double[] xpoints, double[] ypoints, int npoints) {
            double boundsMinX = java.lang.Double.MAX_VALUE;
            double boundsMinY = java.lang.Double.MAX_VALUE;
            double boundsMaxX = -1.7976931348623157E308;
            double boundsMaxY = -1.7976931348623157E308;
            for (int i = 0; i < npoints; ++i) {
                double x = xpoints[i];
                boundsMinX = Math.min(boundsMinX, x);
                boundsMaxX = Math.max(boundsMaxX, x);
                double y = ypoints[i];
                boundsMinY = Math.min(boundsMinY, y);
                boundsMaxY = Math.max(boundsMaxY, y);
            }
            this.bounds = new Rectangle2D.Double(boundsMinX, boundsMinY, boundsMaxX - boundsMinX, boundsMaxY - boundsMinY);
        }

        void updateBounds(double x, double y) {
            if (x < this.bounds.x) {
                this.bounds.width += this.bounds.x - x;
                this.bounds.x = x;
            } else {
                this.bounds.width = Math.max(this.bounds.width, x - this.bounds.x);
            }
            if (y < this.bounds.y) {
                this.bounds.height += this.bounds.y - y;
                this.bounds.y = y;
            } else {
                this.bounds.height = Math.max(this.bounds.height, y - this.bounds.y);
            }
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public boolean contains(double x, double y) {
            if (this.npoints <= 2 || !this.getBounds2D().contains(x, y)) {
                return false;
            }
            hits = 0;
            lastx = this.xpoints[this.npoints - 1];
            lasty = this.ypoints[this.npoints - 1];
            for (i = 0; i < this.npoints; ++i) {
                block8: {
                    block11: {
                        block12: {
                            block10: {
                                block9: {
                                    curx = this.xpoints[i];
                                    cury = this.ypoints[i];
                                    if (cury == lasty) break block8;
                                    if (!(curx < lastx)) break block9;
                                    if (x >= lastx) break block8;
                                    leftx = curx;
                                    break block10;
                                }
                                if (x >= curx) break block8;
                                leftx = lastx;
                            }
                            if (!(cury < lasty)) break block11;
                            if (y < cury || y >= lasty) break block8;
                            if (!(x < leftx)) break block12;
                            ++hits;
                            break block8;
                        }
                        test1 = x - curx;
                        test2 = y - cury;
                        ** GOTO lbl34
                    }
                    if (y < lasty || y >= cury) break block8;
                    if (x < leftx) {
                        ++hits;
                    } else {
                        test1 = x - lastx;
                        test2 = y - lasty;
lbl34:
                        // 2 sources

                        if (test1 < test2 / (lasty - cury) * (lastx - curx)) {
                            ++hits;
                        }
                    }
                }
                lastx = curx;
                lasty = cury;
            }
            return (hits & true) != false;
        }

        @Override
        public boolean intersects(double x, double y, double w, double h) {
            if (this.npoints <= 0 || !this.getBounds2D().intersects(x, y, w, h)) {
                return false;
            }
            Crossings cross = this.getCrossings(x, y, x + w, y + h);
            return cross == null || !cross.isEmpty();
        }

        @Nullable
        private Crossings getCrossings(double xlo, double ylo, double xhi, double yhi) {
            Crossings.EvenOdd cross = new Crossings.EvenOdd(xlo, ylo, xhi, yhi);
            double lastx = this.xpoints[this.npoints - 1];
            double lasty = this.ypoints[this.npoints - 1];
            for (int i = 0; i < this.npoints; ++i) {
                double curx = this.xpoints[i];
                double cury = this.ypoints[i];
                if (cross.accumulateLine(lastx, lasty, curx, cury)) {
                    return null;
                }
                lastx = curx;
                lasty = cury;
            }
            return cross;
        }

        @Override
        public void addPoint(double x, double y) {
            if (this.npoints >= this.xpoints.length || this.npoints >= this.ypoints.length) {
                int newLength = this.npoints * 2;
                if (newLength < 4) {
                    newLength = 4;
                } else if ((newLength & newLength - 1) != 0) {
                    newLength = Integer.highestOneBit(newLength);
                }
                double[] helper = new double[newLength];
                System.arraycopy(this.xpoints, 0, helper, 0, this.npoints);
                this.xpoints = helper;
                helper = new double[newLength];
                System.arraycopy(this.ypoints, 0, helper, 0, this.npoints);
                this.ypoints = helper;
            }
            this.xpoints[this.npoints] = x;
            this.ypoints[this.npoints] = y;
            ++this.npoints;
            if (this.bounds != null) {
                this.updateBounds(x, y);
            }
        }

        @Override
        public Rectangle getBounds() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public Rectangle2D getBounds2D() {
            if (this.npoints == 0) {
                return new Rectangle2D.Double();
            }
            if (this.bounds == null) {
                this.calculateBounds(this.xpoints, this.ypoints, this.npoints);
            }
            return (Rectangle2D)this.bounds.clone();
        }

        @Override
        public boolean contains(double x, double y, double w, double h) {
            if (this.npoints <= 0 || !this.getBounds2D().intersects(x, y, w, h)) {
                return false;
            }
            Crossings cross = this.getCrossings(x, y, x + w, y + h);
            return cross != null && cross.covers(y, y + h);
        }

        @Override
        public PathIterator getPathIterator(AffineTransform at) {
            return new PolygonPathIteratorDouble(this, at);
        }
    }
}

