/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw.tool;

import edu.umd.cs.findbugs.annotations.Nullable;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.util.Map;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import org.jhotdraw.draw.AttributeKey;
import org.jhotdraw.draw.BezierFigure;
import org.jhotdraw.draw.Drawing;
import org.jhotdraw.draw.DrawingEditor;
import org.jhotdraw.draw.DrawingView;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.tool.AbstractTool;
import org.jhotdraw.geom.Bezier;
import org.jhotdraw.geom.BezierPath;
import org.jhotdraw.geom.Geom;
import org.jhotdraw.util.ResourceBundleUtil;

public class BezierTool
extends AbstractTool {
    private static final boolean DEBUG = false;
    @Nullable
    private Boolean finishWhenMouseReleased;
    @Nullable
    protected Map<AttributeKey, Object> attributes;
    private boolean isToolDoneAfterCreation;
    private BezierFigure prototype;
    @Nullable
    protected BezierFigure createdFigure;
    private int nodeCountBeforeDrag;
    @Nullable
    private String presentationName;
    private Point mouseLocation;
    private DrawingView creationView;

    public BezierTool(BezierFigure prototype) {
        this(prototype, null);
    }

    public BezierTool(BezierFigure prototype, @Nullable Map<AttributeKey, Object> attributes) {
        this(prototype, attributes, null);
    }

    public BezierTool(BezierFigure prototype, @Nullable Map<AttributeKey, Object> attributes, @Nullable String name) {
        this.prototype = prototype;
        this.attributes = attributes;
        if (name == null) {
            ResourceBundleUtil labels = ResourceBundleUtil.getBundle("org.jhotdraw.draw.Labels");
            name = labels.getString("edit.createFigure.text");
        }
        this.presentationName = name;
    }

    public String getPresentationName() {
        return this.presentationName;
    }

    @Override
    public void activate(DrawingEditor editor) {
        super.activate(editor);
        this.getView().setCursor(Cursor.getPredefinedCursor(1));
    }

    @Override
    public void deactivate(DrawingEditor editor) {
        super.deactivate(editor);
        this.getView().setCursor(Cursor.getDefaultCursor());
        if (this.createdFigure != null) {
            if (this.anchor != null && this.mouseLocation != null) {
                Rectangle r = new Rectangle(this.anchor);
                r.add(this.mouseLocation);
                if (this.createdFigure.getNodeCount() > 0 && this.createdFigure.isClosed()) {
                    r.add(this.getView().drawingToView(this.createdFigure.getStartPoint()));
                }
                this.fireAreaInvalidated(r);
            }
            this.finishCreation(this.createdFigure, this.creationView);
            this.createdFigure = null;
        }
    }

    @Override
    public void mousePressed(MouseEvent evt) {
        if (this.mouseLocation != null) {
            Rectangle r = new Rectangle(this.mouseLocation);
            r.add(evt.getPoint());
            r.grow(1, 1);
            this.fireAreaInvalidated(r);
        }
        this.mouseLocation = evt.getPoint();
        super.mousePressed(evt);
        if (this.createdFigure != null && this.creationView != this.getView()) {
            this.finishCreation(this.createdFigure, this.creationView);
            this.createdFigure = null;
        }
        if (this.createdFigure == null) {
            this.creationView = this.getView();
            this.creationView.clearSelection();
            this.finishWhenMouseReleased = null;
            this.createdFigure = this.createFigure();
            this.createdFigure.addNode(new BezierPath.Node(this.creationView.getConstrainer().constrainPoint(this.creationView.viewToDrawing(this.anchor))));
            this.getDrawing().add(this.createdFigure);
        } else if (evt.getClickCount() == 1) {
            this.addPointToFigure(this.creationView.getConstrainer().constrainPoint(this.creationView.viewToDrawing(this.anchor)));
        }
        this.nodeCountBeforeDrag = this.createdFigure.getNodeCount();
    }

    protected BezierFigure createFigure() {
        BezierFigure f = this.prototype.clone();
        this.getEditor().applyDefaultAttributesTo(f);
        if (this.attributes != null) {
            for (Map.Entry<AttributeKey, Object> entry : this.attributes.entrySet()) {
                f.set(entry.getKey(), entry.getValue());
            }
        }
        return f;
    }

    protected Figure getCreatedFigure() {
        return this.createdFigure;
    }

    protected Figure getAddedFigure() {
        return this.createdFigure;
    }

    protected void addPointToFigure(Point2D.Double newPoint) {
        int pointCount = this.createdFigure.getNodeCount();
        this.createdFigure.willChange();
        if (pointCount < 2) {
            this.createdFigure.addNode(new BezierPath.Node(newPoint));
        } else {
            Point2D.Double secondLastPoint;
            Point2D.Double endPoint = this.createdFigure.getEndPoint();
            Point2D.Double double_ = secondLastPoint = pointCount <= 1 ? endPoint : this.createdFigure.getPoint(pointCount - 2, 0);
            if (!newPoint.equals(endPoint)) {
                if (pointCount > 1 && Geom.lineContainsPoint(newPoint.x, newPoint.y, secondLastPoint.x, secondLastPoint.y, endPoint.x, endPoint.y, (double)0.9f / this.getView().getScaleFactor())) {
                    this.createdFigure.setPoint(pointCount - 1, 0, newPoint);
                } else {
                    this.createdFigure.addNode(new BezierPath.Node(newPoint));
                }
            }
        }
        this.createdFigure.changed();
    }

    @Override
    public void mouseClicked(MouseEvent evt) {
        if (this.createdFigure != null) {
            switch (evt.getClickCount()) {
                case 1: {
                    if (this.createdFigure.getNodeCount() <= 2) break;
                    Rectangle r = new Rectangle(this.getView().drawingToView(this.createdFigure.getStartPoint()));
                    r.grow(2, 2);
                    if (!r.contains(evt.getX(), evt.getY())) break;
                    this.createdFigure.setClosed(true);
                    this.finishCreation(this.createdFigure, this.creationView);
                    this.createdFigure = null;
                    if (!this.isToolDoneAfterCreation) break;
                    this.fireToolDone();
                    break;
                }
                case 2: {
                    this.finishWhenMouseReleased = null;
                    this.finishCreation(this.createdFigure, this.creationView);
                    this.createdFigure = null;
                }
            }
        }
    }

    protected void fireUndoEvent(Figure createdFigure, DrawingView creationView) {
        final Figure addedFigure = createdFigure;
        final Drawing addedDrawing = creationView.getDrawing();
        final DrawingView addedView = creationView;
        this.getDrawing().fireUndoableEditHappened(new AbstractUndoableEdit(){

            @Override
            public String getPresentationName() {
                return BezierTool.this.presentationName;
            }

            @Override
            public void undo() throws CannotUndoException {
                super.undo();
                addedDrawing.remove(addedFigure);
            }

            @Override
            public void redo() throws CannotRedoException {
                super.redo();
                addedView.clearSelection();
                addedDrawing.add(addedFigure);
                addedView.addToSelection(addedFigure);
            }
        });
    }

    @Override
    public void mouseReleased(MouseEvent evt) {
        Rectangle r;
        this.isWorking = false;
        if (this.createdFigure.getNodeCount() > this.nodeCountBeforeDrag + 1) {
            this.createdFigure.willChange();
            BezierPath figurePath = this.createdFigure.getBezierPath();
            BezierPath digitizedPath = new BezierPath();
            int n = figurePath.size();
            for (int i = this.nodeCountBeforeDrag - 1; i < n; ++i) {
                digitizedPath.add(figurePath.get(this.nodeCountBeforeDrag - 1));
                figurePath.remove(this.nodeCountBeforeDrag - 1);
            }
            BezierPath fittedPath = this.calculateFittedCurve(digitizedPath);
            figurePath.addAll(fittedPath);
            this.createdFigure.setBezierPath(figurePath);
            this.createdFigure.changed();
            this.nodeCountBeforeDrag = this.createdFigure.getNodeCount();
        }
        if (this.finishWhenMouseReleased == Boolean.TRUE) {
            if (this.createdFigure.getNodeCount() > 1) {
                r = new Rectangle(this.anchor.x, this.anchor.y, 0, 0);
                r.add(evt.getX(), evt.getY());
                this.maybeFireBoundsInvalidated(r);
                this.finishCreation(this.createdFigure, this.creationView);
                this.createdFigure = null;
                this.finishWhenMouseReleased = null;
                return;
            }
        } else if (this.finishWhenMouseReleased == null) {
            this.finishWhenMouseReleased = Boolean.FALSE;
        }
        r = new Rectangle(this.anchor);
        r.add(this.mouseLocation);
        r.add(evt.getPoint());
        r.grow(1, 1);
        this.fireAreaInvalidated(r);
        this.anchor.x = evt.getX();
        this.anchor.y = evt.getY();
        this.mouseLocation = evt.getPoint();
    }

    protected void finishCreation(BezierFigure createdFigure, DrawingView creationView) {
        this.fireUndoEvent(createdFigure, creationView);
        creationView.addToSelection(createdFigure);
        if (this.isToolDoneAfterCreation) {
            this.fireToolDone();
        }
    }

    @Override
    public void mouseDragged(MouseEvent evt) {
        if (this.finishWhenMouseReleased == null) {
            this.finishWhenMouseReleased = Boolean.TRUE;
        }
        int x = evt.getX();
        int y = evt.getY();
        this.addPointToFigure(this.getView().viewToDrawing(new Point(x, y)));
    }

    @Override
    public void draw(Graphics2D g) {
        if (this.createdFigure != null && this.anchor != null && this.mouseLocation != null && this.getView() == this.creationView) {
            g.setColor(Color.BLACK);
            g.setStroke(new BasicStroke(1.0f, 0, 2, 0.0f, new float[]{1.0f, 5.0f}, 0.0f));
            g.drawLine(this.anchor.x, this.anchor.y, this.mouseLocation.x, this.mouseLocation.y);
            if (!this.isWorking && this.createdFigure.isClosed() && this.createdFigure.getNodeCount() > 1) {
                Point p = this.creationView.drawingToView(this.createdFigure.getStartPoint());
                g.drawLine(this.mouseLocation.x, this.mouseLocation.y, p.x, p.y);
            }
        }
    }

    @Override
    public void mouseMoved(MouseEvent evt) {
        if (this.createdFigure != null && this.anchor != null && this.mouseLocation != null && evt.getSource() == this.creationView) {
            Rectangle r = new Rectangle(this.anchor);
            r.add(this.mouseLocation);
            r.add(evt.getPoint());
            if (this.createdFigure.isClosed() && this.createdFigure.getNodeCount() > 0) {
                r.add(this.creationView.drawingToView(this.createdFigure.getStartPoint()));
            }
            r.grow(1, 1);
            this.fireAreaInvalidated(r);
            this.mouseLocation = evt.getPoint();
        }
    }

    protected BezierPath calculateFittedCurve(BezierPath path) {
        return Bezier.fitBezierPath(path, 1.5 / this.getView().getScaleFactor());
    }

    public void setToolDoneAfterCreation(boolean b) {
        this.isToolDoneAfterCreation = b;
    }

    public boolean isToolDoneAfterCreation() {
        return this.isToolDoneAfterCreation;
    }
}

