/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw.tool;

import edu.umd.cs.findbugs.annotations.Nullable;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.KeyStroke;
import javax.swing.event.EventListenerList;
import javax.swing.event.UndoableEditListener;
import org.jhotdraw.beans.AbstractBean;
import org.jhotdraw.draw.AttributeKeys;
import org.jhotdraw.draw.Drawing;
import org.jhotdraw.draw.DrawingEditor;
import org.jhotdraw.draw.DrawingEditorProxy;
import org.jhotdraw.draw.DrawingView;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.event.ToolEvent;
import org.jhotdraw.draw.event.ToolListener;
import org.jhotdraw.draw.handle.Handle;
import org.jhotdraw.draw.tool.Tool;

public abstract class AbstractTool
extends AbstractBean
implements Tool {
    private boolean isActive;
    protected boolean isWorking;
    protected DrawingEditor editor;
    protected Point anchor = new Point();
    protected EventListenerList listenerList = new EventListenerList();
    private DrawingEditorProxy editorProxy = new DrawingEditorProxy();
    private InputMap inputMap;
    private ActionMap actionMap;

    public AbstractTool() {
        this.setInputMap(this.createInputMap());
        this.setActionMap(this.createActionMap());
    }

    public void addUndoableEditListener(UndoableEditListener l) {
        this.listenerList.add(UndoableEditListener.class, l);
    }

    public void removeUndoableEditListener(UndoableEditListener l) {
        this.listenerList.remove(UndoableEditListener.class, l);
    }

    @Override
    public void activate(DrawingEditor editor) {
        this.editor = editor;
        this.editorProxy.setTarget(editor);
        this.isActive = true;
        for (DrawingView v : editor.getDrawingViews()) {
            v.repaintHandles();
        }
    }

    @Override
    public void deactivate(DrawingEditor editor) {
        this.editor = editor;
        this.editorProxy.setTarget(null);
        this.isActive = false;
    }

    public boolean isActive() {
        return this.isActive;
    }

    protected DrawingView getView() {
        return this.editor.getActiveView();
    }

    protected DrawingEditor getEditor() {
        return this.editor;
    }

    protected Drawing getDrawing() {
        return this.getView().getDrawing();
    }

    protected Point2D.Double viewToDrawing(Point p) {
        return this.constrainPoint(this.getView().viewToDrawing(p));
    }

    protected Point2D.Double constrainPoint(Point p) {
        return this.constrainPoint(this.getView().viewToDrawing(p));
    }

    protected Point2D.Double constrainPoint(Point2D.Double p) {
        return this.getView().getConstrainer().constrainPoint(p);
    }

    public void setInputMap(InputMap newValue) {
        this.inputMap = newValue;
    }

    public InputMap getInputMap() {
        return this.inputMap;
    }

    public void setActionMap(ActionMap newValue) {
        this.actionMap = newValue;
    }

    public ActionMap getActionMap() {
        return this.actionMap;
    }

    @Override
    public void editDelete() {
        this.getView().getDrawing().removeAll(this.getView().getSelectedFigures());
    }

    @Override
    public void editCut() {
    }

    @Override
    public void editCopy() {
    }

    @Override
    public void editDuplicate() {
    }

    @Override
    public void editPaste() {
    }

    @Override
    public void keyReleased(KeyEvent evt) {
        this.fireToolDone();
    }

    @Override
    public void keyTyped(KeyEvent evt) {
    }

    @Override
    public void keyPressed(KeyEvent evt) {
        if (!evt.isConsumed()) {
            InputMap im;
            if (evt.getSource() instanceof Container) {
                this.editor.setActiveView(this.editor.findView((Container)evt.getSource()));
            }
            Object obj = null;
            if (this.inputMap != null) {
                obj = this.inputMap.get(KeyStroke.getKeyStroke(evt.getKeyCode(), evt.getModifiers(), false));
            }
            if (obj == null && (im = this.editor.getInputMap()) != null) {
                obj = im.get(KeyStroke.getKeyStroke(evt.getKeyCode(), evt.getModifiers(), false));
            }
            ActionListener al = null;
            if (obj instanceof ActionListener) {
                al = (ActionListener)obj;
            } else if (obj != null) {
                if (this.actionMap != null) {
                    al = this.actionMap.get(obj);
                }
                if (al == null) {
                    al = this.editor.getActionMap().get(obj);
                }
            }
            if (al != null) {
                evt.consume();
                al.actionPerformed(new ActionEvent(this, 1001, "tool", evt.getWhen(), evt.getModifiers()));
                this.fireToolDone();
            }
        }
    }

    @Nullable
    protected InputMap createInputMap() {
        return null;
    }

    @Nullable
    protected ActionMap createActionMap() {
        return null;
    }

    @Override
    public void mouseClicked(MouseEvent evt) {
    }

    @Override
    public void mouseEntered(MouseEvent evt) {
    }

    @Override
    public void mouseExited(MouseEvent evt) {
    }

    @Override
    public void mouseMoved(MouseEvent evt) {
    }

    @Override
    public void mousePressed(MouseEvent evt) {
        DrawingView view = this.editor.findView((Container)evt.getSource());
        view.requestFocus();
        this.anchor = new Point(evt.getX(), evt.getY());
        this.isWorking = true;
        this.fireToolStarted(view);
    }

    @Override
    public void mouseReleased(MouseEvent evt) {
        this.isWorking = false;
    }

    @Override
    public void addToolListener(ToolListener l) {
        this.listenerList.add(ToolListener.class, l);
    }

    @Override
    public void removeToolListener(ToolListener l) {
        this.listenerList.remove(ToolListener.class, l);
    }

    protected void fireToolStarted(DrawingView view) {
        ToolEvent event = null;
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ToolListener.class) continue;
            if (event == null) {
                event = new ToolEvent(this, view, new Rectangle(0, 0, -1, -1));
            }
            ((ToolListener)listeners[i + 1]).toolStarted(event);
        }
    }

    protected void fireToolDone() {
        ToolEvent event = null;
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ToolListener.class) continue;
            if (event == null) {
                event = new ToolEvent(this, this.getView(), new Rectangle(0, 0, -1, -1));
            }
            ((ToolListener)listeners[i + 1]).toolDone(event);
        }
    }

    protected void fireAreaInvalidated(Rectangle2D.Double r) {
        Point p1 = this.getView().drawingToView(new Point2D.Double(r.x, r.y));
        Point p2 = this.getView().drawingToView(new Point2D.Double(r.x + r.width, r.y + r.height));
        this.fireAreaInvalidated(new Rectangle(p1.x, p1.y, p2.x - p1.x, p2.y - p1.y));
    }

    protected void fireAreaInvalidated(Rectangle invalidatedArea) {
        ToolEvent event = null;
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ToolListener.class) continue;
            if (event == null) {
                event = new ToolEvent(this, this.getView(), invalidatedArea);
            }
            ((ToolListener)listeners[i + 1]).areaInvalidated(event);
        }
    }

    protected void maybeFireBoundsInvalidated(Rectangle invalidatedArea) {
        Drawing d = this.getDrawing();
        Rectangle2D.Double canvasBounds = new Rectangle2D.Double(0.0, 0.0, 0.0, 0.0);
        if (d.get(AttributeKeys.CANVAS_WIDTH) != null) {
            canvasBounds.width += d.get(AttributeKeys.CANVAS_WIDTH).doubleValue();
        }
        if (d.get(AttributeKeys.CANVAS_HEIGHT) != null) {
            canvasBounds.height += d.get(AttributeKeys.CANVAS_HEIGHT).doubleValue();
        }
        if (!canvasBounds.contains(invalidatedArea)) {
            this.fireBoundsInvalidated(invalidatedArea);
        }
    }

    protected void fireBoundsInvalidated(Rectangle invalidatedArea) {
        ToolEvent event = null;
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ToolListener.class) continue;
            if (event == null) {
                event = new ToolEvent(this, this.getView(), invalidatedArea);
            }
            ((ToolListener)listeners[i + 1]).boundsInvalidated(event);
        }
    }

    @Override
    public void draw(Graphics2D g) {
    }

    public void updateCursor(DrawingView view, Point p) {
        if (view.isEnabled()) {
            Handle handle = view.findHandle(p);
            if (handle != null) {
                view.setCursor(handle.getCursor());
            } else {
                Figure figure = view.findFigure(p);
                Point2D.Double point = view.viewToDrawing(p);
                Drawing drawing = view.getDrawing();
                while (figure != null && !figure.isSelectable()) {
                    figure = drawing.findFigureBehind(point, figure);
                }
                if (figure != null) {
                    view.setCursor(figure.getCursor(view.viewToDrawing(p)));
                } else {
                    view.setCursor(Cursor.getDefaultCursor());
                }
            }
        } else {
            view.setCursor(Cursor.getPredefinedCursor(3));
        }
    }

    @Override
    public String getToolTipText(DrawingView view, MouseEvent evt) {
        return null;
    }

    @Override
    public boolean supportsHandleInteraction() {
        return false;
    }
}

