/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw;

import edu.umd.cs.findbugs.annotations.Nullable;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import org.jhotdraw.draw.AttributeKey;
import org.jhotdraw.draw.CompositeFigure;
import org.jhotdraw.draw.Drawing;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.LineConnectionFigure;
import org.jhotdraw.draw.event.CompositeFigureEvent;
import org.jhotdraw.draw.event.CompositeFigureListener;
import org.jhotdraw.draw.event.FigureAdapter;
import org.jhotdraw.draw.event.FigureEvent;
import org.jhotdraw.draw.layouter.Layouter;
import org.jhotdraw.util.ReversedList;

public class LabeledLineConnectionFigure
extends LineConnectionFigure
implements CompositeFigure {
    private Layouter layouter;
    private ArrayList<Figure> children = new ArrayList();
    @Nullable
    private transient Rectangle2D.Double cachedDrawingArea;
    private ChildHandler childHandler = new ChildHandler(this);

    @Override
    public void draw(Graphics2D g) {
        super.draw(g);
        for (Figure child : this.children) {
            if (!child.isVisible()) continue;
            child.draw(g);
        }
    }

    @Override
    public void transform(AffineTransform tx) {
        super.transform(tx);
        for (Figure f : this.children) {
            f.transform(tx);
        }
        this.invalidate();
    }

    @Override
    public Rectangle2D.Double getDrawingArea() {
        if (this.cachedDrawingArea == null) {
            this.cachedDrawingArea = super.getDrawingArea();
            for (Figure child : this.getChildrenFrontToBack()) {
                Rectangle2D.Double childBounds;
                if (!child.isVisible() || (childBounds = child.getDrawingArea()).isEmpty()) continue;
                this.cachedDrawingArea.add(childBounds);
            }
        }
        return (Rectangle2D.Double)this.cachedDrawingArea.clone();
    }

    @Override
    public boolean contains(Point2D.Double p) {
        if (this.getDrawingArea().contains(p)) {
            for (Figure child : this.getChildrenFrontToBack()) {
                if (!child.isVisible() || !child.contains(p)) continue;
                return true;
            }
            return super.contains(p);
        }
        return false;
    }

    @Override
    public <T> void set(AttributeKey<T> key, T newValue) {
        super.set(key, newValue);
        if (this.isAttributeEnabled(key) && this.children != null) {
            for (Figure child : this.children) {
                child.set(key, newValue);
            }
        }
    }

    @Override
    public Figure findFigureInside(Point2D.Double p) {
        if (this.getDrawingArea().contains(p)) {
            Figure found = null;
            for (Figure child : this.getChildrenFrontToBack()) {
                if (!child.isVisible() || (found = child.findFigureInside(p)) == null) continue;
                return found;
            }
        }
        return null;
    }

    @Override
    public void updateConnection() {
        super.updateConnection();
        this.layout();
    }

    @Override
    public List<Figure> getChildren() {
        return Collections.unmodifiableList(this.children);
    }

    @Override
    public int getChildCount() {
        return this.children.size();
    }

    @Override
    public Figure getChild(int index) {
        return this.children.get(index);
    }

    public List<Figure> getChildrenFrontToBack() {
        return this.children == null ? new LinkedList() : new ReversedList<Figure>(this.children);
    }

    @Override
    public boolean add(Figure figure) {
        this.basicAdd(figure);
        if (this.getDrawing() != null) {
            figure.addNotify(this.getDrawing());
        }
        return true;
    }

    @Override
    public void add(int index, Figure figure) {
        this.basicAdd(index, figure);
        if (this.getDrawing() != null) {
            figure.addNotify(this.getDrawing());
        }
    }

    @Override
    public void basicAdd(Figure figure) {
        this.basicAdd(this.children.size(), figure);
    }

    @Override
    public void basicAdd(int index, Figure figure) {
        this.children.add(index, figure);
        figure.addFigureListener(this.childHandler);
        this.invalidate();
    }

    @Override
    public boolean remove(Figure figure) {
        int index = this.children.indexOf(figure);
        if (index == -1) {
            return false;
        }
        this.willChange();
        this.basicRemoveChild(index);
        if (this.getDrawing() != null) {
            figure.removeNotify(this.getDrawing());
        }
        this.changed();
        return true;
    }

    @Override
    public Figure removeChild(int index) {
        this.willChange();
        Figure figure = this.basicRemoveChild(index);
        if (this.getDrawing() != null) {
            figure.removeNotify(this.getDrawing());
        }
        this.changed();
        return figure;
    }

    @Override
    public int basicRemove(Figure figure) {
        int index = this.children.indexOf(figure);
        if (index != -1) {
            this.basicRemoveChild(index);
        }
        return index;
    }

    @Override
    public Figure basicRemoveChild(int index) {
        Figure figure = this.children.remove(index);
        figure.removeFigureListener(this.childHandler);
        return figure;
    }

    @Override
    public void removeAllChildren() {
        this.willChange();
        while (this.children.size() > 0) {
            Figure figure = this.basicRemoveChild(this.children.size() - 1);
            if (this.getDrawing() == null) continue;
            figure.removeNotify(this.getDrawing());
        }
        this.changed();
    }

    @Override
    public void basicRemoveAllChildren() {
        while (this.children.size() > 0) {
            this.basicRemoveChild(this.children.size() - 1);
        }
    }

    @Override
    public Layouter getLayouter() {
        return this.layouter;
    }

    @Override
    public void setLayouter(Layouter newLayouter) {
        this.layouter = newLayouter;
    }

    @Override
    public void layout() {
        if (this.getLayouter() != null) {
            Rectangle2D.Double bounds = this.getBounds();
            Point2D.Double p = new Point2D.Double(bounds.x, bounds.y);
            this.getLayouter().layout(this, p, p);
            this.invalidate();
        }
    }

    @Override
    public void invalidate() {
        super.invalidate();
        this.cachedDrawingArea = null;
    }

    @Override
    public void validate() {
        super.validate();
        this.layout();
    }

    @Override
    public void addNotify(Drawing drawing) {
        for (Figure child : new LinkedList<Figure>(this.children)) {
            child.addNotify(drawing);
        }
        super.addNotify(drawing);
    }

    @Override
    public void removeNotify(Drawing drawing) {
        for (Figure child : new LinkedList<Figure>(this.children)) {
            child.removeNotify(drawing);
        }
        super.removeNotify(drawing);
    }

    @Override
    public void removeCompositeFigureListener(CompositeFigureListener listener) {
        this.listenerList.remove(CompositeFigureListener.class, listener);
    }

    @Override
    public void addCompositeFigureListener(CompositeFigureListener listener) {
        this.listenerList.add(CompositeFigureListener.class, listener);
    }

    protected void fireFigureAdded(Figure f, int zIndex) {
        CompositeFigureEvent event = null;
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != CompositeFigureListener.class) continue;
            if (event == null) {
                event = new CompositeFigureEvent(this, f, f.getDrawingArea(), zIndex);
            }
            ((CompositeFigureListener)listeners[i + 1]).figureAdded(event);
        }
    }

    protected void fireFigureRemoved(Figure f, int zIndex) {
        CompositeFigureEvent event = null;
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != CompositeFigureListener.class) continue;
            if (event == null) {
                event = new CompositeFigureEvent(this, f, f.getDrawingArea(), zIndex);
            }
            ((CompositeFigureListener)listeners[i + 1]).figureRemoved(event);
        }
    }

    @Override
    public LabeledLineConnectionFigure clone() {
        LabeledLineConnectionFigure that = (LabeledLineConnectionFigure)super.clone();
        that.childHandler = new ChildHandler(that);
        that.children = new ArrayList();
        for (Figure thisChild : this.children) {
            Figure thatChild = thisChild.clone();
            that.children.add(thatChild);
            thatChild.addFigureListener(that.childHandler);
        }
        return that;
    }

    @Override
    public void remap(Map<Figure, Figure> oldToNew, boolean disconnectIfNotInMap) {
        super.remap(oldToNew, disconnectIfNotInMap);
        for (Figure child : this.children) {
            child.remap(oldToNew, disconnectIfNotInMap);
        }
    }

    @Override
    public boolean contains(Figure f) {
        return this.children.contains(f);
    }

    @Override
    public int indexOf(Figure child) {
        return this.children.indexOf(child);
    }

    private static class ChildHandler
    extends FigureAdapter
    implements UndoableEditListener,
    Serializable {
        private LabeledLineConnectionFigure owner;

        private ChildHandler(LabeledLineConnectionFigure owner) {
            this.owner = owner;
        }

        @Override
        public void figureRequestRemove(FigureEvent e) {
            this.owner.remove(e.getFigure());
        }

        @Override
        public void figureChanged(FigureEvent e) {
            if (!this.owner.isChanging()) {
                this.owner.willChange();
                this.owner.fireFigureChanged(e);
                this.owner.changed();
            }
        }

        @Override
        public void areaInvalidated(FigureEvent e) {
            if (!this.owner.isChanging()) {
                this.owner.fireAreaInvalidated(e.getInvalidatedArea());
            }
        }

        @Override
        public void undoableEditHappened(UndoableEditEvent e) {
            this.owner.fireUndoableEditHappened(e.getEdit());
        }
    }
}

