/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw;

import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.jhotdraw.draw.AbstractAttributedFigure;
import org.jhotdraw.draw.AttributeKey;
import org.jhotdraw.draw.AttributeKeys;
import org.jhotdraw.draw.ConnectionFigure;
import org.jhotdraw.draw.connector.ChopDiamondConnector;
import org.jhotdraw.draw.connector.Connector;
import org.jhotdraw.geom.Geom;

public class DiamondFigure
extends AbstractAttributedFigure {
    public static final AttributeKey<Boolean> IS_QUADRATIC = new AttributeKey<Boolean>("isQuadratic", Boolean.class, false);
    private Rectangle2D.Double rectangle;

    public DiamondFigure() {
        this(0.0, 0.0, 0.0, 0.0);
    }

    public DiamondFigure(double x, double y, double width, double height) {
        this.rectangle = new Rectangle2D.Double(x, y, width, height);
    }

    @Override
    protected void drawFill(Graphics2D g) {
        double grow;
        Rectangle2D.Double r = (Rectangle2D.Double)this.rectangle.clone();
        if (this.get(IS_QUADRATIC).booleanValue()) {
            double side = Math.max(r.width, r.height);
            r.x -= (side - r.width) / 2.0;
            r.y -= (side - r.height) / 2.0;
            r.width = r.height = side;
        }
        if ((grow = AttributeKeys.getPerpendicularFillGrowth(this)) != 0.0) {
            double w = r.width / 2.0;
            double h = r.height / 2.0;
            double lineLength = Math.sqrt(w * w + h * h);
            double scale = grow / lineLength;
            double yb = scale * w;
            double xa = scale * h;
            double growx = yb * yb / xa + xa;
            double growy = xa * xa / yb + yb;
            Geom.grow(r, growx, growy);
        }
        Path2D.Double diamond = new Path2D.Double();
        diamond.moveTo(r.x + r.width / 2.0, r.y);
        diamond.lineTo(r.x + r.width, r.y + r.height / 2.0);
        diamond.lineTo(r.x + r.width / 2.0, r.y + r.height);
        diamond.lineTo(r.x, r.y + r.height / 2.0);
        diamond.closePath();
        g.fill(diamond);
    }

    @Override
    protected void drawStroke(Graphics2D g) {
        double grow;
        Rectangle2D.Double r = (Rectangle2D.Double)this.rectangle.clone();
        if (this.get(IS_QUADRATIC).booleanValue()) {
            double side = Math.max(r.width, r.height);
            r.x -= (side - r.width) / 2.0;
            r.y -= (side - r.height) / 2.0;
            r.width = r.height = side;
        }
        if ((grow = AttributeKeys.getPerpendicularDrawGrowth(this)) != 0.0) {
            double w = r.width / 2.0;
            double h = r.height / 2.0;
            double lineLength = Math.sqrt(w * w + h * h);
            double scale = grow / lineLength;
            double yb = scale * w;
            double xa = scale * h;
            double growx = yb * yb / xa + xa;
            double growy = xa * xa / yb + yb;
            Geom.grow(r, growx, growy);
        }
        Path2D.Double diamond = new Path2D.Double();
        diamond.moveTo(r.x + r.width / 2.0, r.y);
        diamond.lineTo(r.x + r.width, r.y + r.height / 2.0);
        diamond.lineTo(r.x + r.width / 2.0, r.y + r.height);
        diamond.lineTo(r.x, r.y + r.height / 2.0);
        diamond.closePath();
        g.draw(diamond);
    }

    @Override
    public Rectangle2D.Double getBounds() {
        Rectangle2D.Double bounds = (Rectangle2D.Double)this.rectangle.clone();
        return bounds;
    }

    @Override
    public Rectangle2D.Double getDrawingArea() {
        double grow;
        Rectangle2D.Double r = (Rectangle2D.Double)this.rectangle.clone();
        if (this.get(IS_QUADRATIC).booleanValue()) {
            double side = Math.max(r.width, r.height);
            r.x -= (side - r.width) / 2.0;
            r.y -= (side - r.height) / 2.0;
            r.width = r.height = side;
        }
        if ((grow = AttributeKeys.getPerpendicularHitGrowth(this)) != 0.0) {
            double w = r.width / 2.0;
            double h = r.height / 2.0;
            double lineLength = Math.sqrt(w * w + h * h);
            double scale = grow / lineLength;
            double yb = scale * w;
            double xa = scale * h;
            double growx = yb * yb / xa + xa;
            double growy = xa * xa / yb + yb;
            Geom.grow(r, growx, growy);
        }
        return r;
    }

    @Override
    public boolean contains(Point2D.Double p) {
        double grow;
        Rectangle2D.Double r = (Rectangle2D.Double)this.rectangle.clone();
        if (this.get(IS_QUADRATIC).booleanValue()) {
            double side = Math.max(r.width, r.height);
            r.x -= (side - r.width) / 2.0;
            r.y -= (side - r.height) / 2.0;
            r.width = r.height = side;
        }
        if ((grow = AttributeKeys.getPerpendicularFillGrowth(this)) != 0.0) {
            double w = r.width / 2.0;
            double h = r.height / 2.0;
            double lineLength = Math.sqrt(w * w + h * h);
            double scale = grow / lineLength;
            double yb = scale * w;
            double xa = scale * h;
            double growx = yb * yb / xa + xa;
            double growy = xa * xa / yb + yb;
            Geom.grow(r, growx, growy);
        }
        Path2D.Double diamond = new Path2D.Double();
        diamond.moveTo(r.x + r.width / 2.0, r.y);
        diamond.lineTo(r.x + r.width, r.y + r.height / 2.0);
        diamond.lineTo(r.x + r.width / 2.0, r.y + r.height);
        diamond.lineTo(r.x, r.y + r.height / 2.0);
        diamond.closePath();
        return diamond.contains(p);
    }

    @Override
    public void setBounds(Point2D.Double anchor, Point2D.Double lead) {
        this.rectangle.x = Math.min(anchor.x, lead.x);
        this.rectangle.y = Math.min(anchor.y, lead.y);
        this.rectangle.width = Math.max(0.1, Math.abs(lead.x - anchor.x));
        this.rectangle.height = Math.max(0.1, Math.abs(lead.y - anchor.y));
    }

    @Override
    public void transform(AffineTransform tx) {
        Point2D.Double anchor = this.getStartPoint();
        Point2D.Double lead = this.getEndPoint();
        this.setBounds((Point2D.Double)tx.transform(anchor, anchor), (Point2D.Double)tx.transform(lead, lead));
    }

    @Override
    public void restoreTransformTo(Object geometry) {
        Rectangle2D.Double r = (Rectangle2D.Double)geometry;
        this.rectangle.x = r.x;
        this.rectangle.y = r.y;
        this.rectangle.width = r.width;
        this.rectangle.height = r.height;
    }

    @Override
    public Object getTransformRestoreData() {
        return this.rectangle.clone();
    }

    @Override
    public Connector findConnector(Point2D.Double p, ConnectionFigure prototype) {
        return new ChopDiamondConnector(this);
    }

    @Override
    public Connector findCompatibleConnector(Connector c, boolean isStart) {
        return new ChopDiamondConnector(this);
    }

    @Override
    public DiamondFigure clone() {
        DiamondFigure that = (DiamondFigure)super.clone();
        that.rectangle = (Rectangle2D.Double)this.rectangle.clone();
        return that;
    }
}

