/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.color;

import java.awt.Color;
import java.awt.color.ColorSpace;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import javax.swing.AbstractListModel;
import org.jhotdraw.color.ColorSliderModel;
import org.jhotdraw.color.ColorUtil;
import org.jhotdraw.color.DefaultColorSliderModel;
import org.jhotdraw.color.HSLPhysiologicColorSpace;
import org.jhotdraw.color.HarmonicColorModel;
import org.jhotdraw.color.HarmonicRule;

public class DefaultHarmonicColorModel
extends AbstractListModel
implements HarmonicColorModel,
Cloneable {
    protected PropertyChangeSupport propertySupport = new PropertyChangeSupport(this);
    private ArrayList<Color> colors;
    private ColorSliderModel sliderModel;
    private int base;
    private ArrayList<HarmonicRule> rules;
    private float customHueConstraint = 0.083333336f;
    private int adjusting;

    public DefaultHarmonicColorModel() {
        HSLPhysiologicColorSpace sys = HSLPhysiologicColorSpace.getInstance();
        this.sliderModel = new DefaultColorSliderModel(sys);
        this.colors = new ArrayList();
        this.rules = new ArrayList();
        this.base = 0;
        this.add(Color.RED);
    }

    @Override
    public void setSize(int newValue) {
        int oldSize = this.size();
        while (this.colors.size() > newValue) {
            this.colors.remove(this.colors.size() - 1);
        }
        while (this.colors.size() < newValue) {
            this.colors.add(null);
        }
        if (oldSize < newValue) {
            this.fireIntervalRemoved(this, oldSize, newValue - 1);
        } else if (oldSize > newValue) {
            this.fireIntervalRemoved(this, newValue, oldSize - 1);
        }
    }

    @Override
    public int size() {
        return this.colors.size();
    }

    @Override
    public boolean isAdjusting() {
        return this.adjusting > 0;
    }

    @Override
    public void set(int index, Color newValue) {
        ++this.adjusting;
        Color oldValue = this.colors.set(index, newValue);
        for (HarmonicRule r : this.rules) {
            r.colorChanged(this, index, oldValue, newValue);
        }
        for (HarmonicRule r : this.rules) {
            if (r.getBaseIndex() != index) continue;
            r.apply(this);
        }
        --this.adjusting;
        this.fireContentsChanged(this, index, index);
    }

    @Override
    public void applyRules() {
        for (HarmonicRule r : this.rules) {
            if (r.getBaseIndex() != this.base) continue;
            r.apply(this);
        }
    }

    @Override
    public Color get(int index) {
        return this.colors.get(index);
    }

    @Override
    public boolean add(Color c) {
        boolean b = this.colors.add(c);
        if (b) {
            this.fireIntervalAdded(this, this.size() - 1, this.size() - 1);
        }
        return b;
    }

    @Override
    public void setBase(int newValue) {
        this.base = newValue;
    }

    @Override
    public int getBase() {
        return this.base;
    }

    @Override
    public float[] RGBtoComponent(int rgb, float[] hsb) {
        return ColorUtil.fromColor(this.sliderModel.getColorSpace(), new Color(rgb));
    }

    @Override
    public int componentToRGB(float h, float s, float b) {
        return ColorUtil.toRGB(this.sliderModel.getColorSpace(), h, s, b);
    }

    @Override
    public int getSize() {
        return this.size();
    }

    public Object getElementAt(int index) {
        return this.get(index);
    }

    @Override
    public ColorSpace getColorSpace() {
        return this.sliderModel.getColorSpace();
    }

    @Override
    public void addRule(HarmonicRule newValue) {
        this.rules.add(newValue);
    }

    @Override
    public void removeAllRules() {
        this.rules.clear();
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertySupport.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertySupport.addPropertyChangeListener(propertyName, listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertySupport.removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertySupport.removePropertyChangeListener(propertyName, listener);
    }

    protected void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
        this.propertySupport.firePropertyChange(propertyName, oldValue, newValue);
    }

    protected void firePropertyChange(String propertyName, int oldValue, int newValue) {
        this.propertySupport.firePropertyChange(propertyName, oldValue, newValue);
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        this.propertySupport.firePropertyChange(propertyName, oldValue, newValue);
    }

    public DefaultHarmonicColorModel clone() {
        DefaultHarmonicColorModel that;
        try {
            that = (DefaultHarmonicColorModel)super.clone();
        }
        catch (CloneNotSupportedException ex) {
            InternalError error = new InternalError("Clone failed");
            error.initCause(ex);
            throw error;
        }
        that.propertySupport = new PropertyChangeSupport(that);
        return that;
    }

    @Override
    public void setColorSpace(ColorSpace newValue) {
        ColorSpace oldValue = this.sliderModel.getColorSpace();
        this.sliderModel.setColorSpace(newValue);
        this.firePropertyChange("colorSpace", oldValue, newValue);
        for (int i = 0; i < this.colors.size(); ++i) {
            if (this.get(i) == null) continue;
            this.set(i, new Color(newValue, ColorUtil.fromColor(newValue, this.get(i)), 1.0f));
        }
        this.fireContentsChanged(this, 0, this.size() - 1);
    }
}

