/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.color;

import edu.umd.cs.findbugs.annotations.Nullable;
import java.awt.Color;
import java.awt.color.ColorSpace;
import org.jhotdraw.color.ColorUtil;

public class CompositeColor
extends Color {
    @Nullable
    private float[] fvalue = null;
    private float falpha = 0.0f;
    @Nullable
    private ColorSpace cs = null;

    public CompositeColor(ColorSpace cspace, float[] components, float alpha) {
        super((int)(alpha * 255.0f) << 24 | ColorUtil.toRGB(cspace, components), true);
        boolean rangeError = false;
        StringBuilder badComponentString = new StringBuilder();
        int n = cspace.getNumComponents();
        this.fvalue = new float[n];
        for (int i = 0; i < n; ++i) {
            if (components[i] < cspace.getMinValue(i) || components[i] > cspace.getMaxValue(i)) {
                rangeError = true;
                badComponentString.append("Component ");
                badComponentString.append(i);
                badComponentString.append(' ');
                continue;
            }
            this.fvalue[i] = components[i];
        }
        if ((double)alpha < 0.0 || (double)alpha > 1.0) {
            rangeError = true;
            badComponentString.append("Alpha");
        } else {
            this.falpha = alpha;
        }
        if (rangeError) {
            throw new IllegalArgumentException("Color parameter outside of expected range: " + badComponentString);
        }
        this.cs = cspace;
    }

    @Override
    public float[] getComponents(float[] compArray) {
        if (this.fvalue == null) {
            return this.getRGBComponents(compArray);
        }
        int n = this.fvalue.length;
        float[] f = compArray == null ? new float[n + 1] : compArray;
        for (int i = 0; i < n; ++i) {
            f[i] = this.fvalue[i];
        }
        f[n] = this.falpha;
        return f;
    }

    @Override
    public float[] getColorComponents(float[] compArray) {
        if (this.fvalue == null) {
            return this.getRGBColorComponents(compArray);
        }
        int n = this.fvalue.length;
        float[] f = compArray == null ? new float[n] : compArray;
        for (int i = 0; i < n; ++i) {
            f[i] = this.fvalue[i];
        }
        return f;
    }

    @Override
    public float[] getComponents(ColorSpace cspace, float[] compArray) {
        if (this.cs == null) {
            this.cs = ColorSpace.getInstance(1000);
        }
        float[] f = this.fvalue == null ? new float[]{(float)this.getRed() / 255.0f, (float)this.getGreen() / 255.0f, (float)this.getBlue() / 255.0f} : this.fvalue;
        float[] tmp = this.cs.toCIEXYZ(f);
        float[] tmpout = cspace.fromCIEXYZ(tmp);
        if (compArray == null) {
            compArray = new float[tmpout.length + 1];
        }
        for (int i = 0; i < tmpout.length; ++i) {
            compArray[i] = tmpout[i];
        }
        compArray[tmpout.length] = this.fvalue == null ? (float)this.getAlpha() / 255.0f : this.falpha;
        return compArray;
    }

    @Override
    public float[] getColorComponents(ColorSpace cspace, float[] compArray) {
        if (this.cs == null) {
            this.cs = ColorSpace.getInstance(1000);
        }
        float[] f = this.fvalue == null ? new float[]{(float)this.getRed() / 255.0f, (float)this.getGreen() / 255.0f, (float)this.getBlue() / 255.0f} : this.fvalue;
        float[] tmp = this.cs.toCIEXYZ(f);
        float[] tmpout = cspace.fromCIEXYZ(tmp);
        if (compArray == null) {
            return tmpout;
        }
        for (int i = 0; i < tmpout.length; ++i) {
            compArray[i] = tmpout[i];
        }
        return compArray;
    }

    @Override
    public ColorSpace getColorSpace() {
        if (this.cs == null) {
            this.cs = ColorSpace.getInstance(1000);
        }
        return this.cs;
    }
}

