/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.app;

import edu.umd.cs.findbugs.annotations.Nullable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URI;
import java.util.LinkedList;
import java.util.prefs.Preferences;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.jhotdraw.app.AbstractApplication;
import org.jhotdraw.app.ApplicationModel;
import org.jhotdraw.app.MenuBuilder;
import org.jhotdraw.app.View;
import org.jhotdraw.app.action.ActionUtil;
import org.jhotdraw.app.action.app.AboutAction;
import org.jhotdraw.app.action.file.ClearRecentFilesMenuAction;
import org.jhotdraw.app.action.file.CloseFileAction;
import org.jhotdraw.app.action.window.ToggleVisibleAction;
import org.jhotdraw.net.URIUtil;
import org.jhotdraw.util.ReversedList;
import org.jhotdraw.util.prefs.PreferencesUtil;

public class SDIApplication
extends AbstractApplication {
    private Preferences prefs;

    @Override
    public void launch(String[] args) {
        System.setProperty("apple.awt.graphics.UseQuartz", "false");
        super.launch(args);
    }

    @Override
    public void init() {
        super.init();
        this.initLookAndFeel();
        this.prefs = PreferencesUtil.userNodeForPackage(this.getModel() == null ? this.getClass() : this.getModel().getClass());
        this.initLabels();
        this.setActionMap(this.createModelActionMap(this.model));
        this.model.initApplication(this);
    }

    @Override
    public void remove(View p) {
        super.remove(p);
        if (this.views().size() == 0) {
            this.stop();
        }
    }

    @Override
    public void configure(String[] args) {
        System.setProperty("apple.laf.useScreenMenuBar", "false");
        System.setProperty("com.apple.macos.useScreenMenuBar", "false");
        System.setProperty("apple.awt.graphics.UseQuartz", "false");
        System.setProperty("swing.aatext", "true");
    }

    protected void initLookAndFeel() {
        try {
            String lafName = UIManager.getSystemLookAndFeelClassName();
            UIManager.setLookAndFeel(lafName);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (UIManager.getString("OptionPane.css") == null) {
            UIManager.put("OptionPane.css", "<head><style type=\"text/css\">b { font: 13pt \"Dialog\" }p { font: 11pt \"Dialog\"; margin-top: 8px }</style></head>");
        }
    }

    @Override
    public void show(final View view) {
        if (!view.isShowing()) {
            boolean moved;
            view.setShowing(true);
            final JFrame f = new JFrame();
            f.setDefaultCloseOperation(0);
            this.updateViewTitle(view, f);
            JPanel panel = (JPanel)this.wrapViewComponent(view);
            f.add(panel);
            f.setSize(new Dimension(600, 400));
            f.setJMenuBar(this.createMenuBar(view));
            PreferencesUtil.installFramePrefsHandler(this.prefs, "view", f);
            Point loc = f.getLocation();
            block0: do {
                moved = false;
                for (View aView : this.views()) {
                    if (aView == view || SwingUtilities.getWindowAncestor(aView.getComponent()) == null || !SwingUtilities.getWindowAncestor(aView.getComponent()).getLocation().equals(loc)) continue;
                    loc.x += 22;
                    loc.y += 22;
                    moved = true;
                    continue block0;
                }
            } while (moved);
            f.setLocation(loc);
            f.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent evt) {
                    SDIApplication.this.getAction(view, "file.close").actionPerformed(new ActionEvent(f, 1001, "windowClosing"));
                }

                @Override
                public void windowClosed(WindowEvent evt) {
                    view.stop();
                }

                @Override
                public void windowGainedFocus(WindowEvent e) {
                    SDIApplication.this.setActiveView(view);
                }
            });
            view.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    String name = evt.getPropertyName();
                    if (name.equals("hasUnsavedChanges") || name.equals("uri") || name.equals("title") || name.equals("multipleOpenId")) {
                        SDIApplication.this.updateViewTitle(view, f);
                    }
                }
            });
            f.setVisible(true);
            view.start();
        }
    }

    protected Component wrapViewComponent(View p) {
        JComponent c = p.getComponent();
        if (this.getModel() != null) {
            LinkedList<ToggleVisibleAction> toolBarActions = new LinkedList<ToggleVisibleAction>();
            int id = 0;
            for (JToolBar tb : new ReversedList<JToolBar>(this.getModel().createToolBars(this, p))) {
                JPanel panel = new JPanel(new BorderLayout());
                panel.add((Component)tb, "North");
                panel.add((Component)c, "Center");
                c = panel;
                PreferencesUtil.installToolBarPrefsHandler(this.prefs, "toolbar." + ++id, tb);
                toolBarActions.addFirst(new ToggleVisibleAction(tb, tb.getName()));
            }
            p.getComponent().putClientProperty("toolBarActions", toolBarActions);
        }
        return c;
    }

    @Override
    public void hide(View p) {
        if (p.isShowing()) {
            if (this.getActiveView() == p) {
                this.setActiveView(null);
            }
            p.setShowing(false);
            JFrame f = (JFrame)SwingUtilities.getWindowAncestor(p.getComponent());
            f.setVisible(false);
            f.remove(p.getComponent());
            f.dispose();
        }
    }

    @Override
    public void dispose(View p) {
        super.dispose(p);
        if (this.views().size() == 0) {
            this.stop();
        }
    }

    protected JMenuBar createMenuBar(View v) {
        JMenuBar mb = new JMenuBar();
        JMenu fileMenu = null;
        JMenu editMenu = null;
        JMenu helpMenu = null;
        JMenu viewMenu = null;
        JMenu windowMenu = null;
        String fileMenuText = this.labels.getString("file.text");
        String editMenuText = this.labels.getString("edit.text");
        String viewMenuText = this.labels.getString("view.text");
        String windowMenuText = this.labels.getString("window.text");
        String helpMenuText = this.labels.getString("help.text");
        LinkedList<JMenu> ll = new LinkedList<JMenu>();
        this.getModel().getMenuBuilder().addOtherMenus(ll, this, v);
        for (JMenu mm : ll) {
            String text = mm.getText();
            if (text != null) {
                if (text.equals(fileMenuText)) {
                    fileMenu = mm;
                    continue;
                }
                if (text.equals(editMenuText)) {
                    editMenu = mm;
                    continue;
                }
                if (text.equals(viewMenuText)) {
                    viewMenu = mm;
                    continue;
                }
                if (text.equals(windowMenuText)) {
                    windowMenu = mm;
                    continue;
                }
                if (text.equals(helpMenuText)) {
                    helpMenu = mm;
                    continue;
                }
            }
            mb.add(mm);
        }
        if (fileMenu == null) {
            fileMenu = this.createFileMenu(v);
        }
        if (editMenu == null) {
            editMenu = this.createEditMenu(v);
        }
        if (viewMenu == null) {
            viewMenu = this.createViewMenu(v);
        }
        if (windowMenu == null) {
            windowMenu = this.createWindowMenu(v);
        }
        if (helpMenu == null) {
            helpMenu = this.createHelpMenu(v);
        }
        if (fileMenu != null) {
            mb.add((Component)fileMenu, 0);
        }
        if (editMenu != null) {
            mb.add((Component)editMenu, Math.min(1, mb.getComponentCount()));
        }
        if (viewMenu != null) {
            mb.add((Component)viewMenu, Math.min(2, mb.getComponentCount()));
        }
        if (windowMenu != null) {
            mb.add(windowMenu);
        }
        if (helpMenu != null) {
            mb.add(helpMenu);
        }
        return mb;
    }

    @Override
    @Nullable
    public JMenu createFileMenu(View view) {
        JMenu m = new JMenu();
        this.labels.configureMenu(m, "file");
        MenuBuilder mb = this.model.getMenuBuilder();
        mb.addClearFileItems(m, this, view);
        mb.addNewFileItems(m, this, view);
        mb.addNewWindowItems(m, this, view);
        mb.addLoadFileItems(m, this, view);
        mb.addOpenFileItems(m, this, view);
        if (this.getAction(view, "file.load") != null || this.getAction(view, "file.open") != null || this.getAction(view, "file.loadDirectory") != null || this.getAction(view, "file.openDirectory") != null) {
            m.add(this.createOpenRecentFileMenu(view));
        }
        this.maybeAddSeparator(m);
        mb.addSaveFileItems(m, this, view);
        mb.addExportFileItems(m, this, view);
        mb.addPrintFileItems(m, this, view);
        mb.addOtherFileItems(m, this, view);
        this.maybeAddSeparator(m);
        mb.addCloseFileItems(m, this, view);
        return m.getItemCount() == 0 ? null : m;
    }

    @Override
    @Nullable
    public JMenu createEditMenu(View view) {
        JMenu m = new JMenu();
        this.labels.configureMenu(m, "edit");
        MenuBuilder mb = this.model.getMenuBuilder();
        mb.addUndoItems(m, this, view);
        this.maybeAddSeparator(m);
        mb.addClipboardItems(m, this, view);
        this.maybeAddSeparator(m);
        mb.addSelectionItems(m, this, view);
        this.maybeAddSeparator(m);
        mb.addFindItems(m, this, view);
        this.maybeAddSeparator(m);
        mb.addOtherEditItems(m, this, view);
        this.maybeAddSeparator(m);
        mb.addPreferencesItems(m, this, view);
        return m.getItemCount() == 0 ? null : m;
    }

    protected void updateViewTitle(View view, JFrame f) {
        URI uri = view.getURI();
        String title = uri == null ? this.labels.getString("unnamedFile") : URIUtil.getName(uri);
        if (view.hasUnsavedChanges()) {
            title = title + "*";
        }
        view.setTitle(this.labels.getFormatted("frame.title", title, this.getName(), view.getMultipleOpenId()));
        f.setTitle(view.getTitle());
    }

    @Override
    public boolean isSharingToolsAmongViews() {
        return false;
    }

    @Override
    public Component getComponent() {
        View p = this.getActiveView();
        return p == null ? null : p.getComponent();
    }

    @Override
    @Nullable
    public JMenu createWindowMenu(View view) {
        JMenu m = new JMenu();
        this.labels.configureMenu(m, "window");
        MenuBuilder mb = this.model.getMenuBuilder();
        mb.addOtherWindowItems(m, this, view);
        return m.getItemCount() > 0 ? m : null;
    }

    @Override
    public JMenu createViewMenu(View view) {
        Object object = view.getComponent().getClientProperty("toolBarActions");
        LinkedList viewActions = (LinkedList)object;
        JMenu m = new JMenu();
        this.labels.configureMenu(m, "view");
        if (viewActions != null && viewActions.size() > 0) {
            JMenu m2 = viewActions.size() == 1 ? m : new JMenu(this.labels.getString("toolBars"));
            for (Action a : viewActions) {
                JCheckBoxMenuItem cbmi = new JCheckBoxMenuItem(a);
                ActionUtil.configureJCheckBoxMenuItem(cbmi, a);
                m2.add(cbmi);
            }
            if (m2 != m) {
                m.add(m2);
            }
        }
        MenuBuilder mb = this.model.getMenuBuilder();
        mb.addOtherViewItems(m, this, view);
        return m.getItemCount() > 0 ? m : null;
    }

    @Override
    public JMenu createHelpMenu(View p) {
        JMenu m = new JMenu();
        this.labels.configureMenu(m, "help");
        m.add(this.getAction(p, "application.about"));
        return m;
    }

    protected ActionMap createModelActionMap(ApplicationModel mo) {
        ActionMap rootMap = new ActionMap();
        rootMap.put("application.about", new AboutAction(this));
        rootMap.put("file.clearRecentFiles", new ClearRecentFilesMenuAction(this));
        ActionMap moMap = mo.createActionMap(this, null);
        moMap.setParent(rootMap);
        return moMap;
    }

    @Override
    protected ActionMap createViewActionMap(View v) {
        ActionMap intermediateMap = new ActionMap();
        intermediateMap.put("file.close", new CloseFileAction(this, v));
        ActionMap vMap = this.model.createActionMap(this, v);
        vMap.setParent(intermediateMap);
        intermediateMap.setParent(this.getActionMap(null));
        return vMap;
    }
}

