/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.app;

import edu.umd.cs.findbugs.annotations.Nullable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.net.URI;
import java.util.LinkedList;
import java.util.Stack;
import java.util.prefs.Preferences;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.jhotdraw.app.AbstractApplication;
import org.jhotdraw.app.ApplicationModel;
import org.jhotdraw.app.Disposable;
import org.jhotdraw.app.MenuBuilder;
import org.jhotdraw.app.View;
import org.jhotdraw.app.action.ActionUtil;
import org.jhotdraw.app.action.app.AboutAction;
import org.jhotdraw.app.action.app.ExitAction;
import org.jhotdraw.app.action.app.OpenApplicationAction;
import org.jhotdraw.app.action.app.OpenApplicationFileAction;
import org.jhotdraw.app.action.app.ReOpenApplicationAction;
import org.jhotdraw.app.action.file.ClearRecentFilesMenuAction;
import org.jhotdraw.app.action.window.FocusWindowAction;
import org.jhotdraw.app.action.window.MaximizeWindowAction;
import org.jhotdraw.app.action.window.MinimizeWindowAction;
import org.jhotdraw.app.action.window.TogglePaletteAction;
import org.jhotdraw.app.osx.OSXAdapter;
import org.jhotdraw.app.osx.OSXPaletteHandler;
import org.jhotdraw.gui.Worker;
import org.jhotdraw.net.URIUtil;
import org.jhotdraw.util.ResourceBundleUtil;
import org.jhotdraw.util.prefs.PreferencesUtil;

public class OSXApplication
extends AbstractApplication {
    private OSXPaletteHandler paletteHandler;
    private Preferences prefs;
    private LinkedList<Action> paletteActions;
    private JFrame invisibleFrame;

    @Override
    public void init() {
        super.init();
        ResourceBundleUtil.putPropertyNameModifier("os", "mac", "default");
        this.prefs = PreferencesUtil.userNodeForPackage(this.getModel() == null ? this.getClass() : this.getModel().getClass());
        this.initLookAndFeel();
        this.paletteHandler = new OSXPaletteHandler(this);
        this.initLabels();
        this.paletteActions = new LinkedList();
        this.setActionMap(this.createModelActionMap(this.model));
        this.initPalettes(this.paletteActions);
        this.initScreenMenuBar();
        this.model.initApplication(this);
    }

    @Override
    public void launch(String[] args) {
        System.setProperty("apple.awt.graphics.UseQuartz", "false");
        super.launch(args);
    }

    @Override
    public void configure(String[] args) {
        System.setProperty("apple.laf.useScreenMenuBar", "true");
        System.setProperty("com.apple.macos.useScreenMenuBar", "true");
    }

    protected void initLookAndFeel() {
        try {
            UIManager.setLookAndFeel("ch.randelshofer.quaqua.QuaquaLookAndFeel");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (UIManager.getString("OptionPane.css") == null) {
            UIManager.put("OptionPane.css", "<head><style type=\"text/css\">b { font: 13pt \"Dialog\" }p { font: 11pt \"Dialog\"; margin-top: 8px }</style></head>");
        }
    }

    @Override
    public void dispose(View p) {
        FocusWindowAction a = (FocusWindowAction)this.getAction(p, "window.focus");
        if (a != null) {
            a.dispose();
        }
        super.dispose(p);
    }

    @Override
    public void addPalette(Window palette) {
        this.paletteHandler.addPalette(palette);
    }

    @Override
    public void removePalette(Window palette) {
        this.paletteHandler.removePalette(palette);
    }

    @Override
    public void addWindow(Window window, View view) {
        if (window instanceof JFrame) {
            ((JFrame)window).setJMenuBar(this.createMenuBar(view));
        } else if (window instanceof JDialog) {
            // empty if block
        }
        this.paletteHandler.add(window, view);
    }

    @Override
    public void removeWindow(Window window) {
        if (window instanceof JFrame) {
            JMenuBar mb = ((JFrame)window).getJMenuBar();
            Stack<JMenu> s = new Stack<JMenu>();
            int n = mb.getMenuCount();
            for (int i = 0; i < n; ++i) {
                if (mb.getMenu(i) == null) continue;
                s.push(mb.getMenu(i));
            }
            while (!s.isEmpty()) {
                JPopupMenu m = ((JMenu)s.pop()).getPopupMenu();
                int n2 = m.getComponentCount();
                for (int i = 0; i < n2; ++i) {
                    if (m.getComponent(i) instanceof JMenu) {
                        s.push((JMenu)m.getComponent(i));
                        continue;
                    }
                    if (!(m.getComponent(i) instanceof AbstractButton)) continue;
                    ((AbstractButton)m.getComponent(i)).setAction(null);
                }
            }
            ((JFrame)window).setJMenuBar(null);
        }
        this.paletteHandler.remove(window);
    }

    @Override
    public void show(View view) {
        if (!view.isShowing()) {
            boolean moved;
            view.setShowing(true);
            JFrame f = new JFrame();
            f.setDefaultCloseOperation(0);
            f.setSize(new Dimension(600, 400));
            this.updateViewTitle(view, f);
            PreferencesUtil.installFramePrefsHandler(this.prefs, "view", f);
            Point loc = f.getLocation();
            block0: do {
                moved = false;
                for (View aView : this.views()) {
                    if (aView == view || !aView.isShowing() || !SwingUtilities.getWindowAncestor(aView.getComponent()).getLocation().equals(loc)) continue;
                    loc.x += 22;
                    loc.y += 22;
                    moved = true;
                    continue block0;
                }
            } while (moved);
            f.setLocation(loc);
            new FrameHandler(f, view);
            this.addWindow(f, view);
            f.getContentPane().add(view.getComponent());
            f.setVisible(true);
            view.start();
        }
    }

    protected void updateViewTitle(View v, JFrame f) {
        URI uri = v.getURI();
        String title = uri == null ? this.labels.getString("unnamedFile") : URIUtil.getName(uri);
        v.setTitle(this.labels.getFormatted("frame.title", title, this.getName(), v.getMultipleOpenId()));
        f.setTitle(v.getTitle());
        if (uri != null && uri.getScheme() != null && uri.getScheme().equals("file")) {
            f.getRootPane().putClientProperty("Window.documentFile", new File(uri));
        } else {
            f.getRootPane().putClientProperty("Window.documentFile", null);
        }
    }

    @Override
    public void hide(View p) {
        if (p.isShowing()) {
            JFrame f = (JFrame)SwingUtilities.getWindowAncestor(p.getComponent());
            if (this.getActiveView() == p) {
                this.setActiveView(null);
            }
            f.setVisible(false);
            this.removeWindow(f);
            f.remove(p.getComponent());
            f.dispose();
        }
    }

    protected JMenuBar createMenuBar(@Nullable View v) {
        JMenuBar mb = new JMenuBar();
        JMenu fileMenu = null;
        JMenu editMenu = null;
        JMenu helpMenu = null;
        JMenu viewMenu = null;
        JMenu windowMenu = null;
        String fileMenuText = this.labels.getString("file.text");
        String editMenuText = this.labels.getString("edit.text");
        String viewMenuText = this.labels.getString("view.text");
        String windowMenuText = this.labels.getString("window.text");
        String helpMenuText = this.labels.getString("help.text");
        LinkedList<JMenu> ll = new LinkedList<JMenu>();
        this.getModel().getMenuBuilder().addOtherMenus(ll, this, v);
        for (JMenu mm : ll) {
            String text = mm.getText();
            if (text == null) {
                mm.setText("-null-");
            } else {
                if (text.equals(fileMenuText)) {
                    fileMenu = mm;
                    continue;
                }
                if (text.equals(editMenuText)) {
                    editMenu = mm;
                    continue;
                }
                if (text.equals(viewMenuText)) {
                    viewMenu = mm;
                    continue;
                }
                if (text.equals(windowMenuText)) {
                    windowMenu = mm;
                    continue;
                }
                if (text.equals(helpMenuText)) {
                    helpMenu = mm;
                    continue;
                }
            }
            mb.add(mm);
        }
        if (fileMenu == null) {
            fileMenu = this.createFileMenu(v);
        }
        if (editMenu == null) {
            editMenu = this.createEditMenu(v);
        }
        if (viewMenu == null) {
            viewMenu = this.createViewMenu(v);
        }
        if (windowMenu == null) {
            windowMenu = this.createWindowMenu(v);
        }
        if (helpMenu == null) {
            helpMenu = this.createHelpMenu(v);
        }
        if (fileMenu != null) {
            mb.add((Component)fileMenu, 0);
        }
        if (editMenu != null) {
            mb.add((Component)editMenu, Math.min(1, mb.getComponentCount()));
        }
        if (viewMenu != null) {
            mb.add((Component)viewMenu, Math.min(2, mb.getComponentCount()));
        }
        if (windowMenu != null) {
            mb.add(windowMenu);
        }
        if (helpMenu != null) {
            mb.add(helpMenu);
        }
        return mb;
    }

    @Override
    @Nullable
    public JMenu createViewMenu(View view) {
        JMenu m = new JMenu();
        this.labels.configureMenu(m, "view");
        MenuBuilder mb = this.model.getMenuBuilder();
        mb.addOtherViewItems(m, this, view);
        return m.getItemCount() > 0 ? m : null;
    }

    @Override
    public JMenu createWindowMenu(View view) {
        JMenu m;
        JMenu windowMenu = m = new JMenu();
        this.labels.configureMenu(m, "window");
        m.addSeparator();
        MenuBuilder mb = this.model.getMenuBuilder();
        mb.addOtherWindowItems(m, this, view);
        new WindowMenuHandler(windowMenu, view);
        return m.getItemCount() == 0 ? null : m;
    }

    @Override
    @Nullable
    public JMenu createFileMenu(View view) {
        JMenu m = new JMenu();
        this.labels.configureMenu(m, "file");
        MenuBuilder mb = this.model.getMenuBuilder();
        mb.addClearFileItems(m, this, view);
        mb.addNewFileItems(m, this, view);
        mb.addNewWindowItems(m, this, view);
        mb.addLoadFileItems(m, this, view);
        mb.addOpenFileItems(m, this, view);
        if (this.getAction(view, "file.load") != null || this.getAction(view, "file.open") != null || this.getAction(view, "file.loadDirectory") != null || this.getAction(view, "file.openDirectory") != null) {
            m.add(this.createOpenRecentFileMenu(view));
        }
        this.maybeAddSeparator(m);
        mb.addCloseFileItems(m, this, view);
        mb.addSaveFileItems(m, this, view);
        mb.addExportFileItems(m, this, view);
        mb.addPrintFileItems(m, this, view);
        mb.addOtherFileItems(m, this, view);
        return m.getItemCount() == 0 ? null : m;
    }

    @Override
    @Nullable
    public JMenu createEditMenu(View view) {
        JMenu m = new JMenu();
        this.labels.configureMenu(m, "edit");
        MenuBuilder mb = this.model.getMenuBuilder();
        mb.addUndoItems(m, this, view);
        this.maybeAddSeparator(m);
        mb.addClipboardItems(m, this, view);
        this.maybeAddSeparator(m);
        mb.addSelectionItems(m, this, view);
        this.maybeAddSeparator(m);
        mb.addFindItems(m, this, view);
        this.maybeAddSeparator(m);
        mb.addOtherEditItems(m, this, view);
        return m.getItemCount() == 0 ? null : m;
    }

    @Override
    public JMenu createHelpMenu(View view) {
        JMenu m = new JMenu();
        this.labels.configureMenu(m, "help");
        MenuBuilder mb = this.model.getMenuBuilder();
        mb.addHelpItems(m, this, view);
        return m.getItemCount() == 0 ? null : m;
    }

    protected void initScreenMenuBar() {
        this.setScreenMenuBar(this.createMenuBar(null));
        this.paletteHandler.add((JFrame)this.getComponent(), null);
        Action a = this.getAction(null, "application.openApplication");
        if (null != a) {
            OSXAdapter.setOpenApplicationHandler(a);
        }
        if (null != (a = this.getAction(null, "application.reOpen"))) {
            OSXAdapter.setReOpenApplicationHandler(a);
        }
        if (null != (a = this.getAction(null, "application.openFile"))) {
            OSXAdapter.setOpenFileHandler(a);
        }
        if (null != (a = this.getAction(null, "application.printFile"))) {
            OSXAdapter.setPrintFileHandler(a);
        }
        if (null != (a = this.getAction(null, "application.about"))) {
            OSXAdapter.setAboutHandler(a);
        }
        if (null != (a = this.getAction(null, "application.preferences"))) {
            OSXAdapter.setPreferencesHandler(a);
        }
        if (null != (a = this.getAction(null, "application.exit"))) {
            OSXAdapter.setQuitHandler(a);
        }
    }

    protected void initPalettes(final LinkedList<Action> paletteActions) {
        SwingUtilities.invokeLater(new Worker<LinkedList<JFrame>>(){

            @Override
            public LinkedList<JFrame> construct() {
                LinkedList<JFrame> palettes = new LinkedList<JFrame>();
                LinkedList<JToolBar> toolBars = new LinkedList<JToolBar>(OSXApplication.this.getModel().createToolBars(OSXApplication.this, null));
                int i = 0;
                int x = 0;
                for (JToolBar tb : toolBars) {
                    ++i;
                    tb.setFloatable(false);
                    tb.setOrientation(1);
                    tb.setFocusable(false);
                    JFrame d = new JFrame();
                    d.getRootPane().putClientProperty("Window.style", "small");
                    d.getRootPane().putClientProperty("Quaqua.RootPane.isVertical", Boolean.FALSE);
                    d.getRootPane().putClientProperty("Quaqua.RootPane.isPalette", Boolean.TRUE);
                    d.setFocusable(false);
                    d.setResizable(false);
                    d.getContentPane().setLayout(new BorderLayout());
                    d.getContentPane().add((Component)tb, "Center");
                    d.setAlwaysOnTop(true);
                    d.setUndecorated(true);
                    d.getRootPane().setWindowDecorationStyle(1);
                    d.getRootPane().setFont(new Font("Lucida Grande", 0, 11));
                    d.setJMenuBar(OSXApplication.this.createMenuBar(null));
                    d.pack();
                    d.setFocusableWindowState(false);
                    PreferencesUtil.installPalettePrefsHandler(OSXApplication.this.prefs, "toolbar." + i, d, x);
                    x += d.getWidth();
                    TogglePaletteAction tpa = new TogglePaletteAction(OSXApplication.this, d, tb.getName());
                    palettes.add(d);
                    if (OSXApplication.this.prefs.getBoolean("toolbar." + i + ".visible", true)) {
                        OSXApplication.this.addPalette(d);
                        tpa.putValue("SwingSelectedKey", true);
                    }
                    paletteActions.add(tpa);
                }
                return palettes;
            }

            @Override
            protected void done(LinkedList<JFrame> result) {
                LinkedList<JFrame> palettes = result;
                if (palettes != null) {
                    OSXApplication.this.firePropertyChange("paletteCount", 0, palettes.size());
                }
            }
        });
    }

    @Override
    public boolean isSharingToolsAmongViews() {
        return true;
    }

    @Override
    public Component getComponent() {
        if (this.invisibleFrame == null) {
            this.invisibleFrame = new JFrame();
            this.invisibleFrame.setDefaultCloseOperation(0);
            this.invisibleFrame.setUndecorated(true);
            this.invisibleFrame.setLocation(10000, 10000);
            this.invisibleFrame.getRootPane().putClientProperty("Window.alpha", Float.valueOf(0.0f));
            this.invisibleFrame.getRootPane().putClientProperty("Window.shadow", false);
            this.invisibleFrame.setVisible(true);
        }
        return this.invisibleFrame;
    }

    protected void setScreenMenuBar(JMenuBar mb) {
        ((JFrame)this.getComponent()).setJMenuBar(mb);
        this.invisibleFrame.pack();
    }

    protected ActionMap createModelActionMap(ApplicationModel mo) {
        ActionMap rootMap = new ActionMap();
        rootMap.put("application.about", new AboutAction(this));
        rootMap.put("application.exit", new ExitAction(this));
        rootMap.put("application.openApplication", new OpenApplicationAction(this));
        rootMap.put("application.openFile", new OpenApplicationFileAction(this));
        rootMap.put("application.reOpen", new ReOpenApplicationAction(this));
        rootMap.put("file.clearRecentFiles", new ClearRecentFilesMenuAction(this));
        rootMap.put("window.maximize", new MaximizeWindowAction(this, null));
        rootMap.put("window.minimize", new MinimizeWindowAction(this, null));
        ActionMap moMap = mo.createActionMap(this, null);
        moMap.setParent(rootMap);
        return moMap;
    }

    @Override
    protected ActionMap createViewActionMap(View v) {
        ActionMap intermediateMap = new ActionMap();
        intermediateMap.put("window.focus", new FocusWindowAction(v));
        intermediateMap.put("window.maximize", new MaximizeWindowAction(this, v));
        intermediateMap.put("window.minimize", new MinimizeWindowAction(this, v));
        ActionMap vMap = this.model.createActionMap(this, v);
        vMap.setParent(intermediateMap);
        intermediateMap.setParent(this.getActionMap(null));
        return vMap;
    }

    private static class QuitHandler {
        private QuitHandler() {
        }

        public boolean handleQuit() {
            return false;
        }
    }

    private class FrameHandler
    extends WindowAdapter
    implements PropertyChangeListener,
    Disposable {
        private JFrame frame;
        private View view;

        public FrameHandler(JFrame frame, View view) {
            this.frame = frame;
            this.view = view;
            view.addPropertyChangeListener(this);
            frame.addWindowListener(this);
            view.addDisposable(this);
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            String name = evt.getPropertyName();
            if (name.equals("hasUnsavedChanges")) {
                this.frame.getRootPane().putClientProperty("windowModified", this.view.hasUnsavedChanges());
            } else if (name.equals("uri") || name.equals("title")) {
                OSXApplication.this.updateViewTitle(this.view, this.frame);
            }
        }

        @Override
        public void windowClosing(WindowEvent evt) {
            OSXApplication.this.getAction(this.view, "file.close").actionPerformed(new ActionEvent(evt.getSource(), 1001, "windowClosing"));
        }

        @Override
        public void windowClosed(WindowEvent evt) {
        }

        @Override
        public void windowIconified(WindowEvent e) {
            if (this.view == OSXApplication.this.getActiveView()) {
                OSXApplication.this.setActiveView(null);
            }
            this.view.stop();
        }

        @Override
        public void windowDeiconified(WindowEvent e) {
            this.view.start();
        }

        @Override
        public void dispose() {
            this.frame.removeWindowListener(this);
            this.view.removePropertyChangeListener(this);
        }

        @Override
        public void windowGainedFocus(WindowEvent e) {
            OSXApplication.this.setActiveView(this.view);
        }
    }

    private class WindowMenuHandler
    implements PropertyChangeListener,
    Disposable {
        private JMenu windowMenu;
        @Nullable
        private View view;

        public WindowMenuHandler(@Nullable JMenu windowMenu, View view) {
            this.windowMenu = windowMenu;
            this.view = view;
            OSXApplication.this.addPropertyChangeListener(this);
            if (view != null) {
                view.addDisposable(this);
            }
            this.updateWindowMenu();
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            String name = evt.getPropertyName();
            if (name == "viewCount" || name == "paletteCount") {
                this.updateWindowMenu();
            }
        }

        protected void updateWindowMenu() {
            JMenu m = this.windowMenu;
            m.removeAll();
            JMenuItem mi = m.add(OSXApplication.this.getAction(this.view, "window.minimize"));
            mi.setIcon(null);
            mi = m.add(OSXApplication.this.getAction(this.view, "window.maximize"));
            mi.setIcon(null);
            m.addSeparator();
            for (View pr : OSXApplication.this.views()) {
                if (OSXApplication.this.getAction(pr, "window.focus") == null) continue;
                mi = m.add(OSXApplication.this.getAction(pr, "window.focus"));
            }
            if (OSXApplication.this.paletteActions.size() > 0) {
                m.addSeparator();
                for (Action a : OSXApplication.this.paletteActions) {
                    JCheckBoxMenuItem cbmi = new JCheckBoxMenuItem(a);
                    ActionUtil.configureJCheckBoxMenuItem(cbmi, a);
                    cbmi.setIcon(null);
                    m.add(cbmi);
                }
            }
            MenuBuilder mb = OSXApplication.this.model.getMenuBuilder();
            mb.addOtherWindowItems(m, OSXApplication.this, this.view);
        }

        @Override
        public void dispose() {
            this.windowMenu.removeAll();
            OSXApplication.this.removePropertyChangeListener(this);
            this.view = null;
        }
    }
}

