/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.app;

import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Collections;
import java.util.List;
import javax.swing.ActionMap;
import javax.swing.JToolBar;
import org.jhotdraw.app.AbstractApplicationModel;
import org.jhotdraw.app.Application;
import org.jhotdraw.app.DefaultMenuBuilder;
import org.jhotdraw.app.MenuBuilder;
import org.jhotdraw.app.View;
import org.jhotdraw.app.action.edit.ClearSelectionAction;
import org.jhotdraw.app.action.edit.CopyAction;
import org.jhotdraw.app.action.edit.CutAction;
import org.jhotdraw.app.action.edit.DeleteAction;
import org.jhotdraw.app.action.edit.DuplicateAction;
import org.jhotdraw.app.action.edit.PasteAction;
import org.jhotdraw.app.action.edit.RedoAction;
import org.jhotdraw.app.action.edit.SelectAllAction;
import org.jhotdraw.app.action.edit.UndoAction;
import org.jhotdraw.app.action.file.CloseFileAction;
import org.jhotdraw.app.action.file.NewFileAction;
import org.jhotdraw.app.action.file.OpenFileAction;
import org.jhotdraw.app.action.file.SaveFileAction;
import org.jhotdraw.app.action.file.SaveFileAsAction;

public class DefaultApplicationModel
extends AbstractApplicationModel {
    @Nullable
    private MenuBuilder menuBuilder;

    @Override
    public void initView(Application a, View v) {
    }

    @Override
    public ActionMap createActionMap(Application a, @Nullable View v) {
        ActionMap m = new ActionMap();
        m.put("file.new", new NewFileAction(a));
        m.put("file.open", new OpenFileAction(a));
        m.put("file.save", new SaveFileAction(a, v));
        m.put("file.saveAs", new SaveFileAsAction(a, v));
        m.put("file.close", new CloseFileAction(a, v));
        m.put("edit.undo", new UndoAction(a, v));
        m.put("edit.redo", new RedoAction(a, v));
        m.put("edit.cut", new CutAction());
        m.put("edit.copy", new CopyAction());
        m.put("edit.paste", new PasteAction());
        m.put("edit.delete", new DeleteAction());
        m.put("edit.duplicate", new DuplicateAction());
        m.put("edit.selectAll", new SelectAllAction());
        m.put("edit.clearSelection", new ClearSelectionAction());
        return m;
    }

    @Override
    public List<JToolBar> createToolBars(Application app, @Nullable View p) {
        return Collections.emptyList();
    }

    protected MenuBuilder createMenuBuilder() {
        return new DefaultMenuBuilder();
    }

    @Override
    public MenuBuilder getMenuBuilder() {
        if (this.menuBuilder == null) {
            this.menuBuilder = this.createMenuBuilder();
        }
        return this.menuBuilder;
    }

    public void setMenuBuilder(@Nullable MenuBuilder newValue) {
        this.menuBuilder = newValue;
    }
}

