/*
 * Decompiled with CFR 0.152.
 */
package jsat.utils;

import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicInteger;

public class ModifiableCountDownLatch {
    private Semaphore awaitSemaphore;
    private AtomicInteger count;

    public ModifiableCountDownLatch(int count) {
        this.count = new AtomicInteger(count);
        this.awaitSemaphore = new Semaphore(0);
    }

    public void await() throws InterruptedException {
        this.awaitSemaphore.acquire();
        this.awaitSemaphore.release();
    }

    public void countDown() {
        if (this.count.get() == 0) {
            return;
        }
        if (this.count.decrementAndGet() == 0) {
            this.awaitSemaphore.release();
        }
    }

    public void countUp() {
        this.count.addAndGet(1);
    }
}

