/*
 * Decompiled with CFR 0.152.
 */
package jsat.utils;

import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import jsat.utils.ClosedHashingUtil;

public final class LongDoubleMap
extends AbstractMap<Long, Double> {
    private float loadFactor;
    private int used = 0;
    private byte[] status;
    private long[] keys;
    private double[] table;

    public LongDoubleMap() {
        this(32);
    }

    public LongDoubleMap(int capacity) {
        this(capacity, 0.7f);
    }

    public LongDoubleMap(int capacity, float loadFactor) {
        if (capacity < 1) {
            throw new IllegalArgumentException("Capacity must be a positive value, not " + capacity);
        }
        if (loadFactor <= 0.0f || loadFactor >= 1.0f || Float.isNaN(loadFactor)) {
            throw new IllegalArgumentException("loadFactor must be in (0, 1), not " + loadFactor);
        }
        this.loadFactor = loadFactor;
        int size = ClosedHashingUtil.getNextPow2TwinPrime(Math.max(capacity, 3));
        this.status = new byte[size];
        this.keys = new long[size];
        this.table = new double[size];
    }

    @Override
    public int size() {
        return this.used;
    }

    @Override
    public Double put(Long key, Double value) {
        double prev = this.put((long)key, (double)value);
        if (Double.isNaN(prev)) {
            return null;
        }
        return prev;
    }

    @Override
    public double put(long key, double value) {
        if (Double.isNaN(value)) {
            throw new IllegalArgumentException("NaN is not an allowable value");
        }
        long pair_index = this.getIndex(key);
        int deletedIndex = (int)(pair_index >>> 32);
        int valOrFreeIndex = (int)(pair_index & 0xFFFFFFFFFFFFFFFFL);
        if (this.status[valOrFreeIndex] == 1) {
            double prev = this.table[valOrFreeIndex];
            this.table[valOrFreeIndex] = value;
            return prev;
        }
        double prev = Double.NaN;
        int i = valOrFreeIndex;
        if (deletedIndex >= 0) {
            i = deletedIndex;
        }
        this.status[i] = 1;
        this.keys[i] = key;
        this.table[i] = value;
        ++this.used;
        this.enlargeIfNeeded();
        return prev;
    }

    public double increment(long key, double delta) {
        if (Double.isNaN(delta)) {
            throw new IllegalArgumentException("NaN is not an allowable value");
        }
        long pair_index = this.getIndex(key);
        int deletedIndex = (int)(pair_index >>> 32);
        int valOrFreeIndex = (int)(pair_index & 0xFFFFFFFFFFFFFFFFL);
        if (this.status[valOrFreeIndex] == 1) {
            int n = valOrFreeIndex;
            double d = this.table[n] + delta;
            this.table[n] = d;
            return d;
        }
        int i = valOrFreeIndex;
        if (deletedIndex >= 0) {
            i = deletedIndex;
        }
        this.status[i] = 1;
        this.keys[i] = key;
        double toReturn = this.table[i] = delta;
        ++this.used;
        this.enlargeIfNeeded();
        return toReturn;
    }

    @Override
    public Double remove(Object key) {
        if (key instanceof Long) {
            double oldValue = this.remove((Long)key);
            if (Double.isNaN(oldValue)) {
                return null;
            }
            return oldValue;
        }
        return null;
    }

    public double remove(long key) {
        long pair_index = this.getIndex(key);
        int valOrFreeIndex = (int)(pair_index & 0xFFFFFFFFFFFFFFFFL);
        if (this.status[valOrFreeIndex] == 0) {
            return Double.NaN;
        }
        double toRet = this.table[valOrFreeIndex];
        this.status[valOrFreeIndex] = 2;
        --this.used;
        return toRet;
    }

    @Override
    public void clear() {
        this.used = 0;
        Arrays.fill(this.status, (byte)0);
    }

    private void enlargeIfNeeded() {
        if ((float)this.used < (float)this.keys.length * this.loadFactor) {
            return;
        }
        byte[] oldSatus = this.status;
        long[] oldKeys = this.keys;
        double[] oldTable = this.table;
        int newSize = ClosedHashingUtil.getNextPow2TwinPrime(this.status.length * 3 / 2);
        this.status = new byte[newSize];
        this.keys = new long[newSize];
        this.table = new double[newSize];
        this.used = 0;
        for (int oldIndex = 0; oldIndex < oldSatus.length; ++oldIndex) {
            if (oldSatus[oldIndex] != 1) continue;
            this.put(oldKeys[oldIndex], oldTable[oldIndex]);
        }
    }

    @Override
    public boolean containsKey(Object key) {
        if (key instanceof Integer) {
            return this.containsKey(((Integer)key).longValue());
        }
        if (key instanceof Long) {
            return this.containsKey((Long)key);
        }
        return false;
    }

    public boolean containsKey(long key) {
        int index = (int)(this.getIndex(key) & 0xFFFFFFFFFFFFFFFFL);
        return this.status[index] == 1;
    }

    private long getIndex(long key) {
        long extraInfo = Long.MIN_VALUE;
        int hash = LongDoubleMap.h(key);
        int i = hash % this.keys.length;
        byte satus_i = this.status[i];
        if (this.keys[i] == key && satus_i != 2 || satus_i == 0) {
            return extraInfo | (long)i;
        }
        if (extraInfo == Long.MIN_VALUE && satus_i == 2) {
            extraInfo = (long)i << 32;
        }
        int c = 1 + hash % (this.keys.length - 2);
        while (true) {
            if ((i -= c) < 0) {
                i += this.keys.length;
            }
            satus_i = this.status[i];
            if (this.keys[i] == key && satus_i != 2 || satus_i == 0) {
                return extraInfo | (long)i;
            }
            if (extraInfo != Long.MIN_VALUE || satus_i != 2) continue;
            extraInfo = (long)i << 32;
        }
    }

    public static int h(long key) {
        return ((int)(key >> 32) ^ Integer.reverseBytes((int)(key & 0xFFFFFFFFFFFFFFFFL))) & Integer.MAX_VALUE;
    }

    @Override
    public Set<Map.Entry<Long, Double>> entrySet() {
        return new EntrySet(this);
    }

    private final class EntrySet
    extends AbstractSet<Map.Entry<Long, Double>> {
        final LongDoubleMap parentRef;

        public EntrySet(LongDoubleMap parent) {
            this.parentRef = parent;
        }

        @Override
        public Iterator<Map.Entry<Long, Double>> iterator() {
            int START;
            for (START = 0; START < LongDoubleMap.this.status.length && LongDoubleMap.this.status[START] != 1; ++START) {
            }
            if (START == LongDoubleMap.this.status.length) {
                return Collections.emptyIterator();
            }
            final int startPos = START;
            return new Iterator<Map.Entry<Long, Double>>(){
                int pos;
                int prevPos;
                {
                    this.pos = startPos;
                    this.prevPos = -1;
                }

                @Override
                public boolean hasNext() {
                    return this.pos < LongDoubleMap.this.status.length;
                }

                @Override
                public Map.Entry<Long, Double> next() {
                    this.prevPos = this.pos++;
                    final int oldPos = this.prevPos;
                    while (this.pos < LongDoubleMap.this.status.length && LongDoubleMap.this.status[this.pos] != 1) {
                        ++this.pos;
                    }
                    return new Map.Entry<Long, Double>(){

                        @Override
                        public Long getKey() {
                            return LongDoubleMap.this.keys[oldPos];
                        }

                        @Override
                        public Double getValue() {
                            return LongDoubleMap.this.table[oldPos];
                        }

                        @Override
                        public Double setValue(Double value) {
                            double old = LongDoubleMap.this.table[oldPos];
                            ((LongDoubleMap)LongDoubleMap.this).table[oldPos] = value;
                            return old;
                        }
                    };
                }

                @Override
                public void remove() {
                    EntrySet.this.parentRef.remove(LongDoubleMap.this.keys[this.prevPos]);
                }
            };
        }

        @Override
        public int size() {
            return LongDoubleMap.this.used;
        }
    }
}

