/*
 * Decompiled with CFR 0.152.
 */
package jsat.utils;

import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class IntDoubleMapArray
extends AbstractMap<Integer, Double> {
    private int used = 0;
    private double[] table;

    public IntDoubleMapArray() {
        this(1);
    }

    public IntDoubleMapArray(int max_index) {
        this.table = new double[max_index];
        Arrays.fill(this.table, Double.NaN);
    }

    @Override
    public Double put(Integer key, Double value) {
        double prev = this.put((int)key, (double)value);
        if (Double.isNaN(prev)) {
            return null;
        }
        return prev;
    }

    @Override
    public double put(int key, double value) {
        if (Double.isNaN(value)) {
            throw new IllegalArgumentException("NaN is not an allowable value");
        }
        if (this.table.length <= key) {
            int oldLen = this.table.length;
            this.table = Arrays.copyOf(this.table, key + 1);
            Arrays.fill(this.table, oldLen, this.table.length, Double.NaN);
        }
        double prev = this.table[key];
        this.table[key] = value;
        if (Double.isNaN(prev)) {
            ++this.used;
        }
        return prev;
    }

    public double increment(int key, double delta) {
        if (Double.isNaN(delta)) {
            throw new IllegalArgumentException("NaN is not an allowable value");
        }
        if (this.table.length <= key) {
            this.put(key, delta);
        } else if (Double.isNaN(this.table[key])) {
            this.table[key] = delta;
            ++this.used;
        } else {
            int n = key;
            this.table[n] = this.table[n] + delta;
        }
        return this.table[key];
    }

    public double get(int key) {
        if (this.table.length <= key) {
            return Double.NaN;
        }
        return this.table[key];
    }

    @Override
    public Double get(Object key) {
        if (key == null) {
            return null;
        }
        if (key instanceof Integer) {
            double d = this.get((Integer)key);
            if (Double.isNaN(d)) {
                return null;
            }
            return d;
        }
        throw new ClassCastException("Key not of integer type");
    }

    @Override
    public Double remove(Object key) {
        if (key instanceof Integer) {
            double oldValue = this.remove((Integer)key);
            if (Double.isNaN(oldValue)) {
                return null;
            }
            return oldValue;
        }
        return null;
    }

    public double remove(int key) {
        if (this.table.length <= key) {
            return Double.NaN;
        }
        double toRet = this.table[key];
        this.table[key] = Double.NaN;
        if (!Double.isNaN(toRet)) {
            --this.used;
        }
        return toRet;
    }

    @Override
    public void clear() {
        this.used = 0;
        Arrays.fill(this.table, Double.NaN);
    }

    @Override
    public boolean containsKey(Object key) {
        if (key instanceof Integer) {
            return this.containsKey((Integer)key);
        }
        return false;
    }

    public boolean containsKey(int key) {
        if (this.table.length <= key) {
            return false;
        }
        return !Double.isNaN(this.table[key]);
    }

    @Override
    public Set<Map.Entry<Integer, Double>> entrySet() {
        return new EntrySet(this);
    }

    private final class EntrySet
    extends AbstractSet<Map.Entry<Integer, Double>> {
        final IntDoubleMapArray parentRef;

        public EntrySet(IntDoubleMapArray parentRef) {
            this.parentRef = parentRef;
        }

        @Override
        public Iterator<Map.Entry<Integer, Double>> iterator() {
            return new Iterator<Map.Entry<Integer, Double>>(){
                int curPos;
                int nexPos;
                {
                    this.nexPos = this.curPos = -1;
                }

                @Override
                public boolean hasNext() {
                    if (this.nexPos < this.curPos) {
                        return false;
                    }
                    if (this.nexPos > this.curPos && this.nexPos < IntDoubleMapArray.this.table.length) {
                        return true;
                    }
                    this.nexPos = this.curPos + 1;
                    while (this.nexPos < IntDoubleMapArray.this.table.length && Double.isNaN(IntDoubleMapArray.this.table[this.nexPos])) {
                        ++this.nexPos;
                    }
                    return this.nexPos < IntDoubleMapArray.this.table.length;
                }

                @Override
                public Map.Entry<Integer, Double> next() {
                    if (!this.hasNext()) {
                        throw new RuntimeException();
                    }
                    this.curPos = this.nexPos;
                    return new Map.Entry<Integer, Double>(){

                        @Override
                        public Integer getKey() {
                            return curPos;
                        }

                        @Override
                        public Double getValue() {
                            return IntDoubleMapArray.this.table[curPos];
                        }

                        @Override
                        public Double setValue(Double value) {
                            double old = IntDoubleMapArray.this.table[curPos];
                            ((IntDoubleMapArray)IntDoubleMapArray.this).table[curPos] = value;
                            return old;
                        }
                    };
                }

                @Override
                public void remove() {
                    ((IntDoubleMapArray)IntDoubleMapArray.this).table[this.curPos] = Double.NaN;
                    IntDoubleMapArray.this.used--;
                }
            };
        }

        @Override
        public int size() {
            return IntDoubleMapArray.this.used;
        }
    }
}

