/*
 * Decompiled with CFR 0.152.
 */
package jsat.text.stemming;

import jsat.text.stemming.Stemmer;

public class PaiceHuskStemmer
extends Stemmer {
    private static final long serialVersionUID = -5949389288166850651L;
    private static final Rule[] ARules = new Rule[]{new Rule("ia", 2, "", true, true), new Rule("a", 1, "", true, true)};
    private static final Rule[] BRules = new Rule[]{new Rule("bb", 1, "", false, true)};
    private static final Rule[] CRules = new Rule[]{new Rule("ytic", 3, "s", false, true), new Rule("ic", 2, "", false, false), new Rule("nc", 1, "t", false, false)};
    private static final Rule[] DRules = new Rule[]{new Rule("dd", 1, "", false, true), new Rule("ied", 3, "y", false, false), new Rule("ceed", 2, "ss", false, true), new Rule("eed", 1, "", false, true), new Rule("ed", 2, "", false, false), new Rule("hood", 4, "", false, false)};
    private static final Rule[] ERules = new Rule[]{new Rule("e", 1, "", false, false)};
    private static final Rule[] FRules = new Rule[]{new Rule("lief", 1, "v", false, true), new Rule("if", 2, "", false, true)};
    private static final Rule[] GRules = new Rule[]{new Rule("ing", 3, "", false, false), new Rule("iag", 3, "y", false, true), new Rule("ag", 2, "", false, false), new Rule("gg", 1, "", false, true)};
    private static final Rule[] HRules = new Rule[]{new Rule("th", 2, "", true, true), new Rule("guish", 5, "ct", false, true), new Rule("ish", 3, "", false, false)};
    private static final Rule[] IRules = new Rule[]{new Rule("i", 1, "", true, true), new Rule("i", 1, "y", false, false)};
    private static final Rule[] JRules = new Rule[]{new Rule("ij", 1, "d", false, true), new Rule("fuj", 1, "S", false, true), new Rule("uj", 1, "d", false, true), new Rule("oj", 1, "d", false, true), new Rule("hej", 1, "r", false, true), new Rule("verj", 1, "t", false, true), new Rule("misj", 2, "t", false, true), new Rule("nj", 1, "d", false, true), new Rule("j", 1, "s", false, true)};
    private static final Rule[] LRules = new Rule[]{new Rule("ifiabl", 6, "", false, true), new Rule("iabl", 4, "y", false, true), new Rule("abl", 3, "", false, false), new Rule("ibl", 3, "", false, true), new Rule("bil", 2, "l", false, false), new Rule("cl", 1, "", false, true), new Rule("iful", 4, "y", false, true), new Rule("ful", 3, "", false, false), new Rule("uf", 2, "", false, true), new Rule("ial", 3, "", false, false), new Rule("ual", 3, "", false, false), new Rule("al", 2, "", false, false), new Rule("ll", 1, "", false, true)};
    private static final Rule[] MRules = new Rule[]{new Rule("ium", 3, "", false, true), new Rule("mu", 2, "", true, true), new Rule("ism", 3, "", false, false), new Rule("mm", 1, "", false, true)};
    private static final Rule[] NRules = new Rule[]{new Rule("sion", 4, "j", false, false), new Rule("xion", 4, "ct", false, true), new Rule("ion", 3, "", false, false), new Rule("ian", 3, "", false, false), new Rule("an", 2, "", false, false), new Rule("een", 0, "", false, true), new Rule("en", 2, "", false, false), new Rule("nn", 1, "", false, true)};
    private static final Rule[] PRules = new Rule[]{new Rule("ship", 4, "", false, false), new Rule("pp", 1, "", false, true)};
    private static final Rule[] RRules = new Rule[]{new Rule("er", 2, "", false, false), new Rule("ear", 0, "", false, true), new Rule("ar", 2, "", false, true), new Rule("or", 2, "", false, false), new Rule("ur", 2, "", false, false), new Rule("rr", 1, "", false, true), new Rule("tr", 1, "", false, false), new Rule("ier", 3, "y", false, false)};
    private static final Rule[] SRules = new Rule[]{new Rule("ies", 3, "y", false, false), new Rule("sis", 2, "", false, true), new Rule("ness", 4, "", false, false), new Rule("ss", 0, "", false, true), new Rule("ous", 3, "", false, false), new Rule("us", 2, "", true, true), new Rule("s", 1, "", true, false), new Rule("s", 0, "", false, true)};
    private static final Rule[] TRules = new Rule[]{new Rule("plicat", 4, "y", false, true), new Rule("at", 2, "", false, false), new Rule("ment", 4, "", false, false), new Rule("ent", 3, "", false, false), new Rule("ant", 3, "", false, false), new Rule("ript", 2, "b", false, true), new Rule("orpt", 2, "b", false, true), new Rule("duct", 1, "", false, true), new Rule("sumpt", 2, "", false, true), new Rule("cept", 2, "iv", false, true), new Rule("olut", 2, "v", false, true), new Rule("sist", 0, "", false, true), new Rule("ist", 3, "", false, false), new Rule("tt", 1, "", false, true)};
    private static final Rule[] URules = new Rule[]{new Rule("iqu", 3, "", false, true), new Rule("ogu", 1, "", false, true)};
    private static final Rule[] VRules = new Rule[]{new Rule("siv", 3, "j", false, false), new Rule("iev", 0, "", false, true), new Rule("iv", 2, "", false, false)};
    private static final Rule[] YRules = new Rule[]{new Rule("bly", 1, "", false, false), new Rule("ily", 3, "y", false, false), new Rule("ply", 0, "", false, true), new Rule("ly", 2, "", false, false), new Rule("ogy", 1, "", false, true), new Rule("phy", 1, "", false, true), new Rule("omy", 1, "", false, true), new Rule("opy", 1, "", false, true), new Rule("ity", 3, "", false, false), new Rule("ety", 3, "", false, false), new Rule("lty", 2, "", false, true), new Rule("istry", 5, "", false, true), new Rule("ary", 3, "", false, false), new Rule("ory", 3, "", false, false), new Rule("ify", 3, "", false, true), new Rule("ncy", 2, "t", false, false), new Rule("acy", 3, "", false, false)};
    private static final Rule[] ZRules = new Rule[]{new Rule("iz", 2, "", false, false), new Rule("yz", 1, "s", false, true)};
    private static final Rule[] NoRules = new Rule[0];
    private static final Rule[][] rules = new Rule[][]{ARules, BRules, CRules, DRules, ERules, FRules, GRules, HRules, IRules, JRules, NoRules, LRules, MRules, NRules, NoRules, PRules, NoRules, RRules, SRules, TRules, URules, VRules, NoRules, NoRules, YRules, ZRules};

    private static boolean isVowel(char letter) {
        return letter == 'a' || letter == 'e' || letter == 'i' || letter == 'o' || letter == 'u';
    }

    @Override
    public String stem(String word) {
        boolean stop;
        boolean virginRound = true;
        char charOffset = "a".charAt(0);
        do {
            stop = true;
            int ruleIndex = word.charAt(word.length() - 1) - charOffset;
            if (ruleIndex < 0 || ruleIndex > rules.length) continue;
            for (Rule rule : rules[ruleIndex]) {
                String test;
                if (rule.virgin && !virginRound || (test = rule.apply(word)) == word) continue;
                word = test;
                stop = false;
                if (!rule.terminal) break;
                return word;
            }
            virginRound = false;
        } while (!stop);
        return word;
    }

    private static class Rule {
        public final String ending;
        public final int toRemove;
        public final String newEnding;
        public final boolean virgin;
        public final boolean terminal;

        public Rule(String ending, int toRemove, String newEnding, boolean virgin, boolean terminal) {
            this.ending = ending;
            this.toRemove = toRemove;
            this.newEnding = newEnding;
            this.virgin = virgin;
            this.terminal = terminal;
        }

        public String apply(String input) {
            if (input.endsWith(this.ending)) {
                if (PaiceHuskStemmer.isVowel(input.charAt(0))) {
                    if (input.length() - this.toRemove + this.newEnding.length() < 2) {
                        return input;
                    }
                } else {
                    int i;
                    if (input.length() - this.toRemove + this.newEnding.length() < 3) {
                        return input;
                    }
                    boolean noVowels = true;
                    for (i = 0; i < input.length() - this.toRemove && noVowels; ++i) {
                        if (!PaiceHuskStemmer.isVowel(input.charAt(i)) && input.charAt(i) != 'y') continue;
                        noVowels = false;
                    }
                    for (i = 0; i < this.newEnding.length() && noVowels; ++i) {
                        if (!PaiceHuskStemmer.isVowel(this.newEnding.charAt(i)) && this.newEnding.charAt(i) != 'y') continue;
                        noVowels = false;
                    }
                    if (noVowels) {
                        return input;
                    }
                }
                if (this.toRemove == 0) {
                    return new String(input);
                }
                return input.substring(0, input.length() - this.toRemove) + this.newEnding;
            }
            return input;
        }
    }
}

