/*
 * Decompiled with CFR 0.152.
 */
package jsat.parameters;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import jsat.DataSet;
import jsat.distributions.Distribution;
import jsat.distributions.empirical.kernelfunc.KernelFunction;
import jsat.linear.distancemetrics.DistanceMetric;
import jsat.math.decayrates.DecayRate;
import jsat.parameters.BooleanParameter;
import jsat.parameters.DecayRateParameter;
import jsat.parameters.DoubleParameter;
import jsat.parameters.IntParameter;
import jsat.parameters.KernelFunctionParameter;
import jsat.parameters.MetricParameter;
import jsat.parameters.ObjectParameter;

public abstract class Parameter
implements Serializable {
    private static final long serialVersionUID = -6903844587637472657L;

    public boolean requiresRetrain() {
        return true;
    }

    public boolean isWarmParameter() {
        return false;
    }

    public boolean preferredLowToHigh() {
        return false;
    }

    public abstract String getASCIIName();

    public String getName() {
        return this.getASCIIName();
    }

    public String toString() {
        return this.getName();
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public abstract String getValueString();

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Parameter other = (Parameter)obj;
        return this.getName().equals(other.getName());
    }

    public static Map<String, Parameter> toParameterMap(List<Parameter> params) {
        HashMap<String, Parameter> map = new HashMap<String, Parameter>(params.size());
        for (Parameter param : params) {
            if (map.put(param.getASCIIName(), param) != null) {
                throw new RuntimeException("Name collision, two parameters use the name '" + param.getASCIIName() + "'");
            }
            if (param.getName().equals(param.getASCIIName()) || map.put(param.getName(), param) == null) continue;
            throw new RuntimeException("Name collision, two parameters use the name '" + param.getName() + "'");
        }
        return map;
    }

    public static List<Parameter> getParamsFromMethods(Object obj) {
        return Parameter.getParamsFromMethods(obj, "");
    }

    private static List<Parameter> getParamsFromMethods(Object obj, String prefix) {
        HashMap<String, Method> getMethods = new HashMap<String, Method>();
        HashMap<String, Method> setMethods = new HashMap<String, Method>();
        for (Method method : obj.getClass().getMethods()) {
            int paramCount = method.getParameterTypes().length;
            if (method.isVarArgs() || paramCount > 1) continue;
            String name = method.getName();
            if (name.startsWith("get") && paramCount == 0) {
                getMethods.put(name.substring(3), method);
                continue;
            }
            if (name.startsWith("is") && paramCount == 0) {
                getMethods.put(name.substring(2), method);
                continue;
            }
            if (!name.startsWith("set") || paramCount != 1) continue;
            setMethods.put(name.substring(3), method);
        }
        ArrayList<Parameter> params = new ArrayList<Parameter>(Math.min(getMethods.size(), setMethods.size()));
        for (Map.Entry entry : setMethods.entrySet()) {
            Class<?> argClass;
            Class<?> retClass;
            Method setMethod = (Method)entry.getValue();
            Method getMethod = (Method)getMethods.get(entry.getKey());
            if (getMethod == null || !(retClass = getMethod.getReturnType()).equals(argClass = ((Method)entry.getValue()).getParameterTypes()[0])) continue;
            String name = Parameter.spaceCamelCase((String)entry.getKey());
            Parameter param = Parameter.getParam(obj, argClass, getMethod, setMethod, prefix + name);
            if (param == null) continue;
            params.add(param);
        }
        ArrayList<Field> fields = new ArrayList<Field>();
        for (Class<?> curClassLevel = obj.getClass(); curClassLevel != null; curClassLevel = curClassLevel.getSuperclass()) {
            fields.addAll(Arrays.asList(curClassLevel.getDeclaredFields()));
        }
        String simpleObjName = obj.getClass().getSimpleName();
        for (Field field : fields) {
            Annotation[] annotations;
            for (Annotation annotation : annotations = field.getAnnotations()) {
                if (!annotation.annotationType().equals(ParameterHolder.class)) continue;
                ParameterHolder annotationPH = (ParameterHolder)annotation;
                try {
                    field.setAccessible(true);
                    Object paramHolder = field.get(obj);
                    if (paramHolder instanceof Collection) {
                        Collection toSearch = (Collection)paramHolder;
                        for (Object paramHolderSub : toSearch) {
                            String subPreFix = paramHolderSub.getClass().getSimpleName() + "_";
                            subPreFix = annotationPH.skipSelfNamePrefix() ? prefix.replace(simpleObjName + "_", "") + subPreFix : prefix + subPreFix;
                            params.addAll(Parameter.getParamsFromMethods(paramHolderSub, subPreFix));
                        }
                        continue;
                    }
                    if (paramHolder == null) continue;
                    String subPreFix = paramHolder.getClass().getSimpleName() + "_";
                    subPreFix = annotationPH.skipSelfNamePrefix() ? prefix.replace(simpleObjName + "_", "") + subPreFix : prefix + subPreFix;
                    params.addAll(Parameter.getParamsFromMethods(paramHolder, subPreFix));
                }
                catch (IllegalArgumentException ex) {
                    Logger.getLogger(Parameter.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (IllegalAccessException ex) {
                    Logger.getLogger(Parameter.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
        return params;
    }

    private static Parameter getParam(Object targetObject, Class varClass, Method getMethod, Method setMethod, String asciiName) {
        return Parameter.getParam(targetObject, varClass, getMethod, setMethod, asciiName, null);
    }

    private static Parameter getParam(final Object targetObject, final Class varClass, final Method getMethod, final Method setMethod, final String asciiName, final String uniName) {
        boolean lowToHigh;
        boolean warm;
        WarmParameter warmAna = null;
        warmAna = setMethod.getAnnotation(WarmParameter.class);
        if (warmAna == null) {
            warmAna = getMethod.getAnnotation(WarmParameter.class);
        }
        if (warmAna != null) {
            warm = true;
            lowToHigh = warmAna.prefLowToHigh();
        } else {
            warm = false;
            lowToHigh = false;
        }
        Method tmp = null;
        try {
            tmp = targetObject.getClass().getMethod("guess" + setMethod.getName().replaceFirst("set", ""), DataSet.class);
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        final Method guessMethod = tmp;
        Parameter param = null;
        if (varClass.equals(Double.TYPE) || varClass.equals(Double.class)) {
            param = new DoubleParameter(){
                private static final long serialVersionUID = -4741218633343565521L;

                @Override
                public double getValue() {
                    try {
                        return (Double)getMethod.invoke(targetObject, new Object[0]);
                    }
                    catch (Exception exception) {
                        return Double.NaN;
                    }
                }

                @Override
                public boolean setValue(double val) {
                    try {
                        setMethod.invoke(targetObject, val);
                        return true;
                    }
                    catch (Exception exception) {
                        return false;
                    }
                }

                @Override
                public boolean isWarmParameter() {
                    return warm;
                }

                @Override
                public boolean preferredLowToHigh() {
                    return lowToHigh;
                }

                @Override
                public String getASCIIName() {
                    return asciiName;
                }

                @Override
                public String getName() {
                    if (uniName == null) {
                        return super.getName();
                    }
                    return uniName;
                }

                @Override
                public Distribution getGuess(DataSet data) {
                    if (guessMethod == null) {
                        return null;
                    }
                    try {
                        return (Distribution)guessMethod.invoke(targetObject, data);
                    }
                    catch (Exception exception) {
                        return null;
                    }
                }
            };
        } else if (varClass.equals(Integer.TYPE) || varClass.equals(Integer.class)) {
            param = new IntParameter(){
                private static final long serialVersionUID = 693593136858174197L;

                @Override
                public int getValue() {
                    try {
                        return (Integer)getMethod.invoke(targetObject, new Object[0]);
                    }
                    catch (Exception exception) {
                        return -1;
                    }
                }

                @Override
                public boolean setValue(int val) {
                    try {
                        setMethod.invoke(targetObject, val);
                        return true;
                    }
                    catch (Exception exception) {
                        return false;
                    }
                }

                @Override
                public Distribution getGuess(DataSet data) {
                    if (guessMethod == null) {
                        return null;
                    }
                    try {
                        return (Distribution)guessMethod.invoke(targetObject, data);
                    }
                    catch (Exception exception) {
                        return null;
                    }
                }

                @Override
                public boolean isWarmParameter() {
                    return warm;
                }

                @Override
                public boolean preferredLowToHigh() {
                    return lowToHigh;
                }

                @Override
                public String getASCIIName() {
                    return asciiName;
                }

                @Override
                public String getName() {
                    if (uniName == null) {
                        return super.getName();
                    }
                    return uniName;
                }
            };
        } else if (varClass.equals(Boolean.TYPE) || varClass.equals(Boolean.class)) {
            param = new BooleanParameter(){
                private static final long serialVersionUID = 8356074301252766754L;

                @Override
                public boolean getValue() {
                    try {
                        return (Boolean)getMethod.invoke(targetObject, new Object[0]);
                    }
                    catch (Exception exception) {
                        return false;
                    }
                }

                @Override
                public boolean setValue(boolean val) {
                    try {
                        setMethod.invoke(targetObject, val);
                        return true;
                    }
                    catch (Exception exception) {
                        return false;
                    }
                }

                @Override
                public String getASCIIName() {
                    return asciiName;
                }

                @Override
                public String getName() {
                    if (uniName == null) {
                        return super.getName();
                    }
                    return uniName;
                }
            };
        } else if (varClass.equals(KernelFunction.class)) {
            param = new KernelFunctionParameter(){
                private static final long serialVersionUID = -482809259476649959L;

                @Override
                public KernelFunction getObject() {
                    try {
                        return (KernelFunction)getMethod.invoke(targetObject, new Object[0]);
                    }
                    catch (Exception exception) {
                        return null;
                    }
                }

                @Override
                public boolean setObject(KernelFunction val) {
                    try {
                        setMethod.invoke(targetObject, val);
                        return true;
                    }
                    catch (Exception exception) {
                        return false;
                    }
                }
            };
        } else if (varClass.equals(DistanceMetric.class)) {
            param = new MetricParameter(){
                private static final long serialVersionUID = -2823576782267398656L;

                @Override
                public DistanceMetric getMetric() {
                    try {
                        return (DistanceMetric)getMethod.invoke(targetObject, new Object[0]);
                    }
                    catch (Exception exception) {
                        return null;
                    }
                }

                @Override
                public boolean setMetric(DistanceMetric val) {
                    try {
                        setMethod.invoke(targetObject, val);
                        return true;
                    }
                    catch (Exception exception) {
                        return false;
                    }
                }
            };
        } else if (varClass.equals(DecayRate.class)) {
            param = new DecayRateParameter(){
                private static final long serialVersionUID = 5348280386363008701L;

                @Override
                public DecayRate getObject() {
                    try {
                        return (DecayRate)getMethod.invoke(targetObject, new Object[0]);
                    }
                    catch (Exception exception) {
                        return null;
                    }
                }

                @Override
                public boolean setObject(DecayRate obj) {
                    try {
                        setMethod.invoke(targetObject, obj);
                        return true;
                    }
                    catch (Exception exception) {
                        return false;
                    }
                }

                @Override
                public String getASCIIName() {
                    return asciiName;
                }

                @Override
                public String getName() {
                    if (uniName == null) {
                        return super.getName();
                    }
                    return uniName;
                }
            };
        } else if (varClass.isEnum()) {
            param = new ObjectParameter(){
                private static final long serialVersionUID = -6245401198404522216L;

                public Object getObject() {
                    try {
                        return getMethod.invoke(targetObject, new Object[0]);
                    }
                    catch (Exception exception) {
                        return null;
                    }
                }

                public boolean setObject(Object val) {
                    try {
                        setMethod.invoke(targetObject, val);
                        return true;
                    }
                    catch (Exception exception) {
                        return false;
                    }
                }

                public List parameterOptions() {
                    return Collections.unmodifiableList(Arrays.asList(varClass.getEnumConstants()));
                }

                @Override
                public String getASCIIName() {
                    return asciiName;
                }

                @Override
                public String getName() {
                    if (uniName == null) {
                        return super.getName();
                    }
                    return uniName;
                }
            };
        }
        return param;
    }

    private static String spaceCamelCase(String in) {
        StringBuilder sb = new StringBuilder(in.length() + 5);
        for (int i = 0; i < in.length(); ++i) {
            char c = in.charAt(i);
            if (Character.isUpperCase(c)) {
                sb.append(' ');
            }
            sb.append(c);
        }
        return sb.toString().trim();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    public static @interface WarmParameter {
        public boolean prefLowToHigh();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface ParameterHolder {
        public boolean skipSelfNamePrefix() default false;
    }
}

