/*
 * Decompiled with CFR 0.152.
 */
package jsat.math;

import jsat.distributions.Normal;
import jsat.math.ContinuedFraction;
import jsat.math.MathTricks;
import jsat.math.rootfinding.RiddersMethod;

public class SpecialMath {
    public static final double EULER_MASCHERONI = 0.5772156649015329;
    private static final double digammaPosZero = 1.4616321449683622;
    private static final double[] digamma_adj_p = new double[]{6.662015538739419E-17, 8.19163626570772E-14, 3.5941136587542095E-11, -6.860373206319232E-9, 0.05718773229071207};
    private static final double[] digamma_adj_q = new double[]{6.862596697230475, 0.002471283005727189, 3.307589698304449, 0.29349871804350575, 1.0};
    private static final double[] digamma_p_2_7 = new double[]{0.008033567674289421, 8.719023917246773, 445.62745735313246, 5678.99715950205, 23638.558669011425, 32569.48965097497, 11137.290650377496};
    private static final double[] digamma_q_2_7 = new double[]{1.6342982769409489, 123.54372821590258, 2208.640392655132, 13061.4741667969, 27097.171156467353, 16271.618832894897, 1.0};
    private static final double[] digamma_p_7_70 = new double[]{1.1845172148294265E-14, -3.1152541179665734E-12, 3.376965291465974E-10, -1.9651304938765123E-8, -0.04505398537169693};
    private static final double[] digamma_q_7_70 = new double[]{-5.406558865634369, 0.00166880869763982, -2.595288371769254, 0.1463978383403392, 1.0};
    private static final double[] zetBernCoefs = new double[]{0.0, 0.08333333333333333, -0.001388888888888889, 3.306878306878307E-5, -8.267195767195768E-7, 2.08767569878681E-8, -5.284190138687493E-10, 1.3382536530684679E-11, -3.3896802963225827E-13, 8.586062056277845E-15, -2.174868698558062E-16};
    private static double[] zeta_p_special = new double[]{-5.276454584406249E-6, 1.4685004463733906E-4, -0.0029925134974932046, -0.03542393126377964, -0.2062582384669163, -0.5425801056911627, -0.500000000000001};
    private static double[] zeta_q_special = new double[]{-3.9917203368386765E-6, -1.7067854372054898E-4, -0.0029262260848543224, -0.03374331488845255, -0.21043893362112356, -0.75271685502711, 1.0};
    private static double[] zeta_p_l14 = new double[]{-8.606371251783088E-8, -1.1560557721972764E-6, -4.311666321558451E-5, -5.264895083709947E-4, -0.0068155158000014334, -0.06307250289741462, -0.29461845448391205, -0.6343060442388609, -0.5000002840119742};
    private static double[] zeta_q_l14 = new double[]{-8.618729607655165E-8, -1.1385012966414653E-6, -4.42195744615244E-5, -4.8688803587684966E-4, -0.007685890789470589, -0.05163102070747827, -0.3708878453015588, -0.5692629114261173, 1.0};
    private static final double[] reLnBn_sub_50 = new double[]{0.0, -1.791759469228055, -3.4011973816621555, -3.7376696182833684, -3.4011973816621555, -2.580216829592325, -1.3739170644113354, 0.1541506798272583, 1.9589895062337266, 4.006809010510759, 6.271223267088099, 8.731033309840043, 11.368827044456161, 14.17004522982052, 17.12233246200514, 20.215071538041073, 23.43904051180876, 26.786154464898086, 30.24926733198126, 33.82201727152227, 37.498704238944434, 41.274191791112735, 45.1438274079057, 49.10337716134638, 53.14897164114562};
    private static final ContinuedFraction lowIncGamma = new ContinuedFraction(){

        @Override
        public double getA(int pos, double ... args) {
            if (pos % 2 == 0) {
                return (double)(pos /= 2) * args[1];
            }
            pos = (pos + 0) / 2;
            return -(args[0] + (double)pos) * args[1];
        }

        @Override
        public double getB(int pos, double ... args) {
            return args[0] + (double)pos;
        }
    };
    private static final ContinuedFraction gammaQ = new ContinuedFraction(){

        @Override
        public double getA(int pos, double ... args) {
            return (double)pos * (args[0] - (double)pos);
        }

        @Override
        public double getB(int pos, double ... args) {
            return (double)(1 + pos * 2) - args[0] + args[1];
        }
    };
    private static final ContinuedFraction gammaP = new ContinuedFraction(){

        @Override
        public double getA(int pos, double ... args) {
            if (pos % 2 == 0) {
                return args[1] * (double)(pos /= 2);
            }
            pos = (pos + 1) / 2;
            return -args[1] * (args[0] + (double)pos);
        }

        @Override
        public double getB(int pos, double ... args) {
            return args[0] + (double)pos;
        }
    };
    private static final ContinuedFraction upIncGamma = new ContinuedFraction(){

        @Override
        public double getA(int pos, double ... args) {
            return (args[0] - (double)pos) * (double)pos;
        }

        @Override
        public double getB(int pos, double ... args) {
            return (double)(1 + pos * 2) - args[0] + args[1];
        }
    };
    private static final ContinuedFraction regIncBeta = new ContinuedFraction(){

        @Override
        public double getA(int pos, double ... args) {
            if (pos % 2 == 0) {
                return (double)(pos /= 2) * (args[2] - (double)pos) * args[0] / ((args[1] + (double)(2 * pos) - 1.0) * (args[1] + (double)(2 * pos)));
            }
            pos = (pos - 1) / 2;
            double numer = -(args[1] + (double)pos) * (args[1] + args[2] + (double)pos) * args[0];
            double denom = (args[1] + (double)(2 * pos)) * (args[1] + 1.0 + (double)(2 * pos));
            return numer / denom;
        }

        @Override
        public double getB(int pos, double ... args) {
            return 1.0;
        }
    };

    public static double invXlnX(double y) {
        double t;
        if (y >= 0.0 || y <= -Math.exp(-1.0)) {
            throw new ArithmeticException("Inverse value can not be computed for the range [-e^-1, 0]");
        }
        double u = y < -0.2 ? Math.log(Math.exp(-1.0) - Math.sqrt(2.0 * Math.exp(-1.0) * (y + Math.exp(-1.0)))) : 10.0;
        double previousT = 0.0;
        do {
            t = (Math.log(y / u) - u) * (u / (1.0 + u));
            u += t;
            if (t < 1.0E-8 && Math.abs(t + previousT) < 0.01 * Math.abs(t)) break;
            previousT = t;
        } while (Math.abs(t / u) < 1.0E-15);
        return Math.exp(u);
    }

    public static double gamma(double z) {
        if (z == 0.0) {
            return Double.NaN;
        }
        if (z == Double.POSITIVE_INFINITY) {
            return z;
        }
        if (z < 0.0) {
            z = -z;
            return -Math.PI / (z * SpecialMath.gamma(z) * Math.sin(Math.PI * z));
        }
        double[] p = new double[]{1.000000000190015, 76.18009172947146, -86.50532032941678, 24.01409824083091, -1.231739572450155, 0.001208650973866179, -5.395239384953E-6};
        double innerLoop = 0.0;
        for (int n = 1; n < p.length; ++n) {
            innerLoop += p[n] / (z + (double)n);
        }
        double result = p[0] + innerLoop;
        return (result *= Math.sqrt(Math.PI * 2) / z) * Math.pow(z + 5.5, z + 0.5) * Math.exp(-(z + 5.5));
    }

    public static double lnGamma(double z) {
        double x;
        if (z == Double.NEGATIVE_INFINITY) {
            return Double.NaN;
        }
        if (z == Double.POSITIVE_INFINITY) {
            return z;
        }
        if (z <= 0.0) {
            return Double.POSITIVE_INFINITY;
        }
        double ser = 0.9999999999999971;
        double[] c = new double[]{57.15623566586292, -59.59796035547549, 14.136097974741746, -0.4919138160976202, 3.399464998481189E-5, 4.652362892704858E-5, -9.837447530487956E-5, 1.580887032249125E-4, -2.1026444172410488E-4, 2.1743961811521265E-4, -1.643181065367639E-4, 8.441822398385275E-5, -2.6190838401581408E-5, 3.6899182659531625E-6};
        double y = x = z;
        double tmp = x + 5.2421875;
        tmp = (x + 0.5) * Math.log(tmp) - tmp;
        for (int j = 0; j < 14; ++j) {
            ser += c[j] / (y += 1.0);
        }
        return tmp + Math.log(2.5066282746310007 * ser / x);
    }

    public static double digamma(double x) {
        if (x == 0.0) {
            return Double.NaN;
        }
        if (x < 0.0) {
            if (Math.rint(x) == x) {
                return Double.NaN;
            }
            return SpecialMath.digamma(1.0 - x) - Math.PI / Math.tan(Math.PI * x);
        }
        if (x < 2.0) {
            return SpecialMath.digamma(x + 1.0) - 1.0 / x;
        }
        double approx = Math.log(x);
        double approxS = -1.0 / (2.0 * x);
        double approxSS = -1.0 / (12.0 * x * x);
        if (x <= 7.0) {
            return (x - 1.4616321449683622) * MathTricks.hornerPolyR(digamma_p_2_7, x) / MathTricks.hornerPolyR(digamma_q_2_7, x);
        }
        if (x <= 70.0) {
            return approx + (approxS + (approxSS + MathTricks.hornerPolyR(digamma_p_7_70, x) / MathTricks.hornerPolyR(digamma_q_7_70, x)));
        }
        if (x < 500.0) {
            return approx + (approxS + (approxSS + MathTricks.hornerPolyR(digamma_adj_p, x) / MathTricks.hornerPolyR(digamma_adj_q, x)));
        }
        return approx;
    }

    public static double zeta(double x) {
        if (x == 1.0) {
            return Double.NaN;
        }
        if (x == 0.0) {
            return -0.5;
        }
        if (x < 0.0 || Math.abs(1.0 - x) <= 0.2) {
            if (x <= 0.2 && x > -2.0) {
                return MathTricks.hornerPolyR(zeta_p_special, x) / MathTricks.hornerPolyR(zeta_q_special, x);
            }
            double otherPart = 2.0 * Math.pow(Math.PI * 2, x - 1.0) * Math.sin(1.5707963267948966 * x);
            if (x < 0.0) {
                return otherPart * Math.exp(SpecialMath.lnGamma(1.0 - x) * Math.log(SpecialMath.zeta(1.0 - x)));
            }
            return otherPart * SpecialMath.gamma(1.0 - x) * SpecialMath.zeta(1.0 - x);
        }
        if (x < 14.0) {
            return MathTricks.hornerPolyR(zeta_p_l14, x) / MathTricks.hornerPolyR(zeta_q_l14, x);
        }
        if (x < 50.0) {
            int i;
            double mul = 1.0 / (1.0 - Math.pow(2.0, 1.0 - x));
            double sumP = 0.0;
            double sumN = 0.0;
            for (i = 11; i >= 1; i -= 2) {
                sumP += Math.pow(i, -x);
            }
            for (i = 10; i >= 1; i -= 2) {
                sumN -= Math.pow(i, -x);
            }
            return mul * (sumP + sumN);
        }
        return 1.0;
    }

    public static double zeta(double x, double a) {
        int k;
        if (x == 0.0) {
            return 0.5 - a;
        }
        if (a <= 0.0) {
            return Double.NaN;
        }
        if (x == 1.0) {
            return Double.NaN;
        }
        if (a > 1.0E7 || x < 0.0 && x >= -100.0 && a >= 1000.0) {
            return (1.0 / (x - 1.0) + 1.0 / (2.0 * a)) * Math.pow(a, 1.0 - x);
        }
        if (x < 0.0) {
            double t;
            if (a <= 1.0) {
                double s = 1.0 - x;
                double sum = 0.0;
                for (int n = 1; n <= 20; ++n) {
                    sum += Math.pow(n, -s) * Math.cos(1.5707963267948966 * s - (double)(2 * n) * Math.PI * a);
                }
                return Math.exp(Math.log(2.0) + SpecialMath.lnGamma(s) - s * Math.log(Math.PI * 2)) * sum;
            }
            double m = Math.floor(a);
            if (m == a) {
                m -= 1.0;
            }
            double a_new = a - m;
            double sum = 0.0;
            for (int n = (int)(m - 1.0); n >= 0 && !((t = Math.pow((double)n + a_new, -x)) / (sum += t) < 1.0E-6); --n) {
            }
            return SpecialMath.zeta(x, a_new) - sum;
        }
        double part1 = 0.0;
        double part2 = 0.0;
        int n = 9;
        for (k = 0; k <= 9; ++k) {
            part1 += 1.0 / Math.pow(a + (double)k, x);
        }
        for (k = 1; k < zetBernCoefs.length; ++k) {
            part2 += zetBernCoefs[k] * Math.exp(-((double)k + x) * Math.log(a + 9.0) + SpecialMath.lnGamma((double)(-2 + 3 * k) + x) - SpecialMath.lnGamma((double)(-2 + 2 * k) + x));
        }
        return part1 + Math.pow(a + 9.0, 1.0 - x) / (x - 1.0) - 1.0 / (2.0 * Math.pow(a + 9.0, x)) + part2;
    }

    public static double harmonic(double n) {
        if (n == 0.0) {
            return 0.0;
        }
        if (n < 0.0) {
            return Double.NaN;
        }
        if (n < 2.0) {
            double[] era_up_4 = new double[]{6.770160435E-4, 5483.1926096, 4283.42774099, 602.59193727};
            double[] era_low_5 = new double[]{3333.39376261, 5039.82176406, 1856.44874041, 140.548664241, -1.0};
            return MathTricks.hornerPoly(era_up_4, n) / MathTricks.hornerPoly(era_low_5, n);
        }
        double h_n = Math.log(n) + 0.5772156649015329 + 1.0 / (2.0 * n);
        if (n >= 1000000.0) {
            return h_n;
        }
        double nSqrd = n * n;
        double nQuad = nSqrd * nSqrd;
        h_n += -1.0 / (12.0 * nSqrd) + 1.0 / (120.0 * nQuad);
        double n8 = nQuad * nQuad;
        double n6 = nSqrd * nQuad;
        return h_n += 1.0 / (240.0 * n8) - 1.0 / (252.0 * n6);
    }

    public static double harmonic(double n, double m) {
        if (n == 0.0) {
            return 0.0;
        }
        if (n < 0.0) {
            if (m == 0.0) {
                return n;
            }
            return Double.NaN;
        }
        if (m == 1.0) {
            return SpecialMath.harmonic(n);
        }
        return SpecialMath.zeta(m) - SpecialMath.zeta(m, n + 1.0);
    }

    public static double reLnBn(int n) {
        if (n < 0) {
            return Double.NaN;
        }
        if (n == 1) {
            return -Math.log(2.0);
        }
        if (n % 2 != 0) {
            return Double.NEGATIVE_INFINITY;
        }
        if (n >= 50) {
            double x = 0.0;
            x += (1.5 - (double)n) * Math.log(2.0);
            x += (double)n * (Math.log(3.0) - 1.0);
            x += ((double)n + 0.5) * Math.log(n);
            x += (double)n * (Math.log(40 * n * n + 3) - Math.log(120 * n * n - 1));
            return x += (0.5 - (double)n) * Math.log(Math.PI);
        }
        return reLnBn_sub_50[n / 2];
    }

    public static double bernoulli(int n) {
        if (n < 0) {
            return Double.NaN;
        }
        if (n == 0) {
            return 1.0;
        }
        if (n == 1) {
            return -0.5;
        }
        if (n % 2 != 0) {
            return 0.0;
        }
        int sign = 1;
        if (n > 2 && n % 4 == 0) {
            sign = -1;
        }
        return (double)sign * Math.exp(SpecialMath.reLnBn(n));
    }

    public static double erf(double x) {
        return 2.0 * Normal.cdf(x * Math.sqrt(2.0), 0.0, 1.0) - 1.0;
    }

    public static double invErf(double x) {
        return Normal.invcdf(x / 2.0 + 0.5, 0.0, 1.0) / Math.sqrt(2.0);
    }

    public static double erfc(double x) {
        return 2.0 * Normal.cdf(-x * Math.sqrt(2.0), 0.0, 1.0);
    }

    public static double invErfc(double x) {
        return Normal.invcdf(x / 2.0, 0.0, 1.0) / -Math.sqrt(2.0);
    }

    public static double beta(double z, double w) {
        return Math.exp(SpecialMath.lnBeta(z, w));
    }

    public static double lnBeta(double z, double w) {
        return SpecialMath.lnGamma(z) + SpecialMath.lnGamma(w) - SpecialMath.lnGamma(z + w);
    }

    public static double betaIncReg(double x, double a, double b) {
        if (a <= 0.0 || b <= 0.0) {
            throw new ArithmeticException("a and b must be > 0, not" + a + ", and " + b);
        }
        if (x == 0.0 || x == 1.0) {
            return x;
        }
        if (x < 0.0 || x > 1.0) {
            throw new ArithmeticException("x must be in the range [0,1], not " + x);
        }
        if (x > (a + 1.0) / (a + b + 2.0) || 1.0 - x < (b + 1.0) / (a + b + 2.0)) {
            return 1.0 - SpecialMath.betaIncReg(1.0 - x, b, a);
        }
        double numer = a * Math.log(x) + b * Math.log(1.0 - x) - (Math.log(a) + SpecialMath.lnBeta(a, b));
        return Math.exp(numer) / regIncBeta.lentz(x, a, b);
    }

    public static double invBetaIncReg(double p, double a, double b) {
        if (p < 0.0 || p > 1.0) {
            throw new ArithmeticException("The value p must be in the range [0,1], not" + p);
        }
        return RiddersMethod.root(0.0, 1.0, x -> SpecialMath.betaIncReg(x, a, b) - p);
    }

    public static double gammaQ(double a, double z) {
        if (z <= 0.0 || a < 0.0) {
            return Double.NaN;
        }
        if (z < a + 1.0) {
            return 1.0 - SpecialMath.gammaPSeries(a, z);
        }
        return Math.exp(a * Math.log(z) - z - SpecialMath.lnGamma(a)) / gammaQ.lentz(a, z);
    }

    public static double gammaPSeries(double a, double z) {
        double sum;
        double ap = a;
        double del = sum = 1.0 / a;
        do {
            sum += (del *= z / (ap += 1.0));
        } while (!(Math.abs(del) < Math.abs(sum) * 1.0E-15));
        return sum * Math.exp(-z + a * Math.log(z) - SpecialMath.lnGamma(a));
    }

    public static double gammaP(double a, double z) {
        if (z <= 0.0 || a < 0.0) {
            return Double.NaN;
        }
        if (z < a + 1.0) {
            return SpecialMath.gammaPSeries(a, z);
        }
        return 1.0 - SpecialMath.gammaQ(a, z);
    }

    public static double invGammaP(double p, double a) {
        double x;
        if (p < 0.0 || p > 1.0) {
            throw new ArithmeticException("Probability p must be in the range [0,1], " + p + "is not valid");
        }
        double am1 = a - 1.0;
        double lnGamA = SpecialMath.lnGamma(a);
        double afac = 1.0;
        double lna1 = 1.0;
        if (a > 1.0) {
            lna1 = Math.log(am1);
            afac = Math.exp(am1 * (lna1 - 1.0) - lnGamA);
            double pp = p < 0.5 ? p : 1.0 - p;
            double t = Math.sqrt(-2.0 * Math.log(pp));
            x = (2.30753 + t * 0.27061) / (1.0 + t * (0.99229 + t * 0.04481)) - t;
            if (p < 0.5) {
                x = -x;
            }
            x = Math.max(0.001, a * Math.pow(1.0 - 1.0 / (9.0 * a) - x / (3.0 * Math.sqrt(a)), 3.0));
        } else {
            double t = 1.0 - a * (0.253 + a * 0.12);
            x = p < t ? Math.pow(p / t, 1.0 / a) : 1.0 - Math.log(1.0 - (p - t) / (1.0 - t));
        }
        for (int j = 0; j < 12; ++j) {
            if (x <= 0.0) {
                return 0.0;
            }
            double err = SpecialMath.gammaP(a, x) - p;
            double t = a > 1.0 ? afac * Math.exp(-(x - am1) + am1 * (Math.log(x) - lna1)) : Math.exp(-x + am1 * Math.log(x) - lnGamA);
            double u = err / t;
            if ((x -= (t = u / (1.0 - 0.5 * Math.min(1.0, u * (am1 / x - 1.0))))) <= 0.0) {
                x = (x + t) / 2.0;
            }
            if (Math.abs(t) < 1.0E-8 * x) break;
        }
        return x;
    }

    public static double gammaIncUp(double a, double z) {
        if (z <= 0.0) {
            return Double.NaN;
        }
        return Math.exp(a * Math.log(z) - z) / upIncGamma.lentz(a, z);
    }

    public static double gammaIncLow(double a, double z) {
        if (z <= 0.0) {
            return Double.NaN;
        }
        return Math.exp(SpecialMath.lnLowIncGamma(a, z));
    }

    private static double lnLowIncGamma(double a, double x) {
        double term;
        double lnGa = SpecialMath.lnGamma(a);
        double lnGan = lnGa + Math.log(a);
        double n = 0.0;
        double lnXN = 0.0;
        double lnX = Math.log(x);
        double sum = term = Math.exp(lnGa - lnGan + lnXN);
        while (term > 1.0E-15) {
            term = Math.exp(lnGa - (lnGan += Math.log(a + (n += 1.0))) + (lnXN += lnX));
            sum += term;
        }
        return -x + lnX * a + Math.log(sum);
    }

    private static double lnLowIncGamma1(double a, double x) {
        double[] dArray = new double[]{a, x};
        double inter = lowIncGamma.lentz(dArray);
        if (inter <= 1.0E-16) {
            return SpecialMath.lnGamma(a);
        }
        return a * Math.log(x) - x - Math.log(inter);
    }
}

