/*
 * Decompiled with CFR 0.152.
 */
package jsat.linear.vectorcollection;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import jsat.linear.Vec;
import jsat.linear.VecPaired;
import jsat.linear.distancemetrics.DistanceMetric;
import jsat.linear.vectorcollection.VectorArray;
import jsat.utils.DoubleList;
import jsat.utils.IntList;
import jsat.utils.concurrent.ParallelUtils;

public interface VectorCollection<V extends Vec>
extends Cloneable,
Serializable {
    default public void build(List<V> collection) {
        this.build(false, collection);
    }

    default public void build(List<V> collection, DistanceMetric dm) {
        this.build(false, collection, dm);
    }

    default public void build(boolean parallel, List<V> collection) {
        this.build(parallel, collection, this.getDistanceMetric());
    }

    public void build(boolean var1, List<V> var2, DistanceMetric var3);

    public void setDistanceMetric(DistanceMetric var1);

    public DistanceMetric getDistanceMetric();

    default public List<? extends VecPaired<V, Double>> search(Vec query, double range) {
        IntList neighbors = new IntList();
        DoubleList distances = new DoubleList();
        this.search(query, range, (List<Integer>)neighbors, (List<Double>)distances);
        ArrayList<VecPaired<V, Double>> toRet = new ArrayList<VecPaired<V, Double>>();
        for (int i = 0; i < neighbors.size(); ++i) {
            toRet.add(new VecPaired<V, Double>(this.get(neighbors.getI(i)), distances.getD(i)));
        }
        return toRet;
    }

    default public List<? extends VecPaired<V, Double>> search(Vec query, int num_neighbors) {
        IntList neighbors = new IntList();
        DoubleList distances = new DoubleList();
        this.search(query, num_neighbors, (List<Integer>)neighbors, (List<Double>)distances);
        ArrayList<VecPaired<V, Double>> toRet = new ArrayList<VecPaired<V, Double>>();
        for (int i = 0; i < neighbors.size(); ++i) {
            toRet.add(new VecPaired<V, Double>(this.get(neighbors.getI(i)), distances.getD(i)));
        }
        return toRet;
    }

    public void search(Vec var1, double var2, List<Integer> var4, List<Double> var5);

    public void search(Vec var1, int var2, List<Integer> var3, List<Double> var4);

    public V get(int var1);

    public List<Double> getAccelerationCache();

    public int size();

    default public void search(List<V> Q, double r_min, double r_max, List<List<Integer>> neighbors, List<List<Double>> distances, boolean parallel) {
        VectorArray<V> vc = new VectorArray<V>(this.getDistanceMetric(), Q);
        this.search(vc, r_min, r_max, neighbors, distances, parallel);
    }

    default public void search(VectorCollection<V> Q, double r_min, double r_max, List<List<Integer>> neighbors, List<List<Double>> distances, boolean parallel) {
        neighbors.clear();
        distances.clear();
        for (int i2 = 0; i2 < Q.size(); ++i2) {
            neighbors.add(new ArrayList());
            distances.add(new ArrayList());
        }
        ParallelUtils.range(Q.size(), parallel).forEach(i -> {
            this.search((Vec)Q.get(i), r_max, (List<Integer>)((List)neighbors.get(i)), (List<Double>)((List)distances.get(i)));
            int indx = Collections.binarySearch((List)distances.get(i), r_min);
            if (indx < 0) {
                indx = -indx - 1;
            }
            ((List)neighbors.get(i)).subList(0, indx).clear();
            ((List)distances.get(i)).subList(0, indx).clear();
        });
    }

    default public void search(List<V> Q, int numNeighbors, List<List<Integer>> neighbors, List<List<Double>> distances, boolean parallel) {
        VectorArray<V> vc = new VectorArray<V>(this.getDistanceMetric(), Q);
        this.search(vc, numNeighbors, neighbors, distances, parallel);
    }

    default public void search(VectorCollection<V> Q, int numNeighbors, List<List<Integer>> neighbors, List<List<Double>> distances, boolean parallel) {
        neighbors.clear();
        distances.clear();
        for (int i2 = 0; i2 < Q.size(); ++i2) {
            neighbors.add(new ArrayList());
            distances.add(new ArrayList());
        }
        ParallelUtils.range(Q.size(), parallel).forEach(i -> this.search((Vec)Q.get(i), numNeighbors, (List<Integer>)((List)neighbors.get(i)), (List<Double>)((List)distances.get(i))));
    }

    public VectorCollection<V> clone();

    default public List<Vec> getVecs() {
        return IntStream.range(0, this.size()).mapToObj(this::get).collect(Collectors.toList());
    }
}

