/*
 * Decompiled with CFR 0.152.
 */
package jsat.linear.vectorcollection;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Stack;
import jsat.linear.Vec;

public interface IndexNode<N extends IndexNode> {
    public N getParrent();

    public double minNodeDistance(N var1);

    public double maxNodeDistance(N var1);

    default public double[] minMaxDistance(N other) {
        return new double[]{this.minNodeDistance(other), this.maxNodeDistance(other)};
    }

    public double minNodeDistance(int var1);

    default public double getParentDistance() {
        N parent = this.getParrent();
        if (parent == null) {
            return 0.0;
        }
        return parent.furthestDescendantDistance();
    }

    public double furthestPointDistance();

    public double furthestDescendantDistance();

    public int numChildren();

    public IndexNode getChild(int var1);

    public Vec getVec(int var1);

    public int numPoints();

    public int getPoint(int var1);

    default public boolean hasChildren() {
        return this.numChildren() > 0;
    }

    default public boolean allPointsInLeaves() {
        return true;
    }

    default public Iterator<Integer> DescendantIterator() {
        final Stack<IndexNode> toProcess = new Stack<IndexNode>();
        toProcess.add(this);
        return new Iterator<Integer>(){
            int curPointPos = 0;
            boolean primed = false;

            @Override
            public boolean hasNext() {
                do {
                    if (toProcess.isEmpty()) {
                        return false;
                    }
                    if (((IndexNode)toProcess.peek()).numPoints() >= this.curPointPos) {
                        IndexNode tmp = (IndexNode)toProcess.pop();
                        for (int i = 0; i < tmp.numChildren(); ++i) {
                            toProcess.add(tmp.getChild(i));
                        }
                    } else {
                        this.primed = true;
                        return true;
                    }
                    this.curPointPos = 0;
                } while (!toProcess.isEmpty());
                return false;
            }

            @Override
            public Integer next() {
                if (!this.primed && !this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.primed = false;
                return ((IndexNode)toProcess.peek()).getPoint(this.curPointPos++);
            }
        };
    }
}

