/*
 * Decompiled with CFR 0.152.
 */
package jsat.linear.distancemetrics;

import java.io.Serializable;
import java.util.List;
import jsat.linear.Vec;

public interface DistanceMetric
extends Cloneable,
Serializable {
    public double dist(Vec var1, Vec var2);

    public boolean isSymmetric();

    public boolean isSubadditive();

    public boolean isIndiscemible();

    default public boolean isValidMetric() {
        return this.isSymmetric() && this.isSubadditive() && this.isIndiscemible();
    }

    public double metricBound();

    default public boolean supportsAcceleration() {
        return false;
    }

    default public List<Double> getAccelerationCache(List<? extends Vec> vecs) {
        return this.getAccelerationCache(vecs, false);
    }

    default public List<Double> getAccelerationCache(List<? extends Vec> vecs, boolean parallel) {
        return null;
    }

    default public double dist(int a, int b, List<? extends Vec> vecs, List<Double> cache) {
        return this.dist(vecs.get(a), vecs.get(b));
    }

    default public double dist(int a, Vec b, List<? extends Vec> vecs, List<Double> cache) {
        return this.dist(a, b, this.getQueryInfo(b), vecs, cache);
    }

    default public List<Double> getQueryInfo(Vec q) {
        return null;
    }

    default public double dist(int a, Vec b, List<Double> qi, List<? extends Vec> vecs, List<Double> cache) {
        return this.dist(vecs.get(a), b);
    }

    public String toString();

    public DistanceMetric clone();
}

