/*
 * Decompiled with CFR 0.152.
 */
package jsat.distributions;

import jsat.distributions.ContinuousDistribution;
import jsat.linear.Vec;
import jsat.math.SpecialMath;

public class LogNormal
extends ContinuousDistribution {
    private static final long serialVersionUID = -6938582328705527274L;
    double mu;
    double sig;

    public LogNormal() {
        this(0.0, 1.0);
    }

    public LogNormal(double mu, double sig) {
        this.mu = mu;
        this.sig = sig;
    }

    @Override
    public double pdf(double x) {
        if (x <= 0.0) {
            return 0.0;
        }
        double num = Math.exp(-Math.pow(Math.log(x) - this.mu, 2.0) / (2.0 * this.sig * this.sig));
        double denom = x * Math.sqrt(Math.PI * 2 * this.sig * this.sig);
        return num / denom;
    }

    @Override
    public double cdf(double x) {
        if (x <= 0.0) {
            return 0.0;
        }
        return 0.5 + 0.5 * SpecialMath.erf((Math.log(x) - this.mu) / Math.sqrt(2.0 * this.sig * this.sig));
    }

    @Override
    public double invCdf(double p) {
        double expo = this.mu + Math.sqrt(2.0) * Math.sqrt(this.sig * this.sig) * SpecialMath.invErf(2.0 * p - 1.0);
        return Math.exp(expo);
    }

    @Override
    public double min() {
        return 0.0;
    }

    @Override
    public double max() {
        return Double.POSITIVE_INFINITY;
    }

    @Override
    public String getDistributionName() {
        return "LogNormal";
    }

    @Override
    public String[] getVariables() {
        return new String[]{"\u03bc", "\u03c3"};
    }

    @Override
    public double[] getCurrentVariableValues() {
        return new double[]{this.mu, this.sig};
    }

    @Override
    public void setVariable(String var, double value) {
        if (var.equals("\u03bc")) {
            this.mu = value;
        } else if (var.equals("\u03c3")) {
            if (value <= 0.0) {
                throw new ArithmeticException("Standard deviation must be > 0, not " + value);
            }
            this.sig = value;
        }
    }

    @Override
    public ContinuousDistribution clone() {
        return new LogNormal(this.mu, this.sig);
    }

    @Override
    public void setUsingData(Vec data) {
        double mean = data.mean();
        double var = data.variance();
        this.mu = Math.log(mean) - 0.5 * Math.log(1.0 + var / (mean * mean));
        this.sig = Math.sqrt(1.0 + var / (mean * mean));
    }

    @Override
    public double mean() {
        return Math.exp(this.mu + this.sig * this.sig * 0.5);
    }

    @Override
    public double median() {
        return Math.exp(this.mu);
    }

    @Override
    public double mode() {
        return Math.exp(this.mu - this.sig * this.sig);
    }

    @Override
    public double variance() {
        return Math.expm1(this.sig * this.sig) * Math.exp(2.0 * this.mu + this.sig * this.sig);
    }

    @Override
    public double skewness() {
        return (Math.exp(this.sig * this.sig) + 2.0) * Math.sqrt(Math.expm1(this.sig * this.sig));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        long temp = Double.doubleToLongBits(this.mu);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.sig);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LogNormal other = (LogNormal)obj;
        if (Double.doubleToLongBits(this.mu) != Double.doubleToLongBits(other.mu)) {
            return false;
        }
        return Double.doubleToLongBits(this.sig) == Double.doubleToLongBits(other.sig);
    }
}

