/*
 * Decompiled with CFR 0.152.
 */
package jsat.distributions;

import jsat.distributions.ContinuousDistribution;
import jsat.linear.Vec;
import jsat.math.SpecialMath;

public class Kumaraswamy
extends ContinuousDistribution {
    double a;
    double b;

    public Kumaraswamy(double a, double b) {
        this.a = a;
        this.b = b;
    }

    public Kumaraswamy() {
        this(1.0, 1.0);
    }

    @Override
    public double logPdf(double x) {
        if (x <= 0.0 || x >= 1.0) {
            return -1.7976931348623157E308;
        }
        double log_x = Math.log(x);
        return Math.log(this.a) + Math.log(this.b) + (this.a - 1.0) * log_x + (this.b - 1.0) * Math.log(1.0 - Math.exp(this.a * log_x));
    }

    @Override
    public double pdf(double x) {
        if (x <= 0.0 || x >= 1.0) {
            return 0.0;
        }
        return Math.exp(this.logPdf(x));
    }

    @Override
    public double cdf(double x) {
        return 1.0 - Math.exp(this.b * Math.log(1.0 - Math.pow(x, this.a)));
    }

    @Override
    public String getDistributionName() {
        return "Kumaraswamy";
    }

    @Override
    public String[] getVariables() {
        return new String[]{"alpha", "beta"};
    }

    @Override
    public double[] getCurrentVariableValues() {
        return new double[]{this.a, this.b};
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setVariable(String var, double value) {
        if (var.equals("alpha")) {
            if (!(value > 0.0)) throw new RuntimeException("Alpha must be > 0, not " + value);
            this.a = value;
            return;
        } else {
            if (!var.equals("beta")) return;
            if (!(value > 0.0)) throw new RuntimeException("Beta must be > 0, not " + value);
            this.b = value;
        }
    }

    @Override
    public double mean() {
        return this.b * SpecialMath.beta(1.0 + 1.0 / this.a, this.b);
    }

    @Override
    public double variance() {
        return this.b * SpecialMath.beta(1.0 + 2.0 / this.a, this.b) - Math.pow(this.b * SpecialMath.beta(1.0 + 1.0 / this.a, this.b), 2.0);
    }

    @Override
    public double skewness() {
        double m3 = this.b * SpecialMath.beta(1.0 + 3.0 / this.a, this.b);
        double var = this.variance();
        double mean = this.mean();
        return (m3 - 3.0 * mean * var - Math.pow(mean, 3.0)) / Math.pow(var, 1.5);
    }

    @Override
    public double mode() {
        if (this.a < 1.0 || this.b < 1.0 || this.a == 1.0 && this.a == this.b) {
            return Double.NaN;
        }
        return Math.pow((this.a - 1.0) / (this.a * this.b - 1.0), 1.0 / this.a);
    }

    @Override
    public Kumaraswamy clone() {
        return new Kumaraswamy(this.a, this.b);
    }

    @Override
    public void setUsingData(Vec data) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public double min() {
        return 0.0;
    }

    @Override
    public double max() {
        return 1.0;
    }
}

