/*
 * Decompiled with CFR 0.152.
 */
package jsat.distributions;

import jsat.distributions.ContinuousDistribution;
import jsat.linear.Vec;

public class Exponential
extends ContinuousDistribution {
    private static final long serialVersionUID = 1675502925386052588L;
    private double lambda;

    public Exponential() {
        this(1.0);
    }

    public Exponential(double lambda) {
        if (lambda <= 0.0) {
            throw new RuntimeException("The rate parameter must be greater than zero, not " + lambda);
        }
        this.lambda = lambda;
    }

    @Override
    public double logPdf(double x) {
        if (x < 0.0) {
            return 0.0;
        }
        return Math.log(this.lambda) + -this.lambda * x;
    }

    @Override
    public double pdf(double d) {
        if (d < 0.0) {
            return 0.0;
        }
        return this.lambda * Math.exp(-this.lambda * d);
    }

    @Override
    public double cdf(double d) {
        if (d < 0.0) {
            return 0.0;
        }
        return 1.0 - Math.exp(-this.lambda * d);
    }

    @Override
    public double invCdf(double d) {
        if (d < 0.0 || d > 1.0) {
            throw new ArithmeticException("Inverse CDF only exists on the range [0,1]");
        }
        return -Math.log(1.0 - d) / this.lambda;
    }

    @Override
    public double min() {
        return 0.0;
    }

    @Override
    public double max() {
        return Double.POSITIVE_INFINITY;
    }

    @Override
    public String getDescriptiveName() {
        return "Exponential(\u03bb=" + this.lambda + ")";
    }

    @Override
    public String getDistributionName() {
        return "Exponential";
    }

    @Override
    public String[] getVariables() {
        return new String[]{"\u03bb"};
    }

    @Override
    public void setVariable(String var, double value) {
        if (var.equals("\u03bb")) {
            if (value <= 0.0) {
                throw new RuntimeException("The rate parameter must be greater than zero");
            }
            this.lambda = value;
        }
    }

    @Override
    public ContinuousDistribution clone() {
        return new Exponential(this.lambda);
    }

    @Override
    public void setUsingData(Vec data) {
        this.lambda = 1.0 / data.mean();
        if (this.lambda <= 0.0) {
            this.lambda = 1.0;
        }
    }

    @Override
    public double[] getCurrentVariableValues() {
        return new double[]{this.lambda};
    }

    @Override
    public double mean() {
        return 1.0 / this.lambda;
    }

    @Override
    public double median() {
        return 1.0 / this.lambda * Math.log(2.0);
    }

    @Override
    public double mode() {
        return 0.0;
    }

    @Override
    public double variance() {
        return Math.pow(this.lambda, -2.0);
    }

    @Override
    public double skewness() {
        return 2.0;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        long temp = Double.doubleToLongBits(this.lambda);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Exponential other = (Exponential)obj;
        return Double.doubleToLongBits(this.lambda) == Double.doubleToLongBits(other.lambda);
    }
}

