/*
 * Decompiled with CFR 0.152.
 */
package jsat.datatransform;

import jsat.DataSet;
import jsat.classifiers.DataPoint;
import jsat.datatransform.InPlaceTransform;
import jsat.linear.Vec;

public class PNormNormalization
implements InPlaceTransform {
    private static final long serialVersionUID = 2934569881395909607L;
    private double p;

    public PNormNormalization() {
        this(2.0);
    }

    public PNormNormalization(double p) {
        if (p <= 0.0 || Double.isNaN(p)) {
            throw new IllegalArgumentException("p must be greater than zero, not " + p);
        }
        this.p = p;
    }

    @Override
    public void fit(DataSet data) {
    }

    @Override
    public DataPoint transform(DataPoint dp) {
        DataPoint dpNew = dp.clone();
        this.mutableTransform(dpNew);
        return dpNew;
    }

    @Override
    public void mutableTransform(DataPoint dp) {
        Vec vec = dp.getNumericalValues();
        double norm = vec.pNorm(this.p);
        if (norm != 0.0) {
            vec.mutableDivide(norm);
        }
    }

    @Override
    public boolean mutatesNominal() {
        return false;
    }

    @Override
    public PNormNormalization clone() {
        return new PNormNormalization(this.p);
    }
}

