/*
 * Decompiled with CFR 0.152.
 */
package jsat.clustering.kmeans;

import jsat.DataSet;
import jsat.clustering.kmeans.KernelKMeans;
import jsat.distributions.kernels.KernelTrick;
import jsat.exceptions.FailedToFitException;
import jsat.utils.concurrent.ParallelUtils;

public class LloydKernelKMeans
extends KernelKMeans {
    private static final long serialVersionUID = 1280985811243830450L;

    public LloydKernelKMeans(KernelTrick kernel) {
        super(kernel);
    }

    public LloydKernelKMeans(LloydKernelKMeans toCopy) {
        super(toCopy);
    }

    @Override
    public int[] cluster(DataSet dataSet, int K, boolean parallel, int[] designations) {
        int changed;
        if (K < 2) {
            throw new FailedToFitException("Clustering requires at least 2 clusters");
        }
        int N = dataSet.getSampleSize();
        if (designations == null) {
            designations = new int[N];
        }
        this.X = dataSet.getDataVectors();
        this.setup(K, designations, dataSet.getDataWeights());
        int[] assignments = designations;
        int iter = 0;
        do {
            changed = 0;
            ParallelUtils.run(parallel, N, (start, end) -> {
                for (int i = start; i < end; ++i) {
                    double minDist = Double.POSITIVE_INFINITY;
                    int min_indx = 0;
                    for (int k = 0; k < K; ++k) {
                        double dist_k = this.distance(i, k, assignments);
                        if (!(dist_k < minDist)) continue;
                        minDist = dist_k;
                        min_indx = k;
                    }
                    this.newDesignations[i] = min_indx;
                }
            });
            changed = ParallelUtils.run(parallel, N, (start, end) -> {
                double[] sqrdChange = new double[K];
                double[] ownerChange = new double[K];
                int localChagne = 0;
                for (int i = start; i < end; ++i) {
                    localChagne += this.updateMeansFromChange(i, assignments, sqrdChange, ownerChange);
                }
                int[] nArray = assignments;
                synchronized (assignments) {
                    this.applyMeanUpdates(sqrdChange, ownerChange);
                    // ** MonitorExit[var8_9] (shouldn't be in output)
                    return localChagne;
                }
            }, (t, u) -> t + u);
            this.updateNormConsts();
            System.arraycopy(this.newDesignations, 0, designations, 0, N);
        } while (changed > 0 && ++iter < this.maximumIterations);
        return designations;
    }

    @Override
    public int[] cluster(DataSet dataSet, int K, int[] designations) {
        int changed;
        if (K < 2) {
            throw new FailedToFitException("Clustering requires at least 2 clusters");
        }
        int N = dataSet.getSampleSize();
        if (designations == null) {
            designations = new int[N];
        }
        this.X = dataSet.getDataVectors();
        this.setup(K, designations, dataSet.getDataWeights());
        int iter = 0;
        do {
            int i;
            changed = 0;
            for (i = 0; i < N; ++i) {
                double minDist = Double.POSITIVE_INFINITY;
                int min_indx = 0;
                for (int k = 0; k < K; ++k) {
                    double dist_k = this.distance(i, k, designations);
                    if (!(dist_k < minDist)) continue;
                    minDist = dist_k;
                    min_indx = k;
                }
                this.newDesignations[i] = min_indx;
            }
            for (i = 0; i < N; ++i) {
                changed += this.updateMeansFromChange(i, designations);
            }
            this.updateNormConsts();
            System.arraycopy(this.newDesignations, 0, designations, 0, N);
        } while (changed > 0 && ++iter < this.maximumIterations);
        return designations;
    }

    @Override
    public LloydKernelKMeans clone() {
        return new LloydKernelKMeans(this);
    }
}

