/*
 * Decompiled with CFR 0.152.
 */
package jsat.clustering.evaluation.intra;

import java.util.List;
import jsat.DataSet;
import jsat.SimpleDataSet;
import jsat.classifiers.DataPoint;
import jsat.clustering.evaluation.intra.IntraClusterEvaluation;
import jsat.linear.DenseVector;
import jsat.linear.MatrixStatistics;
import jsat.linear.Vec;
import jsat.linear.distancemetrics.DistanceMetric;
import jsat.linear.distancemetrics.EuclideanDistance;

public class SoSCentroidDistance
implements IntraClusterEvaluation {
    private DistanceMetric dm;

    public SoSCentroidDistance() {
        this(new EuclideanDistance());
    }

    public SoSCentroidDistance(DistanceMetric dm) {
        this.dm = dm;
    }

    public SoSCentroidDistance(SoSCentroidDistance toCopy) {
        this(toCopy.dm.clone());
    }

    @Override
    public double evaluate(int[] designations, DataSet dataSet, int clusterID) {
        DenseVector mean = new DenseVector(dataSet.getNumNumericalVars());
        int clusterSize = 0;
        for (int i = 0; i < dataSet.getSampleSize(); ++i) {
            if (designations[i] != clusterID) continue;
            ++clusterSize;
            mean.mutableAdd(dataSet.getDataPoint(i).getNumericalValues());
        }
        ((Vec)mean).mutableDivide(clusterSize);
        double score = 0.0;
        for (int i = 0; i < dataSet.getSampleSize(); ++i) {
            if (designations[i] != clusterID) continue;
            score += Math.pow(this.dm.dist(dataSet.getDataPoint(i).getNumericalValues(), mean), 2.0);
        }
        return score;
    }

    @Override
    public double evaluate(List<DataPoint> dataPoints) {
        if (dataPoints.isEmpty()) {
            return 0.0;
        }
        Vec mean = MatrixStatistics.meanVector(new SimpleDataSet(dataPoints));
        double score = 0.0;
        for (DataPoint dp : dataPoints) {
            score += Math.pow(this.dm.dist(dp.getNumericalValues(), mean), 2.0);
        }
        return score;
    }

    @Override
    public SoSCentroidDistance clone() {
        return new SoSCentroidDistance(this);
    }
}

