/*
 * Decompiled with CFR 0.152.
 */
package jsat.clustering.dissimilarity;

import java.util.List;
import java.util.Set;
import jsat.classifiers.DataPoint;
import jsat.clustering.dissimilarity.LanceWilliamsDissimilarity;
import jsat.clustering.dissimilarity.UpdatableClusterDissimilarity;
import jsat.linear.distancemetrics.DistanceMetric;
import jsat.linear.distancemetrics.EuclideanDistance;

public class SingleLinkDissimilarity
extends LanceWilliamsDissimilarity
implements UpdatableClusterDissimilarity {
    public SingleLinkDissimilarity() {
        this(new EuclideanDistance());
    }

    public SingleLinkDissimilarity(DistanceMetric dm) {
        super(dm);
    }

    public SingleLinkDissimilarity(SingleLinkDissimilarity toCopy) {
        this(toCopy.dm.clone());
    }

    @Override
    public SingleLinkDissimilarity clone() {
        return new SingleLinkDissimilarity(this);
    }

    @Override
    public double dissimilarity(List<DataPoint> a, List<DataPoint> b) {
        double minDiss = Double.MAX_VALUE;
        for (DataPoint ai : a) {
            for (DataPoint bi : b) {
                double d;
                double tmpDist = this.distance(ai, bi);
                if (!(d < minDiss)) continue;
                minDiss = tmpDist;
            }
        }
        return minDiss;
    }

    @Override
    public double dissimilarity(Set<Integer> a, Set<Integer> b, double[][] distanceMatrix) {
        double minDiss = Double.MAX_VALUE;
        for (int ai : a) {
            for (int bi : b) {
                if (!(SingleLinkDissimilarity.getDistance(distanceMatrix, ai, bi) < minDiss)) continue;
                minDiss = SingleLinkDissimilarity.getDistance(distanceMatrix, ai, bi);
            }
        }
        return minDiss;
    }

    @Override
    public double dissimilarity(int i, int ni, int j, int nj, double[][] distanceMatrix) {
        return SingleLinkDissimilarity.getDistance(distanceMatrix, i, j);
    }

    @Override
    public double dissimilarity(int i, int ni, int j, int nj, int k, int nk, double[][] distanceMatrix) {
        return Math.min(SingleLinkDissimilarity.getDistance(distanceMatrix, i, k), SingleLinkDissimilarity.getDistance(distanceMatrix, j, k));
    }

    @Override
    public double dissimilarity(int ni, int nj, int nk, double d_ij, double d_ik, double d_jk) {
        return Math.min(d_ik, d_jk);
    }

    @Override
    protected double aConst(boolean iFlag, int ni, int nj, int nk) {
        return 0.5;
    }

    @Override
    protected double bConst(int ni, int nj, int nk) {
        return 0.0;
    }

    @Override
    protected double cConst(int ni, int nj, int nk) {
        return -0.5;
    }
}

