/*
 * Decompiled with CFR 0.152.
 */
package jsat.clustering;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.PriorityQueue;
import jsat.DataSet;
import jsat.clustering.Clusterer;
import jsat.exceptions.FailedToFitException;
import jsat.linear.Vec;
import jsat.linear.VecPaired;
import jsat.linear.distancemetrics.DistanceMetric;
import jsat.linear.distancemetrics.EuclideanDistance;
import jsat.linear.vectorcollection.DefaultVectorCollection;
import jsat.linear.vectorcollection.VectorCollection;
import jsat.linear.vectorcollection.VectorCollectionUtils;
import jsat.parameters.Parameterized;
import jsat.utils.DoubleList;
import jsat.utils.FibHeap;
import jsat.utils.IntList;
import jsat.utils.Pair;
import jsat.utils.Tuple3;
import jsat.utils.UnionFind;

public class HDBSCAN
implements Clusterer,
Parameterized {
    private DistanceMetric dm;
    private int m_pts;
    private int m_clSize;
    private VectorCollection<Vec> vc;

    public HDBSCAN() {
        this(15);
    }

    public HDBSCAN(int m_pts) {
        this(new EuclideanDistance(), m_pts);
    }

    public HDBSCAN(DistanceMetric dm, int m_pts) {
        this(dm, m_pts, m_pts, new DefaultVectorCollection<Vec>());
    }

    public HDBSCAN(DistanceMetric dm, int m_pts, VectorCollection<Vec> vcf) {
        this(dm, m_pts, m_pts, vcf);
    }

    public HDBSCAN(DistanceMetric dm, int m_pts, int m_clSize, VectorCollection<Vec> vc) {
        this.dm = dm;
        this.m_pts = m_pts;
        this.m_clSize = m_clSize;
        this.vc = vc;
    }

    public HDBSCAN(HDBSCAN toCopy) {
        this.dm = this.dm.clone();
        this.m_pts = toCopy.m_pts;
        this.m_clSize = toCopy.m_clSize;
        this.vc = toCopy.vc.clone();
    }

    public void setMinClusterSize(int m_clSize) {
        this.m_clSize = m_clSize;
    }

    public int getMinClusterSize() {
        return this.m_clSize;
    }

    public void setDistanceMetrics(DistanceMetric dm) {
        this.dm = dm;
    }

    public DistanceMetric getDistanceMetrics() {
        return this.dm;
    }

    public void setMinPoints(int m_pts) {
        this.m_pts = m_pts;
    }

    public int getMinPoints() {
        return this.m_pts;
    }

    @Override
    public HDBSCAN clone() {
        return new HDBSCAN(this);
    }

    @Override
    public int[] cluster(DataSet dataSet, boolean parallel, int[] designations) {
        if (designations == null) {
            designations = new int[dataSet.getSampleSize()];
        }
        List<Vec> X = dataSet.getDataVectors();
        int N = X.size();
        List<Double> cache = this.dm.getAccelerationCache(X, parallel);
        VectorCollection<Vec> X_vc = this.vc.clone();
        X_vc.build(parallel, X, this.dm);
        List<List<VecPaired<Vec, Double>>> allNearestNeighbors = VectorCollectionUtils.allNearestNeighbors(X_vc, X, this.m_pts, parallel);
        double[] core = new double[N];
        for (int i = 0; i < N; ++i) {
            core[i] = allNearestNeighbors.get(i).get(this.m_pts - 1).getPair();
        }
        double[] C = new double[N];
        Arrays.fill(C, Double.MAX_VALUE);
        int[] E = new int[N];
        Arrays.fill(E, -1);
        FibHeap<Integer> Q = new FibHeap<Integer>();
        ArrayList<FibHeap.FibNode<Integer>> q_nodes = new ArrayList<FibHeap.FibNode<Integer>>(N);
        for (int i = 0; i < N; ++i) {
            q_nodes.add(Q.insert(i, C[i]));
        }
        HashSet<Integer> F = new HashSet<Integer>();
        ArrayList<Tuple3<Integer, Integer, Double>> mst_edges = new ArrayList<Tuple3<Integer, Integer, Double>>(N * 2);
        while (Q.size() > 0) {
            FibHeap.FibNode node = Q.removeMin();
            int v = (Integer)node.getValue();
            q_nodes.set(v, null);
            F.add(v);
            if (E[v] >= 0) {
                mst_edges.add(new Tuple3<Integer, Integer, Double>(v, E[v], C[v]));
            }
            for (int w = 0; w < N; ++w) {
                double mutual_reach_dist_vw;
                FibHeap.FibNode w_node = (FibHeap.FibNode)q_nodes.get(w);
                if (w_node == null || !((mutual_reach_dist_vw = Math.max(core[v], Math.max(core[w], this.dm.dist(v, w, X, cache)))) < C[w])) continue;
                Q.decreaseKey(w_node, mutual_reach_dist_vw);
                C[w] = mutual_reach_dist_vw;
                E[w] = v;
            }
        }
        for (int i = 0; i < N; ++i) {
            mst_edges.add(new Tuple3<Integer, Integer, Double>(i, i, core[i]));
        }
        ArrayList<UnionFind<Integer>> ufs = new ArrayList<UnionFind<Integer>>(N);
        for (int i = 0; i < N; ++i) {
            ufs.add(new UnionFind<Integer>(i));
        }
        PriorityQueue<Tuple3<Integer, Integer, Double>> edgeQ = new PriorityQueue<Tuple3<Integer, Integer, Double>>(2 * N, (o1, o2) -> ((Double)o1.getZ()).compareTo((Double)o2.getZ()));
        edgeQ.addAll(mst_edges);
        ArrayList<IntList> currentGroups = new ArrayList<IntList>();
        for (int i = 0; i < N; ++i) {
            IntList il = new IntList(1);
            il.add(i);
            currentGroups.add(il);
        }
        int next_cluster_label = 0;
        ArrayList cluster_options = new ArrayList();
        ArrayList<DoubleList> entry_size = new ArrayList<DoubleList>();
        DoubleList birthSize = new DoubleList();
        DoubleList deathSize = new DoubleList();
        ArrayList<Pair<Integer, Integer>> children = new ArrayList<Pair<Integer, Integer>>();
        int[] map_to_cluster_label = new int[N];
        Arrays.fill(map_to_cluster_label, -1);
        while (!edgeQ.isEmpty()) {
            int i;
            DoubleList dl;
            int otherClust;
            int mergedClust;
            Tuple3 edge = (Tuple3)edgeQ.poll();
            double weight = (Double)edge.getZ();
            int from = (Integer)edge.getX();
            int to = (Integer)edge.getY();
            if (to == from) continue;
            UnionFind union_from = (UnionFind)ufs.get(from);
            UnionFind union_to = (UnionFind)ufs.get(to);
            int clust_A = (Integer)union_from.find().getItem();
            int clust_B = (Integer)union_to.find().getItem();
            UnionFind clust_A_tmp = union_from.find();
            UnionFind clust_B_tmp = union_to.find();
            union_from.union(union_to);
            int a_size = ((List)currentGroups.get(clust_A)).size();
            int b_size = ((List)currentGroups.get(clust_B)).size();
            int new_size = a_size + b_size;
            if ((Integer)union_from.find().getItem() == clust_A) {
                mergedClust = clust_A;
                otherClust = clust_B;
            } else {
                mergedClust = clust_B;
                otherClust = clust_A;
            }
            if (new_size >= this.m_clSize && a_size < this.m_clSize && b_size < this.m_clSize) {
                cluster_options.add(currentGroups.get(mergedClust));
                dl = new DoubleList(new_size);
                for (i = 0; i < new_size; ++i) {
                    dl.add(weight);
                }
                entry_size.add(dl);
                children.add(null);
                birthSize.add(weight);
                deathSize.add(Double.MAX_VALUE);
                map_to_cluster_label[mergedClust] = next_cluster_label++;
            } else if (new_size >= this.m_clSize && a_size >= this.m_clSize && b_size >= this.m_clSize) {
                deathSize.set(map_to_cluster_label[mergedClust], weight);
                deathSize.set(map_to_cluster_label[otherClust], weight);
                currentGroups.set(mergedClust, new IntList((Collection)currentGroups.get(mergedClust)));
                cluster_options.add(currentGroups.get(mergedClust));
                dl = new DoubleList(new_size);
                for (i = 0; i < new_size; ++i) {
                    dl.add(weight);
                }
                entry_size.add(dl);
                children.add(new Pair<Integer, Integer>(map_to_cluster_label[mergedClust], map_to_cluster_label[otherClust]));
                birthSize.add(weight);
                deathSize.add(Double.MAX_VALUE);
                map_to_cluster_label[mergedClust] = next_cluster_label++;
            } else if (new_size >= this.m_clSize) {
                if (map_to_cluster_label[mergedClust] == -1) {
                    int c = map_to_cluster_label[mergedClust] = map_to_cluster_label[otherClust];
                    cluster_options.set(c, currentGroups.get(mergedClust));
                    map_to_cluster_label[otherClust] = -1;
                }
                Iterator iterator = ((List)currentGroups.get(otherClust)).iterator();
                while (iterator.hasNext()) {
                    int indx = (Integer)iterator.next();
                    try {
                        ((DoubleList)entry_size.get(map_to_cluster_label[mergedClust])).add(weight);
                    }
                    catch (IndexOutOfBoundsException ex) {
                        ex.printStackTrace();
                        throw new FailedToFitException(ex);
                    }
                }
            }
            ((List)currentGroups.get(mergedClust)).addAll((Collection)currentGroups.get(otherClust));
            currentGroups.set(otherClust, null);
        }
        cluster_options.remove(cluster_options.size() - 1);
        entry_size.remove(entry_size.size() - 1);
        birthSize.remove(birthSize.size() - 1);
        deathSize.remove(deathSize.size() - 1);
        children.remove(children.size() - 1);
        double[] S = new double[cluster_options.size()];
        for (int c = 0; c < S.length; ++c) {
            double lambda_min = birthSize.getD(c);
            double lambda_max = deathSize.getD(c);
            double s = 0.0;
            Iterator clust_B = ((DoubleList)entry_size.get(c)).iterator();
            while (clust_B.hasNext()) {
                double f_x = (Double)clust_B.next();
                s += Math.min(f_x, lambda_max) - lambda_min;
            }
            S[c] = s;
        }
        boolean[] toKeep = new boolean[S.length];
        double[] S_hat = new double[cluster_options.size()];
        Arrays.fill(toKeep, true);
        ArrayDeque<Integer> notKeeping = new ArrayDeque<Integer>();
        for (int i = 0; i < S.length; ++i) {
            int ir;
            Pair child = (Pair)children.get(i);
            if (child == null) {
                S_hat[i] = S[i];
                continue;
            }
            int il = (Integer)child.getFirstItem();
            if (S[i] < S_hat[il] + S_hat[ir = ((Integer)child.getSecondItem()).intValue()]) {
                S_hat[i] = S_hat[il] + S_hat[ir];
                toKeep[i] = false;
                continue;
            }
            S_hat[i] = S[i];
            notKeeping.add(il);
            notKeeping.add(ir);
            while (!notKeeping.isEmpty()) {
                int c = (Integer)notKeeping.poll();
                toKeep[c] = false;
                Pair c_children = (Pair)children.get(c);
                if (c_children == null) continue;
                notKeeping.add((Integer)c_children.getFirstItem());
                notKeeping.add((Integer)c_children.getSecondItem());
            }
        }
        Arrays.fill(designations, 0, N, -1);
        int clusters = 0;
        for (int c = 0; c < toKeep.length; ++c) {
            if (!toKeep[c]) continue;
            Iterator iterator = ((List)cluster_options.get(c)).iterator();
            while (iterator.hasNext()) {
                int indx = (Integer)iterator.next();
                designations[indx] = clusters;
            }
            ++clusters;
        }
        return designations;
    }
}

