/*
 * Decompiled with CFR 0.152.
 */
package jsat.classifiers.neuralnetwork.activations;

import jsat.classifiers.neuralnetwork.activations.ActivationLayer;
import jsat.linear.Matrix;
import jsat.linear.Vec;
import jsat.math.MathTricks;

public class SoftmaxLayer
implements ActivationLayer {
    private static final long serialVersionUID = -6595701781466123463L;

    @Override
    public void activate(Vec input, Vec output) {
        input.copyTo(output);
        MathTricks.softmax(output, false);
    }

    @Override
    public void backprop(Vec input, Vec output, Vec delta_partial, Vec errout) {
        if (delta_partial != errout) {
            delta_partial.copyTo(errout);
        }
    }

    @Override
    public void activate(Matrix input, Matrix output, boolean rowMajor) {
        if (rowMajor) {
            for (int i = 0; i < input.rows(); ++i) {
                this.activate(input.getRowView(i), output.getRowView(i));
            }
        } else {
            for (int j = 0; j < input.cols(); ++j) {
                this.activate(input.getColumnView(j), output.getColumnView(j));
            }
        }
    }

    @Override
    public void backprop(Matrix input, Matrix output, Matrix delta_partial, Matrix errout, boolean rowMajor) {
        if (delta_partial != errout) {
            delta_partial.copyTo(errout);
        }
    }

    @Override
    public SoftmaxLayer clone() {
        return new SoftmaxLayer();
    }
}

