/*
 * Decompiled with CFR 0.152.
 */
package jsat.classifiers.boosting;

import java.util.ArrayList;
import java.util.List;
import jsat.classifiers.ClassificationDataSet;
import jsat.classifiers.boosting.LogitBoost;
import jsat.regression.Regressor;
import jsat.utils.SystemInfo;
import jsat.utils.concurrent.ParallelUtils;

public class LogitBoostPL
extends LogitBoost {
    private static final long serialVersionUID = -7932049860430324903L;

    public LogitBoostPL(Regressor baseLearner, int M) {
        super(baseLearner, M);
    }

    public LogitBoostPL(int M) {
        super(M);
    }

    @Override
    public void train(ClassificationDataSet dataSet, boolean parallel) {
        List subSets = dataSet.cvSet(SystemInfo.LogicalCores);
        this.baseLearners = new ArrayList(SystemInfo.LogicalCores * this.getMaxIterations());
        ParallelUtils.streamP(subSets.stream(), parallel).forEach(subSet -> {
            LogitBoost boost = new LogitBoost(this.baseLearner.clone(), this.getMaxIterations());
            boost.train((ClassificationDataSet)subSet);
            for (Regressor r : boost.baseLearners) {
                this.baseLearners.add(r);
            }
        });
        this.fScaleConstant = 1.0;
        if (parallel) {
            this.fScaleConstant /= (double)SystemInfo.LogicalCores;
        }
    }

    @Override
    public LogitBoostPL clone() {
        LogitBoostPL clone = new LogitBoostPL(this.getMaxIterations());
        clone.setzMax(this.getzMax());
        if (this.baseLearner != null) {
            clone.baseLearner = this.baseLearner.clone();
        }
        if (this.baseLearners != null) {
            clone.baseLearners = new ArrayList(this.baseLearners.size());
            for (Regressor r : this.baseLearners) {
                clone.baseLearners.add(r.clone());
            }
        }
        return clone;
    }
}

