/*
 * Decompiled with CFR 0.152.
 */
package jsat.classifiers.bayesian;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import jsat.classifiers.CategoricalResults;
import jsat.classifiers.ClassificationDataSet;
import jsat.classifiers.Classifier;
import jsat.classifiers.DataPoint;
import jsat.distributions.multivariate.MultivariateDistribution;
import jsat.parameters.Parameterized;
import jsat.utils.concurrent.ParallelUtils;

public class BestClassDistribution
implements Classifier,
Parameterized {
    private static final long serialVersionUID = -1746145372146154228L;
    private MultivariateDistribution baseDist;
    private List<MultivariateDistribution> dists;
    private double[] priors;
    private boolean usePriors;
    public static final boolean USE_PRIORS = true;

    public BestClassDistribution(MultivariateDistribution baseDist) {
        this(baseDist, true);
    }

    public BestClassDistribution(MultivariateDistribution baseDist, boolean usePriors) {
        this.baseDist = baseDist;
        this.usePriors = usePriors;
    }

    public BestClassDistribution(BestClassDistribution toCopy) {
        if (toCopy.priors != null) {
            this.priors = Arrays.copyOf(toCopy.priors, toCopy.priors.length);
        }
        this.baseDist = toCopy.baseDist.clone();
        if (toCopy.dists != null) {
            this.dists = new ArrayList<MultivariateDistribution>(toCopy.dists.size());
            for (MultivariateDistribution md : toCopy.dists) {
                this.dists.add(md == null ? null : md.clone());
            }
        }
    }

    public void setUsePriors(boolean usePriors) {
        this.usePriors = usePriors;
    }

    public boolean isUsePriors() {
        return this.usePriors;
    }

    @Override
    public CategoricalResults classify(DataPoint data) {
        CategoricalResults cr = new CategoricalResults(this.dists.size());
        for (int i = 0; i < this.dists.size(); ++i) {
            if (this.dists.get(i) == null) continue;
            double p = 0.0;
            try {
                p = this.dists.get(i).pdf(data.getNumericalValues());
            }
            catch (ArithmeticException arithmeticException) {
                // empty catch block
            }
            if (this.usePriors) {
                p *= this.priors[i];
            }
            cr.setProb(i, p);
        }
        cr.normalize();
        return cr;
    }

    @Override
    public void train(ClassificationDataSet dataSet, boolean parallel) {
        this.priors = dataSet.getPriors();
        this.dists = ParallelUtils.range(dataSet.getClassSize(), parallel).mapToObj(i -> {
            MultivariateDistribution dist = this.baseDist.clone();
            List<DataPoint> samp = dataSet.getSamples(i);
            if (samp.isEmpty()) {
                return null;
            }
            dist.setUsingDataList(samp);
            return dist;
        }).collect(Collectors.toList());
    }

    @Override
    public boolean supportsWeightedData() {
        return false;
    }

    @Override
    public BestClassDistribution clone() {
        return new BestClassDistribution(this);
    }
}

