/*
 * Decompiled with CFR 0.152.
 */
package jscl.math.polynomial.groebner;

import java.util.ArrayList;
import java.util.List;
import jscl.math.Generic;
import jscl.math.polynomial.Monomial;
import jscl.math.polynomial.Polynomial;

class ReducedRowEchelonForm {
    List content = new ArrayList();

    ReducedRowEchelonForm(List list) {
        this.content.addAll(list);
    }

    static List compute(List list) {
        ReducedRowEchelonForm f = new ReducedRowEchelonForm(list);
        f.compute();
        return f.content;
    }

    void compute() {
        int i;
        int n = this.content.size();
        for (i = 0; i < n; ++i) {
            this.reduce(i, false);
        }
        for (i = n - 1; i >= 0; --i) {
            this.reduce(i, true);
        }
    }

    void reduce(int pivot, boolean direction) {
        Polynomial p = this.polynomial(pivot);
        p = p.normalize().freeze();
        this.content.set(pivot, p);
        if (p.signum() == 0) {
            return;
        }
        Monomial m = p.head().monomial();
        int b = direction ? 0 : pivot + 1;
        int n = direction ? pivot : this.content.size();
        for (int i = b; i < n; ++i) {
            Polynomial q = this.polynomial(i);
            Generic a = q.coefficient(m);
            if (a.signum() == 0) continue;
            this.content.set(i, q.reduce(a, p));
        }
    }

    Polynomial polynomial(int n) {
        return (Polynomial)this.content.get(n);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("{");
        int n = this.content.size();
        for (int i = 0; i < n; ++i) {
            Polynomial p = this.polynomial(i);
            buffer.append(i > 0 ? ", " : "").append(p);
        }
        buffer.append("}");
        return buffer.toString();
    }
}

