/*
 * Decompiled with CFR 0.152.
 */
package jscl.math.polynomial.groebner;

import jscl.math.polynomial.Monomial;
import jscl.math.polynomial.Polynomial;

class Pair
implements Comparable {
    final Polynomial[] polynomial;
    final Monomial[] monomial;
    final Monomial scm;
    final int sugar;
    boolean coprime;
    boolean reduction;
    Polynomial principal;

    Pair(Polynomial p1, Polynomial p2) {
        this(new Polynomial[]{p1, p2});
        int[] nArray;
        boolean bl = this.coprime = this.monomial[0].gcd(this.monomial[1]).degree() == 0;
        if (this.monomial[0].compareTo(this.monomial[1]) < 0) {
            int[] nArray2 = new int[2];
            nArray2[0] = 0;
            nArray = nArray2;
            nArray2[1] = 1;
        } else {
            int[] nArray3 = new int[2];
            nArray3[0] = 1;
            nArray = nArray3;
            nArray3[1] = 0;
        }
        int[] index = nArray;
        this.reduction = this.monomial[index[1]].multiple(this.monomial[index[0]]);
        this.principal = this.polynomial[index[1]];
    }

    Pair(Polynomial[] polynomial) {
        this.polynomial = polynomial;
        this.monomial = new Monomial[]{polynomial[0].head().monomial(), polynomial[1].head().monomial()};
        this.scm = this.monomial[0].scm(this.monomial[1]);
        this.sugar = Math.max(polynomial[0].sugar() - polynomial[0].degree(), polynomial[1].sugar() - polynomial[1].degree()) + this.scm.degree();
    }

    public int compareTo(Pair pair) {
        int c = this.scm.compareTo(pair.scm);
        if (c < 0) {
            return -1;
        }
        if (c > 0) {
            return 1;
        }
        c = this.polynomial[1].index() - pair.polynomial[1].index();
        if (c < 0) {
            return -1;
        }
        if (c > 0) {
            return 1;
        }
        c = this.polynomial[0].index() - pair.polynomial[0].index();
        if (c < 0) {
            return -1;
        }
        if (c > 0) {
            return 1;
        }
        return 0;
    }

    public int compareTo(Object o) {
        return this.compareTo((Pair)o);
    }

    public String toString() {
        return "{" + this.polynomial[0].index() + ", " + this.polynomial[1].index() + "}, " + this.sugar + ", " + this.reduction;
    }
}

