/*
 * Decompiled with CFR 0.152.
 */
package jscl.math.polynomial;

import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import jscl.math.Expression;
import jscl.math.Generic;
import jscl.math.JSCLInteger;
import jscl.math.Literal;
import jscl.math.polynomial.Monomial;
import jscl.math.polynomial.Polynomial;
import jscl.math.polynomial.Term;

final class TreePolynomial
extends Polynomial {
    final SortedMap content = new TreeMap(this.ordering);
    int degree;
    boolean mutable = true;

    TreePolynomial(Monomial monomialFactory, Generic coefFactory) {
        super(monomialFactory, coefFactory);
    }

    @Override
    public int size() {
        return this.content.size();
    }

    @Override
    public Iterator iterator(boolean direction, Monomial current) {
        return new ContentIterator(direction, current);
    }

    Term term(Map.Entry entry) {
        return new Term((Monomial)entry.getKey(), (Generic)entry.getValue());
    }

    Term term(Monomial monomial) {
        return new Term(monomial, null){

            @Override
            public Generic coef() {
                return this.coef == null ? TreePolynomial.this.coefficient(this.monomial) : this.coef;
            }
        };
    }

    SortedMap subContent(Monomial monomial, boolean direction) {
        if (monomial == null) {
            return this.content;
        }
        return direction ? this.content.headMap(monomial) : this.content.tailMap(monomial);
    }

    @Override
    public Polynomial subtract(Polynomial polynomial) {
        if (polynomial.signum() == 0) {
            return this;
        }
        if (this.mutable) {
            TreePolynomial q = (TreePolynomial)polynomial;
            for (Map.Entry e : q.content.entrySet()) {
                Monomial m = (Monomial)e.getKey();
                Generic a = (Generic)e.getValue();
                Generic s = this.coefficient(m).subtract(a);
                if (s.signum() == 0) {
                    this.content.remove(m);
                    continue;
                }
                this.content.put(m, s);
            }
            this.degree = TreePolynomial.degree(this);
            this.sugar = Math.max(this.sugar, q.sugar);
            this.normalized = false;
            return this;
        }
        return this.copy().subtract(polynomial);
    }

    @Override
    public Polynomial multiplyAndSubtract(Generic generic, Polynomial polynomial) {
        if (generic.signum() == 0) {
            return this;
        }
        if (generic.compareTo(JSCLInteger.valueOf(1L)) == 0) {
            return this.subtract(polynomial);
        }
        if (this.mutable) {
            TreePolynomial q = (TreePolynomial)polynomial;
            for (Map.Entry e : q.content.entrySet()) {
                Monomial m = (Monomial)e.getKey();
                Generic a = ((Generic)e.getValue()).multiply(generic);
                Generic s = this.coefficient(m).subtract(a);
                if (s.signum() == 0) {
                    this.content.remove(m);
                    continue;
                }
                this.content.put(m, s);
            }
            this.degree = TreePolynomial.degree(this);
            this.sugar = Math.max(this.sugar, q.sugar);
            this.normalized = false;
            return this;
        }
        return this.copy().multiplyAndSubtract(generic, polynomial);
    }

    @Override
    public Polynomial multiplyAndSubtract(Monomial monomial, Generic generic, Polynomial polynomial) {
        if (generic.signum() == 0) {
            return this;
        }
        if (monomial.degree() == 0) {
            return this.multiplyAndSubtract(generic, polynomial);
        }
        if (this.mutable) {
            TreePolynomial q = (TreePolynomial)polynomial;
            for (Map.Entry e : q.content.entrySet()) {
                Monomial m = ((Monomial)e.getKey()).multiply(monomial);
                Generic a = ((Generic)e.getValue()).multiply(generic);
                Generic s = this.coefficient(m).subtract(a);
                if (s.signum() == 0) {
                    this.content.remove(m);
                    continue;
                }
                this.content.put(m, s);
            }
            this.degree = TreePolynomial.degree(this);
            this.sugar = Math.max(this.sugar, q.sugar + monomial.degree());
            this.normalized = false;
            return this;
        }
        return this.copy().multiplyAndSubtract(monomial, generic, polynomial);
    }

    @Override
    public Polynomial multiply(Generic generic) {
        if (generic.signum() == 0) {
            return this.valueof(JSCLInteger.valueOf(0L));
        }
        if (generic.compareTo(JSCLInteger.valueOf(1L)) == 0) {
            return this;
        }
        if (this.mutable) {
            for (Map.Entry entry : this.content.entrySet()) {
                entry.setValue(((Generic)entry.getValue()).multiply(generic));
            }
            this.normalized = false;
            return this;
        }
        return this.copy().multiply(generic);
    }

    @Override
    public Polynomial multiply(Monomial monomial) {
        if (this.defined) {
            TreePolynomial p = this.newinstance();
            for (Map.Entry e : this.content.entrySet()) {
                Monomial m = ((Monomial)e.getKey()).multiply(monomial);
                Generic a = (Generic)e.getValue();
                Generic s = p.coefficient(m).add(a);
                if (s.signum() == 0) {
                    p.content.remove(m);
                    continue;
                }
                p.content.put(m, s);
            }
            p.degree = TreePolynomial.degree(p);
            p.sugar = this.sugar + monomial.degree();
            return p;
        }
        if (monomial.degree() == 0) {
            return this;
        }
        TreePolynomial p = this.newinstance();
        for (Map.Entry e : this.content.entrySet()) {
            p.content.put(((Monomial)e.getKey()).multiply(monomial), (Generic)e.getValue());
        }
        p.degree = this.degree + monomial.degree();
        p.sugar = this.sugar + monomial.degree();
        return p;
    }

    @Override
    public Polynomial divide(Generic generic) throws ArithmeticException {
        if (generic.compareTo(JSCLInteger.valueOf(1L)) == 0) {
            return this;
        }
        if (this.mutable) {
            for (Map.Entry entry : this.content.entrySet()) {
                entry.setValue(((Generic)entry.getValue()).divide(generic));
            }
            this.normalized = false;
            return this;
        }
        return this.copy().divide(generic);
    }

    @Override
    public Polynomial divide(Monomial monomial) throws ArithmeticException {
        if (monomial.degree() == 0) {
            return this;
        }
        TreePolynomial p = this.newinstance();
        for (Map.Entry e : this.content.entrySet()) {
            p.content.put(((Monomial)e.getKey()).divide(monomial), (Generic)e.getValue());
        }
        p.degree = this.degree + monomial.degree();
        p.sugar = this.sugar + monomial.degree();
        return p;
    }

    @Override
    public Polynomial gcd(Polynomial polynomial) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int degree() {
        return this.degree;
    }

    @Override
    public Polynomial valueof(Polynomial polynomial) {
        TreePolynomial p = this.newinstance();
        p.init(polynomial);
        return p;
    }

    @Override
    public Polynomial valueof(Generic generic) {
        TreePolynomial p = this.newinstance();
        p.init(generic);
        return p;
    }

    @Override
    public Polynomial valueof(Monomial monomial) {
        TreePolynomial p = this.newinstance();
        p.init(monomial);
        return p;
    }

    @Override
    public Polynomial freeze() {
        this.mutable = false;
        return this;
    }

    @Override
    public Term head() {
        return this.content.size() > 0 ? this.term((Monomial)this.content.lastKey()) : null;
    }

    @Override
    public Term tail() {
        return this.content.size() > 0 ? this.term((Monomial)this.content.firstKey()) : null;
    }

    @Override
    public Generic coefficient(Monomial monomial) {
        Generic a = (Generic)this.content.get(monomial);
        return a == null ? this.coefficient(JSCLInteger.valueOf(0L)) : a;
    }

    void init(Polynomial polynomial) {
        TreePolynomial q = (TreePolynomial)polynomial;
        this.content.putAll(q.content);
        this.degree = q.degree;
        this.sugar = q.sugar;
    }

    void init(Expression expression) {
        int sugar = 0;
        int n = expression.size();
        for (int i = 0; i < n; ++i) {
            Literal l = expression.literal(i);
            JSCLInteger en = expression.coef(i);
            Monomial m = this.monomial(l);
            Generic a2 = this.coefficient((l = l.divide(m.literalValue())).degree() > 0 ? en.multiply(Expression.valueOf(l)) : en);
            Generic a1 = this.coefficient(m);
            Generic a = a1.add(a2);
            if (a.signum() == 0) {
                this.content.remove(m);
            } else {
                this.content.put(m, a);
            }
            sugar = Math.max(sugar, m.degree());
        }
        this.degree = TreePolynomial.degree(this);
        this.sugar = sugar;
    }

    void init(Generic generic) {
        if (generic instanceof Expression) {
            this.init((Expression)generic);
        } else {
            Generic a = this.coefficient(generic);
            if (a.signum() != 0) {
                this.content.put(this.monomial(Literal.valueOf()), a);
            }
            this.degree = 0;
            this.sugar = 0;
        }
    }

    void init(Monomial monomial) {
        this.content.put(monomial, this.coefficient(JSCLInteger.valueOf(1L)));
        this.degree = monomial.degree();
        this.sugar = monomial.degree();
    }

    protected TreePolynomial newinstance() {
        return new TreePolynomial(this.monomialFactory, this.coefFactory);
    }

    class ContentIterator
    implements Iterator {
        final boolean direction;
        final Iterator iterator;
        SortedMap map;

        ContentIterator(boolean direction, Monomial current) {
            this.direction = direction;
            if (direction) {
                this.iterator = null;
                this.map = TreePolynomial.this.subContent(current, true);
            } else {
                this.iterator = TreePolynomial.this.subContent(current, false).entrySet().iterator();
                if (current != null && TreePolynomial.this.content.containsKey(current)) {
                    this.iterator.next();
                }
            }
        }

        @Override
        public boolean hasNext() {
            return this.direction ? this.map.size() > 0 : this.iterator.hasNext();
        }

        public Object next() {
            if (this.direction) {
                Monomial m = (Monomial)this.map.lastKey();
                this.map = TreePolynomial.this.content.headMap(m);
                return TreePolynomial.this.term(m);
            }
            return TreePolynomial.this.term((Map.Entry)this.iterator.next());
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

